/*
 * Decompiled with CFR 0.152.
 */
package jrockit.mapi;

import com.bea.jvm.GarbageCollectionStrategy;
import com.bea.jvm.GarbageCollector;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.event.FinalizationEvent;
import com.bea.jvm.event.FinalizationListener;
import com.bea.jvm.event.GarbageCollectionEvent;
import com.bea.jvm.event.GarbageCollectionListener;
import com.bea.jvm.event.GarbageCollectionStrategyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import jrockit.mapi.AsyncEventProvider;
import jrockit.mapi.GCChangeEventProvider;
import jrockit.mapi.GCEventImpl;
import jrockit.mapi.GarbageCollectionStrategyImpl;
import jrockit.mapi.MemorySystemImpl;
import jrockit.vm.Access;
import jrockit.vm.Memory;

public class GarbageCollectorImpl
extends AsyncEventProvider
implements GarbageCollector {
    private static int info;
    private GCChangeEventProvider changeEventProvider;
    private static boolean markPhaseConcurrent;
    private static boolean sweepPhaseConcurrent;
    private static boolean generational;
    private static boolean compacting;
    private static boolean dynamic;
    private static boolean selfoptimizing;
    private String name;
    private static final HashMap<String, GarbageCollectionStrategyImpl> gcStates;
    private FinalizationImpl finalization = new FinalizationImpl();
    private static Collection<GarbageCollectionStrategyImpl> fullStrategies;
    private static GarbageCollectionStrategyImpl[] allStrategies;
    private MemorySystemImpl memSystem;

    private static void initGCTable() {
        allStrategies = GarbageCollectorImpl.getAllGCStrategies();
        ArrayList<GarbageCollectionStrategyImpl> arrayList = new ArrayList<GarbageCollectionStrategyImpl>(allStrategies.length);
        for (int i = 0; i < allStrategies.length; ++i) {
            GarbageCollectionStrategyImpl garbageCollectionStrategyImpl = allStrategies[i];
            if (garbageCollectionStrategyImpl.getId() != i) {
                throw new InternalError();
            }
            gcStates.put(garbageCollectionStrategyImpl.getName() + "_dev", garbageCollectionStrategyImpl);
            if (garbageCollectionStrategyImpl.getOldName() == null) continue;
            arrayList.add(garbageCollectionStrategyImpl);
            gcStates.put(garbageCollectionStrategyImpl.getName(), garbageCollectionStrategyImpl);
        }
        fullStrategies = Collections.unmodifiableCollection(arrayList);
    }

    public GarbageCollectorImpl(MemorySystemImpl memorySystemImpl) {
        this.memSystem = memorySystemImpl;
        this.name = "Dynamic GC";
    }

    public String getDescription() throws NotAvailableException {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.name);
        stringBuffer.append(" currently running strategy: ");
        stringBuffer.append(this.getGarbageCollectionStrategy().getDescription());
        return stringBuffer.toString();
    }

    public boolean isGenerational() throws NotAvailableException {
        if (this.isDynamic() && this.isSelfOptimizing()) {
            return true;
        }
        return generational;
    }

    public boolean hasCompaction() throws NotAvailableException {
        return compacting;
    }

    public boolean isIncremental() throws NotAvailableException {
        return false;
    }

    public boolean isConcurrent() throws NotAvailableException {
        if (this.isDynamic() && this.isSelfOptimizing()) {
            return true;
        }
        return markPhaseConcurrent || sweepPhaseConcurrent;
    }

    public boolean isMarkPhaseConcurrent() throws NotAvailableException {
        return markPhaseConcurrent;
    }

    public boolean isSweepPhaseConcurrent() throws NotAvailableException {
        return sweepPhaseConcurrent;
    }

    public boolean isParallel() throws NotAvailableException {
        if (this.isDynamic() && this.isSelfOptimizing()) {
            return true;
        }
        return !markPhaseConcurrent || !sweepPhaseConcurrent;
    }

    public boolean isMarkPhaseParallel() throws NotAvailableException {
        return !markPhaseConcurrent;
    }

    public boolean isSweepPhaseParallel() throws NotAvailableException {
        return !sweepPhaseConcurrent;
    }

    public boolean isDynamic() throws NotAvailableException {
        return dynamic;
    }

    public boolean isSelfOptimizing() throws NotAvailableException {
        return selfoptimizing && dynamic;
    }

    public long getTotalGarbageCollectionCount() {
        return Memory.getLong(Memory.getAddress(info + 12));
    }

    public long getLastGCEnd() {
        return Memory.getLong(Memory.getAddress(info + 4));
    }

    public long getLastGCStart() {
        return Memory.getLong(Memory.getAddress(info + 0));
    }

    public long getTotalGarbageCollectionTime() {
        return Memory.getLong(Memory.getAddress(info + 8));
    }

    public long getNurserySize() throws NotAvailableException {
        if (this.isGenerational()) {
            return GarbageCollectorImpl.getNurserySize0();
        }
        throw new NotAvailableException("The current garbage collector has no nursery.");
    }

    public void setNurserySize(long l) throws NotAvailableException {
        if (!this.isGenerational()) {
            throw new NotAvailableException("The current garbage collector has no nursery.");
        }
        GarbageCollectorImpl.setNurserySize0(l);
    }

    public native void activateCompaction(boolean var1);

    public void suggestGarbageCollector(String string) throws NotAvailableException {
        GarbageCollectionStrategyImpl garbageCollectionStrategyImpl;
        if (string != null && (garbageCollectionStrategyImpl = gcStates.get(string)).getId() != GarbageCollectorImpl.getCurrentGCState()) {
            GarbageCollectorImpl.suggestGarbageCollectorState0(garbageCollectionStrategyImpl.getId());
            return;
        }
        throw new NotAvailableException("The garbage collector you specified were not available, please specify an available collector if you want to switch gc-mode.");
    }

    public void addGarbageCollectionListener(GarbageCollectionListener garbageCollectionListener) {
        this.addListener(garbageCollectionListener);
    }

    public void removeGarbageCollectionListener(GarbageCollectionListener garbageCollectionListener) {
        this.removeListener(garbageCollectionListener);
    }

    public void reportFinalization(Object object, Throwable throwable) {
        this.finalization.reportFinalization(object, throwable);
    }

    public void addFinalizationListener(FinalizationListener finalizationListener) throws NotAvailableException {
        this.addFinalizationListener(finalizationListener, false);
    }

    public void addFinalizationListener(FinalizationListener finalizationListener, boolean bl) {
        boolean bl2 = !this.finalization.shouldSendEvent();
        this.finalization.addListener(new FinListHolder(finalizationListener, bl));
        if (bl2) {
            Access.lang().setGCImpl(this);
        }
    }

    public void removeFinalizationListener(FinalizationListener finalizationListener) throws NotAvailableException {
        this.finalization.removeListener(finalizationListener);
        if (!this.finalization.shouldSendEvent()) {
            Access.lang().setGCImpl(null);
        }
    }

    public StringBuffer toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getDescription());
        stringBuffer.append(" total gc count: ");
        stringBuffer.append(this.getTotalGarbageCollectionCount());
        stringBuffer.append(" total gc time: ");
        stringBuffer.append(this.getTotalGarbageCollectionTime());
        return stringBuffer;
    }

    protected AsyncEventProvider.EventThread createEventThread(ThreadGroup threadGroup) {
        return new GCEventThread(threadGroup);
    }

    private static int getGCType() {
        return Memory.getInt(Memory.getAddress(info + 16));
    }

    public Collection getGarbageCollectionStrategies() throws NotAvailableException {
        if (this.isDynamic()) {
            return fullStrategies;
        }
        ArrayList<GarbageCollectionStrategy> arrayList = new ArrayList<GarbageCollectionStrategy>(1);
        arrayList.add(this.getGarbageCollectionStrategy());
        return arrayList;
    }

    public GarbageCollectionStrategy getGarbageCollectionStrategy() throws NotAvailableException {
        return allStrategies[GarbageCollectorImpl.getCurrentGCState()];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void suggestGarbageCollectionStrategy(GarbageCollectionStrategy garbageCollectionStrategy) throws NotAvailableException {
        if (garbageCollectionStrategy != null && !this.getGarbageCollectionStrategies().contains(garbageCollectionStrategy)) {
            throw new NotAvailableException("You need to select one of the strategies returned by getGarbageCollectionStrategies! Cannot choose the selected strategy!");
        }
        if (garbageCollectionStrategy == this.getGarbageCollectionStrategy()) {
            return;
        }
        if (garbageCollectionStrategy == null) {
            if (!this.isDynamic()) throw new NotAvailableException("Optimized mode not available if not in dynamic mode!");
            GarbageCollectorImpl.suggestGarbageCollectorState0(0);
            return;
        } else {
            if (!(garbageCollectionStrategy instanceof GarbageCollectionStrategyImpl)) throw new IllegalArgumentException();
            GarbageCollectorImpl.suggestGarbageCollectorState0(((GarbageCollectionStrategyImpl)garbageCollectionStrategy).getId());
        }
    }

    public void addGarbageCollectionStrategyChangeListener(GarbageCollectionStrategyChangeListener garbageCollectionStrategyChangeListener) throws NotAvailableException {
        this.getChangeEventProvider().addListener(garbageCollectionStrategyChangeListener);
    }

    public void removeGarbageCollectionStrategyChangeListener(GarbageCollectionStrategyChangeListener garbageCollectionStrategyChangeListener) throws NotAvailableException {
        this.getChangeEventProvider().removeListener(garbageCollectionStrategyChangeListener);
    }

    static GarbageCollectionStrategyImpl getStrategy(int n) {
        return allStrategies[n];
    }

    private synchronized GCChangeEventProvider getChangeEventProvider() {
        if (this.changeEventProvider == null) {
            this.changeEventProvider = new GCChangeEventProvider(this);
        }
        return this.changeEventProvider;
    }

    private static native int waitForEvent();

    private static native long getNurserySize0();

    private static native void setNurserySize0(long var0);

    private static native int init();

    private static native void suggestGarbageCollectorState0(int var0);

    private static native int getCurrentGCState();

    private static native GarbageCollectionStrategyImpl[] getAllGCStrategies();

    protected void sendEvent(Object object, Object object2) {
        ((GarbageCollectionListener)object).onGarbageCollection((GarbageCollectionEvent)object2);
    }

    static {
        gcStates = new HashMap();
        info = GarbageCollectorImpl.init();
        GarbageCollectorImpl.initGCTable();
    }

    private static class FinalizationImpl
    extends AsyncEventProvider {
        final Object queueLock = new Object();
        LinkedFinalizationEvent eventQueue;

        private FinalizationImpl() {
        }

        protected AsyncEventProvider.EventThread createEventThread(ThreadGroup threadGroup) {
            return new FinalizationEventThread(threadGroup);
        }

        protected void sendEvent(Object object, Object object2) {
            FinListHolder finListHolder = (FinListHolder)object;
            LinkedFinalizationEvent linkedFinalizationEvent = (LinkedFinalizationEvent)((Object)object2);
            if (linkedFinalizationEvent.getCauseOfFailure() != null || !finListHolder.onlyFailed()) {
                finListHolder.listener().onObjectFinalization((FinalizationEvent)linkedFinalizationEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reportFinalization(Object object, Throwable throwable) {
            if (this.shouldSendEvent()) {
                LinkedFinalizationEvent linkedFinalizationEvent = new LinkedFinalizationEvent(object, throwable);
                Object object2 = this.queueLock;
                synchronized (object2) {
                    linkedFinalizationEvent.setNext(this.eventQueue);
                    this.eventQueue = linkedFinalizationEvent;
                    this.queueLock.notifyAll();
                }
            }
        }

        class FinalizationEventThread
        extends AsyncEventProvider.EventThread {
            LinkedFinalizationEvent current;

            public FinalizationEventThread(ThreadGroup threadGroup) {
                super(threadGroup, "Finalization event thread");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object getNextEvent() {
                while (true) {
                    Object object;
                    if (this.current != null) {
                        object = this.current;
                        this.current = this.current.getNext();
                        return object;
                    }
                    object = FinalizationImpl.this.queueLock;
                    synchronized (object) {
                        while (FinalizationImpl.this.eventQueue == null) {
                            try {
                                FinalizationImpl.this.queueLock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        this.current = FinalizationImpl.this.eventQueue;
                        FinalizationImpl.this.eventQueue = null;
                    }
                }
            }
        }

        static class LinkedFinalizationEvent
        extends FinalizationEvent {
            private LinkedFinalizationEvent next;

            public LinkedFinalizationEvent getNext() {
                return this.next;
            }

            public void setNext(LinkedFinalizationEvent linkedFinalizationEvent) {
                this.next = linkedFinalizationEvent;
            }

            public LinkedFinalizationEvent(Object object, Throwable throwable) {
                super(object, throwable);
            }
        }
    }

    static final class FinListHolder {
        FinalizationListener listener;
        boolean onlyFailed;

        public FinListHolder(FinalizationListener finalizationListener, boolean bl) {
            this.listener = finalizationListener;
            this.onlyFailed = bl;
        }

        public boolean onlyFailed() {
            return this.onlyFailed;
        }

        public FinalizationListener listener() {
            return this.listener;
        }

        public boolean equals(Object object) {
            if (object instanceof FinListHolder) {
                return ((FinListHolder)object).listener == this.listener;
            }
            if (object instanceof FinalizationListener) {
                return (FinalizationListener)object == this.listener;
            }
            return false;
        }
    }

    private class GCEventThread
    extends AsyncEventProvider.EventThread {
        private int event;

        public GCEventThread(ThreadGroup threadGroup) {
            super(threadGroup, "GC event thread");
            this.event = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object getNextEvent() {
            while (this.event == 0) {
                this.event = GarbageCollectorImpl.waitForEvent();
            }
            GCEventImpl gCEventImpl = null;
            int n = this.event;
            try {
                int n2 = Memory.getInt(n, 68);
                this.event = Memory.getAddress(this.event, 64);
                gCEventImpl = new GCEventImpl(GarbageCollectorImpl.this, n2 == 0 ? 1 : 0, Memory.getLong(n, 0), Memory.getLong(n, 8), Memory.getLong(n, 16), Memory.getLong(n, 24), Memory.getLong(n, 32), Memory.getLong(n, 40), Memory.getLong(n, 48), Memory.getLong(n, 56));
            }
            finally {
                if (n != 0) {
                    Memory.freeMemory(n);
                }
            }
            return gCEventImpl;
        }
    }
}

