/*
 * Decompiled with CFR 0.152.
 */
package jrockit.mapi;

import com.bea.jvm.ClassLibrary;
import com.bea.jvm.CompilationSystem;
import com.bea.jvm.JVM;
import com.bea.jvm.Machine;
import com.bea.jvm.MemorySystem;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.OperatingSystem;
import com.bea.jvm.ProfilingSystem;
import com.bea.jvm.ThreadSystem;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import jrockit.mapi.CPUImpl;
import jrockit.mapi.ClassLibraryImpl;
import jrockit.mapi.CompilationSystemImpl;
import jrockit.mapi.MachineImpl;
import jrockit.mapi.MemorySystemImpl;
import jrockit.mapi.OperatingSystemImpl;
import jrockit.mapi.ProfilingSystemImpl;
import jrockit.mapi.ThreadSystemImpl;
import jrockit.mapi.Toolkit;
import sun.management.counter.StringCounter;

public class JVMImpl
implements JVM {
    private static final int JVM_LOAD_ID = -1;
    private static boolean isInitialized = false;
    public static final String UNKNOWN_PROPERTY = "Unknown";
    private boolean useEmulation;
    private ThreadSystemImpl threadSystem;
    private MemorySystemImpl memorySystem;
    private ClassLibraryImpl classLibrary;
    private OperatingSystemImpl operatingSystem;
    private MachineImpl machine;
    private ProfilingSystemImpl profilingSystem;
    private CompilationSystemImpl compiler;
    private String m_initArgs;
    private String m_javaCommand;

    public JVMImpl() {
        Toolkit.checkCreate();
    }

    public ThreadSystem getThreadSystem() throws NotAvailableException {
        if (this.threadSystem == null) {
            this.threadSystem = new ThreadSystemImpl();
        }
        return this.threadSystem;
    }

    public MemorySystem getMemorySystem() throws NotAvailableException {
        if (this.memorySystem == null) {
            this.memorySystem = new MemorySystemImpl();
        }
        return this.memorySystem;
    }

    public ClassLibrary getClassLibrary() throws NotAvailableException {
        if (this.classLibrary == null) {
            this.classLibrary = new ClassLibraryImpl();
        }
        return this.classLibrary;
    }

    public OperatingSystem getOperatingSystem() throws NotAvailableException {
        if (this.operatingSystem == null) {
            this.operatingSystem = new OperatingSystemImpl();
        }
        return this.operatingSystem;
    }

    public Machine getMachine() throws NotAvailableException {
        if (this.machine == null) {
            this.machine = new MachineImpl();
        }
        return this.machine;
    }

    public ProfilingSystem getProfilingSystem() throws NotAvailableException {
        if (this.profilingSystem == null) {
            this.profilingSystem = new ProfilingSystemImpl();
        }
        return this.profilingSystem;
    }

    public CompilationSystem getCompilationSystem() throws NotAvailableException {
        if (this.compiler == null) {
            this.compiler = new CompilationSystemImpl();
        }
        return this.compiler;
    }

    public String getVendor() throws NotAvailableException {
        return this.getPrivProperty("java.vm.vendor");
    }

    public String getVersion() throws NotAvailableException {
        return this.getPrivProperty("java.vm.version");
    }

    public String getName() throws NotAvailableException {
        return this.getPrivProperty("java.vm.name");
    }

    public Collection getProcessAffinity() throws NotAvailableException {
        return CPUImpl.getProcessAffinity();
    }

    public void suggestProcessAffinity(Collection collection) throws NotAvailableException {
        CPUImpl.suggestProcessAffinity(collection);
    }

    public long getStartTime() {
        return CPUImpl.getStartTime();
    }

    public synchronized double getJVMLoad() {
        if (!isInitialized) {
            this.initialize();
            isInitialized = true;
        }
        return JVMImpl.getJVMProcessLoad();
    }

    public String getDescription() {
        return "BEA JRockit(R) Java Virtual Machine";
    }

    private String getPrivProperty(String string) {
        final String string2 = string;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string2, JVMImpl.UNKNOWN_PROPERTY);
            }
        });
    }

    public String getJVMInitArgs() {
        if (this.m_initArgs == null) {
            try {
                StringCounter stringCounter = Toolkit.getPrivilegedStringCounter("java.rt.vmArgs");
                this.m_initArgs = (String)stringCounter.getValue();
            }
            catch (Throwable throwable) {
                throw new UnsupportedOperationException("Error: Could not find or intitialize counter for java.rt.vmArgs.", throwable);
            }
        }
        return this.m_initArgs;
    }

    public String getJavaCommandLine() {
        if (this.m_javaCommand == null) {
            try {
                StringCounter stringCounter = Toolkit.getPrivilegedStringCounter("sun.rt.javaCommand");
                this.m_javaCommand = (String)stringCounter.getValue();
            }
            catch (Throwable throwable) {
                throw new UnsupportedOperationException("Error: Could not find or intitialize counter for java.rt.vmArgs.", throwable);
            }
        }
        return this.m_javaCommand;
    }

    private static native double getJVMProcessLoad();

    private native void initialize();
}

