/*
 * Decompiled with CFR 0.152.
 */
package jrockit.mapi;

import com.bea.jvm.NotAvailableException;
import com.bea.jvm.OptimizationLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jrockit.mapi.DescribableImpl;
import jrockit.mapi.OptimizationImpl;

public class OptimizationLevelImpl
extends DescribableImpl
implements OptimizationLevel {
    private final int level;
    private final ArrayList opts;
    public static final List ALL_OPTIMIZATIONS;
    public static final OptimizationLevelImpl QUICK;
    public static final OptimizationLevelImpl NORMAL;
    public static final OptimizationLevelImpl OPTIMIZED;
    private static OptimizationLevelImpl[] levels;

    protected OptimizationLevelImpl(ArrayList arrayList, int n) {
        super(arrayList.size() * 40);
        this.opts = arrayList;
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    public Collection getOptimizations() {
        return this.opts;
    }

    public StringBuffer toString(StringBuffer stringBuffer) {
        stringBuffer.append("OptimizationLevel ");
        stringBuffer.append(this.level);
        if (this.opts.size() > 0) {
            stringBuffer.append(":\n");
            for (OptimizationImpl optimizationImpl : this.opts) {
                stringBuffer.append('\t');
                stringBuffer.append(optimizationImpl.getDescription());
                stringBuffer.append('\n');
            }
        }
        return stringBuffer;
    }

    public static OptimizationLevelImpl getOptimizationLevel(int n) throws NotAvailableException {
        try {
            return levels[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NotAvailableException("No such level!");
        }
    }

    static {
        ArrayList<OptimizationLevelImpl> arrayList = new ArrayList<OptimizationLevelImpl>(3);
        arrayList.add(QUICK);
        arrayList.add(NORMAL);
        arrayList.add(OPTIMIZED);
        ALL_OPTIMIZATIONS = Collections.unmodifiableList(arrayList);
        QUICK = new OptimizationLevelImpl(new ArrayList(0), 1);
        NORMAL = new OptimizationLevelImpl(new ArrayList(0), 0);
        OPTIMIZED = new OptimizationLevelImpl(OptimizationImpl.getAllOpts(), 2);
        levels = new OptimizationLevelImpl[]{QUICK, NORMAL, OPTIMIZED};
    }
}

