/*
 * Decompiled with CFR 0.152.
 */
package jrockit.mapi;

import com.bea.jvm.ProfilingSystem;
import com.bea.jvm.UnapplicableMethodException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jrockit.mapi.Toolkit;
import jrockit.vm.Reflect;

public class ProfilingSystemImpl
implements ProfilingSystem {
    private static final String PROFILING_SYSTEM_DESCRIPTION = "Profiling system for JRockit.";
    private Object xCountLock = new Object();

    public ProfilingSystemImpl() {
        Toolkit.checkCreate();
    }

    public void setInvocationCountEnabled(Method method, boolean bl) throws UnapplicableMethodException {
        this.checkMethod(method);
        ProfilingSystemImpl.setInvocationCountEnabled0(Reflect.IMethod.getID(method), bl);
    }

    public void setInvocationCountEnabled(Constructor constructor, boolean bl) {
        ProfilingSystemImpl.setInvocationCountEnabled0(Reflect.IConstructor.getID(constructor), bl);
    }

    public boolean isInvocationCountEnabled(Method method) throws UnapplicableMethodException {
        this.checkMethod(method);
        return ProfilingSystemImpl.isInvocationCountEnabled0(Reflect.IMethod.getID(method));
    }

    public boolean isInvocationCountEnabled(Constructor constructor) {
        return ProfilingSystemImpl.isInvocationCountEnabled0(Reflect.IConstructor.getID(constructor));
    }

    public long getInvocationCount(Method method) throws UnapplicableMethodException {
        this.checkMethod(method);
        return ProfilingSystemImpl.getInvocationCount0(Reflect.IMethod.getID(method));
    }

    public long getInvocationCount(Constructor constructor) {
        return ProfilingSystemImpl.getInvocationCount0(Reflect.IConstructor.getID(constructor));
    }

    public void setTimingEnabled(Method method, boolean bl) throws UnapplicableMethodException {
        ProfilingSystemImpl.setTimingEnabled0(Reflect.IMethod.getID(method), bl);
    }

    public void setTimingEnabled(Constructor constructor, boolean bl) {
        ProfilingSystemImpl.setTimingEnabled0(Reflect.IConstructor.getID(constructor), bl);
    }

    public boolean isTimingEnabled(Method method) throws UnapplicableMethodException {
        this.checkMethod(method);
        return ProfilingSystemImpl.isTimingEnabled0(Reflect.IMethod.getID(method));
    }

    public boolean isTimingEnabled(Constructor constructor) {
        return ProfilingSystemImpl.isTimingEnabled0(Reflect.IConstructor.getID(constructor));
    }

    public long getTiming(Method method) throws UnapplicableMethodException {
        this.checkMethod(method);
        return ProfilingSystemImpl.getTiming0(Reflect.IMethod.getID(method));
    }

    public long getTiming(Constructor constructor) {
        return ProfilingSystemImpl.getTiming0(Reflect.IConstructor.getID(constructor));
    }

    private static void checkThrowable(Class clazz) {
        if (!Throwable.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(clazz.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExceptionCount(Class clazz) {
        long l;
        ProfilingSystemImpl.checkThrowable(clazz);
        Object object = this.xCountLock;
        synchronized (object) {
            l = ProfilingSystemImpl.getExceptionCount0(Reflect.IClass.getID(clazz));
        }
        return l < 0L ? 0L : l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExceptionCountEnabled(Class clazz) {
        ProfilingSystemImpl.checkThrowable(clazz);
        Object object = this.xCountLock;
        synchronized (object) {
            return ProfilingSystemImpl.getExceptionCount0(Reflect.IClass.getID(clazz)) != -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionCountEnabled(Class clazz, boolean bl, boolean bl2) {
        ProfilingSystemImpl.checkThrowable(clazz);
        Object object = this.xCountLock;
        synchronized (object) {
            ProfilingSystemImpl.setExceptionCountEnabled0(Reflect.IClass.getID(clazz), bl, bl2);
        }
    }

    public String getDescription() {
        return PROFILING_SYSTEM_DESCRIPTION;
    }

    private void checkMethod(Method method) throws UnapplicableMethodException {
        int n = method.getModifiers();
        if (Modifier.isAbstract(n) || Modifier.isNative(n)) {
            throw new UnapplicableMethodException(method.getName());
        }
    }

    private static native void setExceptionCountEnabled0(int var0, boolean var1, boolean var2);

    private static native long getExceptionCount0(int var0);

    private static native boolean isTimingEnabled0(int var0);

    private static native boolean isInvocationCountEnabled0(int var0);

    private static native long getTiming0(int var0);

    private static native long getInvocationCount0(int var0);

    private static native void setInvocationCountEnabled0(int var0, boolean var1);

    private static native void setTimingEnabled0(int var0, boolean var1);
}

