/*
 * Decompiled with CFR 0.152.
 */
package jrockit.memory;

import jrockit.memory.AtomicIntImpl;

public abstract class AtomicInt {
    protected int value;

    public abstract int cas(int var1, int var2);

    public abstract int swap(int var1);

    public int get() {
        return this.value;
    }

    public void set(int n) {
        this.value = n;
    }

    public void clear() {
        this.value = 0;
    }

    AtomicInt(int n) {
        this.set(n);
    }

    public final boolean attemptSet(int n) {
        int n2 = this.get();
        return this.cas(n2, n) == n2;
    }

    public final boolean attemptUpdate(int n, int n2) {
        return this.cas(n, n2) == n;
    }

    public final int increase() {
        int n;
        int n2;
        while (!this.attemptUpdate(n2 = this.value, n = n2 + 1)) {
        }
        return n;
    }

    public final int increaseIfNotLessThan(int n) {
        int n2;
        int n3;
        do {
            if ((n3 = this.value) >= n) continue;
            return n3;
        } while (!this.attemptUpdate(n3, n2 = n3 + 1));
        return n2;
    }

    public final int decrease() {
        int n;
        int n2;
        while (!this.attemptUpdate(n2 = this.value, n = n2 - 1)) {
        }
        return n;
    }

    public static AtomicInt newAtomicInt(int n) {
        return new AtomicIntImpl(n);
    }

    public static AtomicInt newAtomicInt() {
        return AtomicInt.newAtomicInt(0);
    }

    public String toString() {
        return "AtomicInt[" + this.value + "]";
    }
}

