/*
 * Decompiled with CFR 0.152.
 */
package jrockit.memory;

import jrockit.vm.Memory;

public final class AtomicLong {
    protected long value;
    private static final int offset = Memory.objectHeaderSize();

    public boolean attemptSet(long l) {
        long l2 = this.get();
        return this.cas(l2, l) == l2;
    }

    public boolean attemptUpdate(long l, long l2) {
        return this.cas(l, l2) == l;
    }

    public final long increase() {
        long l;
        long l2;
        while (!this.attemptUpdate(l2 = this.value, l = l2 + 1L)) {
        }
        return l;
    }

    public final long decrease() {
        long l;
        long l2;
        while (!this.attemptUpdate(l2 = this.value, l = l2 - 1L)) {
        }
        return l;
    }

    AtomicLong(long l) {
        this.set(l);
    }

    public static AtomicLong newAtomicLong(long l) {
        return new AtomicLong(l);
    }

    public static AtomicLong newAtomicLong() {
        return AtomicLong.newAtomicLong(0L);
    }

    public String toString() {
        return "AtomicLong[" + this.value + "]";
    }

    public long cas(long l, long l2) {
        return Memory.cas((Object)this, offset, l, l2);
    }

    public long swap(long l) {
        return Memory.swap((Object)this, offset, l);
    }

    public long get() {
        return this.value;
    }

    public void set(long l) {
        this.value = l;
    }

    public void clear() {
        this.value = 0L;
    }
}

