/*
 * Decompiled with CFR 0.152.
 */
package jrockit.memory;

import jrockit.vm.Memory;
import jrockit.vm.Reflect;

public final class CodeBlock {
    private int codeblock;
    private int size;
    private int[] codeinfos;
    private int numCodeinfos = 0;

    private native void acquireBlock(int var1);

    private native void releaseBlock();

    public CodeBlock(ClassLoader classLoader) {
        this.acquireBlock(Reflect.IClassLoader.getID(classLoader));
    }

    public int remainingSize() {
        return this.size;
    }

    public synchronized void addCodeInfo(int n) {
        if (this.codeinfos == null) {
            this.codeinfos = new int[10];
        } else if (this.numCodeinfos >= this.codeinfos.length) {
            int[] nArray = new int[this.codeinfos.length * 2];
            for (int i = 0; i < this.codeinfos.length; ++i) {
                nArray[i] = this.codeinfos[i];
            }
            this.codeinfos = nArray;
        }
        this.codeinfos[this.numCodeinfos++] = n;
    }

    protected void finalize() {
        if (this.codeblock != 0) {
            this.releaseBlock();
        }
        if (this.numCodeinfos > 0) {
            for (int i = 0; i < this.numCodeinfos; ++i) {
                Memory.freeMemory(this.codeinfos[i]);
            }
        }
    }
}

