/*
 * Decompiled with CFR 0.152.
 */
package jrockit.memory;

import java.security.AccessController;
import java.security.PrivilegedAction;
import jrockit.vm.Access;
import jrockit.vm.GC;

public class Finalizer {
    public static native void register(Object var0);

    private static void runFinalizer(Object object) {
        try {
            Access.lang().objectFinalize(object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static native Object getPendingFinalizee(boolean var0);

    private static native Object getUnfinalizedFinalizee();

    private static ThreadGroup getTopThreadGroup() {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        return threadGroup;
    }

    private static void forkSecondaryFinalizer(final Runnable runnable, final String string) {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                Thread thread = new Thread(Finalizer.getTopThreadGroup(), runnable, string);
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction);
    }

    public static void runFinalization() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            public void run() {
                Object object;
                while ((object = Finalizer.getPendingFinalizee(true)) != null) {
                    Finalizer.runFinalizer(object);
                }
            }
        }, "Secondary Finalizer");
    }

    public static void runAllFinalizers() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            public void run() {
                while (true) {
                    Object object;
                    if ((object = Finalizer.getUnfinalizedFinalizee()) == null) {
                        try {
                            GC.triggGC(false);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        object = Finalizer.getUnfinalizedFinalizee();
                    }
                    if (object == null) break;
                    Finalizer.runFinalizer(object);
                }
            }
        }, "Unsafe Secondary Finalizer");
    }

    public static void startFinalizerThread() {
        Thread thread = new Thread(Finalizer.getTopThreadGroup(), new Runnable(){

            public void run() {
                Object object;
                while ((object = Finalizer.getPendingFinalizee(false)) != null) {
                    Finalizer.runFinalizer(object);
                }
            }
        }, "Finalizer");
        thread.setPriority(8);
        thread.setDaemon(true);
        thread.start();
    }
}

