/*
 * Decompiled with CFR 0.152.
 */
package jrockit.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.security.AccessController;
import jrockit.io.SelectableNativeIO;
import jrockit.net.InetAddressCache;
import jrockit.vm.Access;
import jrockit.vm.Memory;
import jrockit.vm.Threads;
import sun.security.action.GetBooleanAction;
import sun.security.action.LoadLibraryAction;

public class SocketNativeIO
extends SelectableNativeIO {
    public static final int TIMEOUT_NOWAIT = 0;
    public static final int TIMEOUT_FOREVER = -1;
    private static SocketNativeIO instance;
    private static boolean isOldLinux;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;

    public static final int java2NativeTimeout(int n) {
        return n > 0 ? n : -1;
    }

    public static final int native2JavaTimeout(int n) {
        return n > 0 ? n : 0;
    }

    private static native boolean init(boolean var0);

    public static final boolean isOldCrappyLinux() {
        return isOldLinux;
    }

    public static void ensureNetworkingStarted() {
        if (SocketNativeIO.getInstance() == null) {
            throw new Error("Network init failed");
        }
    }

    protected SocketNativeIO() {
    }

    public static SocketNativeIO getInstance() {
        return instance;
    }

    protected static native int socket0(boolean var0, boolean var1);

    private static native int checkConnect(int var0, boolean var1, boolean var2) throws IOException;

    protected native void configureBlocking(int var1, boolean var2) throws IOException;

    private static native int connect(int var0, InetAddress var1, int var2, int var3, int var4) throws IOException;

    private static native void listen(int var0, int var1) throws IOException;

    private static native void shutdown(int var0, int var1) throws IOException;

    private static native void disconnect(int var0) throws IOException;

    private static native int bind(int var0, InetAddress var1, int var2) throws IOException;

    private static native int getIntOption(int var0, int var1) throws IOException;

    private static native void setIntOption(int var0, int var1, int var2) throws IOException;

    private static native byte[] accept(int var0, FileDescriptor var1, int var2) throws IOException;

    private static native int localPort(int var0) throws IOException;

    private static native void localAddress(int var0, InetAddressCache var1) throws IOException;

    public FileDescriptor socket(boolean bl) throws SocketException {
        return this.socket(bl, false);
    }

    public FileDescriptor socket(boolean bl, boolean bl2) throws SocketException {
        int n;
        boolean bl3 = false;
        while ((n = SocketNativeIO.socket0(bl, bl2)) == -1) {
            if (bl3 || !handleLock.waitForRelease()) {
                throw new SocketException("no more handles");
            }
            bl3 = true;
        }
        return SocketNativeIO.newFD(n);
    }

    public int connect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n, int n2) throws IOException {
        return this.connect(fileDescriptor, inetAddress, n, n2, -1);
    }

    public int connect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n, int n2, int n3) throws IOException {
        return SocketNativeIO.connect(SocketNativeIO.fh(fileDescriptor), inetAddress, n, n2, n3);
    }

    public int checkConnect(FileDescriptor fileDescriptor, boolean bl, boolean bl2) throws IOException {
        return SocketNativeIO.checkConnect(SocketNativeIO.fh(fileDescriptor), bl, bl2);
    }

    public InetAddressCache accept(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2) throws IOException {
        return this.accept(fileDescriptor, fileDescriptor2, 0);
    }

    public InetAddressCache accept(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, int n) throws IOException {
        byte[] byArray = SocketNativeIO.accept(SocketNativeIO.fh(fileDescriptor), fileDescriptor2, n);
        if (byArray != null) {
            int n2 = byArray[0] << 8 & 0xFFFF | byArray[1] & 0xFF;
            byte[] byArray2 = new byte[byArray.length - 2];
            System.arraycopy(byArray, 2, byArray2, 0, byArray2.length);
            return new InetAddressCache(InetAddress.getByAddress(byArray2), n2);
        }
        return null;
    }

    public int bind(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        return SocketNativeIO.bind(SocketNativeIO.fh(fileDescriptor), inetAddress, n);
    }

    public void listen(FileDescriptor fileDescriptor, int n) throws IOException {
        SocketNativeIO.listen(SocketNativeIO.fh(fileDescriptor), n);
    }

    public int getIntOption(FileDescriptor fileDescriptor, int n) throws IOException {
        return SocketNativeIO.getIntOption(SocketNativeIO.fh(fileDescriptor), n);
    }

    public void setIntOption(FileDescriptor fileDescriptor, int n, int n2) throws IOException {
        SocketNativeIO.setIntOption(SocketNativeIO.fh(fileDescriptor), n, n2);
    }

    public void disconnect(FileDescriptor fileDescriptor) throws IOException {
        SocketNativeIO.disconnect(SocketNativeIO.fh(fileDescriptor));
    }

    public void shutdown(FileDescriptor fileDescriptor, int n) throws IOException {
        SocketNativeIO.shutdown(SocketNativeIO.fh(fileDescriptor), n);
    }

    public static InetSocketAddress localAddress(FileDescriptor fileDescriptor) {
        try {
            InetAddressCache inetAddressCache = new InetAddressCache();
            SocketNativeIO.localAddress(SocketNativeIO.fh(fileDescriptor), inetAddressCache);
            return new InetSocketAddress(inetAddressCache.getAddress(), inetAddressCache.getPort());
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    public static void localAddress(FileDescriptor fileDescriptor, InetAddressCache inetAddressCache) {
        try {
            if (inetAddressCache == null) {
                throw new NullPointerException("cache");
            }
            SocketNativeIO.localAddress(SocketNativeIO.fh(fileDescriptor), inetAddressCache);
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    public static int localPortNumber(FileDescriptor fileDescriptor) {
        try {
            return SocketNativeIO.localPort(SocketNativeIO.fh(fileDescriptor));
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    protected native void close(int var1, boolean var2) throws IOException;

    protected native int available(int var1) throws IOException;

    protected native int read(int var1, int var2, int var3, int var4) throws IOException;

    public final int read(FileDescriptor fileDescriptor, int n, int n2, int n3) throws IOException {
        return this.read(SocketNativeIO.fh(fileDescriptor), n, n2, n3);
    }

    protected native int read(int var1, int var2, int var3) throws IOException;

    protected native long readv(int var1, int var2, int var3) throws IOException;

    protected native int write(int var1, int var2, int var3) throws IOException;

    protected native long writev(int var1, int var2, int var3) throws IOException;

    private static native int receive(int var0, int var1, int var2, InetAddressCache var3, int var4, boolean var5, boolean var6) throws IOException;

    private static native int send(int var0, int var1, int var2, InetAddress var3, int var4, int var5) throws IOException;

    private static native int peek(int var0, InetAddress var1, int var2, boolean var3) throws IOException;

    private static native void sendUrgentData(int var0, int var1) throws IOException;

    private static native void join(int var0, InetAddress var1, NetworkInterface var2) throws IOException;

    private static native void leave(int var0, InetAddress var1, NetworkInterface var2) throws IOException;

    private static native void setNetworkInterface(int var0, NetworkInterface var1) throws IOException;

    private static native NetworkInterface getNetworkInterface(int var0) throws IOException;

    private static native void setMulticastAddress(int var0, InetAddress var1) throws IOException;

    private static native InetAddress getMulticastAddress(int var0) throws IOException;

    public int receive(FileDescriptor fileDescriptor, int n, int n2, InetAddressCache inetAddressCache, int n3, boolean bl, boolean bl2) throws IOException {
        return SocketNativeIO.receive(SocketNativeIO.fh(fileDescriptor), n, n2, inetAddressCache, n3, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receive(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2, InetAddressCache inetAddressCache, int n3, boolean bl, boolean bl2) throws IOException {
        int n4 = Threads.getCurrentVMThread();
        Threads.pinObject(n4, byArray);
        try {
            int n5 = SocketNativeIO.receive(SocketNativeIO.fh(fileDescriptor), Memory.getArrayData(byArray, n), n2, inetAddressCache, n3, bl, bl2);
            return n5;
        }
        finally {
            Threads.unpinLastObject(n4);
        }
    }

    public int send(FileDescriptor fileDescriptor, int n, int n2, InetAddress inetAddress, int n3, int n4) throws IOException {
        if (inetAddress == null) {
            throw new NullPointerException("address");
        }
        return SocketNativeIO.send(SocketNativeIO.fh(fileDescriptor), n, n2, inetAddress, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2, InetAddress inetAddress, int n3, int n4) throws IOException {
        if (inetAddress == null) {
            throw new NullPointerException("address");
        }
        int n5 = Threads.getCurrentVMThread();
        Threads.pinObject(n5, byArray);
        try {
            int n6 = SocketNativeIO.send(SocketNativeIO.fh(fileDescriptor), Memory.getArrayData(byArray, n), n2, inetAddress, n3, n4);
            return n6;
        }
        finally {
            Threads.unpinLastObject(n5);
        }
    }

    public int peek(FileDescriptor fileDescriptor, InetAddress inetAddress, int n, boolean bl) throws IOException {
        if (inetAddress == null) {
            throw new NullPointerException("peek");
        }
        return SocketNativeIO.peek(SocketNativeIO.fh(fileDescriptor), inetAddress, n, bl);
    }

    public void sendUrgentData(FileDescriptor fileDescriptor, int n) throws IOException {
        SocketNativeIO.sendUrgentData(SocketNativeIO.fh(fileDescriptor), n);
    }

    public void join(FileDescriptor fileDescriptor, InetAddress inetAddress, NetworkInterface networkInterface) throws IOException {
        if (inetAddress == null) {
            throw new NullPointerException("join");
        }
        SocketNativeIO.join(SocketNativeIO.fh(fileDescriptor), inetAddress, networkInterface);
    }

    public void leave(FileDescriptor fileDescriptor, InetAddress inetAddress, NetworkInterface networkInterface) throws IOException {
        if (inetAddress == null) {
            throw new NullPointerException("leave");
        }
        SocketNativeIO.leave(SocketNativeIO.fh(fileDescriptor), inetAddress, networkInterface);
    }

    public void join(FileDescriptor fileDescriptor, InetAddress inetAddress) throws IOException {
        if (inetAddress == null) {
            throw new NullPointerException("join");
        }
        SocketNativeIO.join(SocketNativeIO.fh(fileDescriptor), inetAddress, null);
    }

    public void leave(FileDescriptor fileDescriptor, InetAddress inetAddress) throws IOException {
        if (inetAddress == null) {
            throw new NullPointerException("leave");
        }
        SocketNativeIO.leave(SocketNativeIO.fh(fileDescriptor), inetAddress, null);
    }

    public static void setMulticastAddress(FileDescriptor fileDescriptor, InetAddress inetAddress) throws IOException {
        if (inetAddress == null) {
            throw new NullPointerException("InetAddress");
        }
        SocketNativeIO.setMulticastAddress(SocketNativeIO.fh(fileDescriptor), inetAddress);
    }

    public static InetAddress getMulticastAddress(FileDescriptor fileDescriptor) throws IOException {
        InetAddress inetAddress = SocketNativeIO.getMulticastAddress(SocketNativeIO.fh(fileDescriptor));
        if (inetAddress == null) {
            inetAddress = Access.Net.get().getInetAddressAnyLocalAddress();
        }
        return inetAddress;
    }

    public static void setNetworkInterface(FileDescriptor fileDescriptor, NetworkInterface networkInterface) throws IOException {
        if (networkInterface == null) {
            throw new NullPointerException("NetworkInterface");
        }
        SocketNativeIO.setNetworkInterface(SocketNativeIO.fh(fileDescriptor), networkInterface);
    }

    public static NetworkInterface getNetworkInterface(FileDescriptor fileDescriptor) throws IOException {
        NetworkInterface networkInterface = SocketNativeIO.getNetworkInterface(SocketNativeIO.fh(fileDescriptor));
        if (networkInterface == null) {
            networkInterface = Access.Net.get().getAnyNetworkInterface();
        }
        return networkInterface;
    }

    public static InetSocketAddress checkAddress(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new IllegalArgumentException();
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        return inetSocketAddress;
    }

    public static InetSocketAddress asInetSocketAddress(SocketAddress socketAddress) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        return (InetSocketAddress)socketAddress;
    }

    static {
        isOldLinux = false;
        boolean bl = AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv4Stack"));
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        isOldLinux = SocketNativeIO.init(bl);
        instance = new SocketNativeIO();
    }
}

