/*
 * Decompiled with CFR 0.152.
 */
package jrockit.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import jrockit.net.SocketNativeIO;

public class SocketOpts {
    public static final int IP_MULTICAST_TTL = 33;

    private static String opt2name(int n) {
        String string = null;
        switch (n) {
            case 3: {
                string = "IP_TOS";
                break;
            }
            case 4099: {
                string = "SO_OOBINLINE";
                break;
            }
            case 32: {
                string = "SO_BROADCAST";
                break;
            }
            case 18: {
                string = "IP_MULTICAST_LOOP";
                break;
            }
            case 31: {
                string = "IP_MULTICAST_IF2";
                break;
            }
            case 128: {
                string = "SO_LINGER";
                break;
            }
            case 15: {
                string = "SO_BINDADDR";
                break;
            }
            case 1: {
                string = "TCP_NODELAY";
                break;
            }
            case 4097: {
                string = "SO_SNDBUF";
                break;
            }
            case 4098: {
                string = "SO_RCVBUF";
                break;
            }
            case 8: {
                string = "SO_KEEPALIVE";
                break;
            }
            case 4: {
                string = "SO_REUSEADDR";
                break;
            }
            case 33: {
                string = "IP_MULTICAST_TTL";
                break;
            }
            default: {
                string = "<unknown>";
            }
        }
        return string;
    }

    public static void setOption(int n, Object object, FileDescriptor fileDescriptor, SocketNativeIO socketNativeIO) throws SocketException {
        int n2 = 0;
        try {
            if (object instanceof Integer) {
                n2 = (Integer)object;
            }
            switch (n) {
                case 128: {
                    if (object instanceof Boolean) {
                        n2 = (Boolean)object != false ? 0 : -1;
                    }
                    break;
                }
                case 15: {
                    throw new SocketException("Cannot re-bind socket");
                }
                case 1: 
                case 4: 
                case 8: 
                case 18: 
                case 32: 
                case 4099: {
                    n2 = (Boolean)object != false ? 1 : 0;
                    break;
                }
                case 3: 
                case 33: 
                case 4097: 
                case 4098: {
                    if (n2 < 0) {
                        throw new SocketException("bad parameter for " + SocketOpts.opt2name(n));
                    }
                    break;
                }
                case 16: {
                    if (object == null || !(object instanceof InetAddress)) {
                        throw new SocketException("bad argument for IP_MULTICAST_IF");
                    }
                    SocketNativeIO.setMulticastAddress(fileDescriptor, (InetAddress)object);
                    return;
                }
                case 31: {
                    if (object == null || !(object instanceof NetworkInterface)) {
                        throw new SocketException("bad argument for IP_MULTICAST_IF2");
                    }
                    SocketNativeIO.setNetworkInterface(fileDescriptor, (NetworkInterface)object);
                    return;
                }
                default: {
                    throw new SocketException("unrecognized option: " + SocketOpts.opt2name(n));
                }
            }
        }
        catch (SocketException socketException) {
            throw socketException;
        }
        catch (Exception exception) {
            throw new SocketException("bad parameter for " + SocketOpts.opt2name(n));
        }
        try {
            socketNativeIO.setIntOption(fileDescriptor, n, n2);
        }
        catch (IOException iOException) {
            throw new SocketException(iOException.toString());
        }
    }

    public static Object getOption(int n, FileDescriptor fileDescriptor, SocketNativeIO socketNativeIO) throws SocketException {
        int n2 = 0;
        try {
            switch (n) {
                case 128: {
                    n2 = socketNativeIO.getIntOption(fileDescriptor, n);
                    if (n2 == -1) {
                        return new Boolean(false);
                    }
                    return new Integer(n2);
                }
                case 1: 
                case 4: 
                case 8: 
                case 18: 
                case 32: 
                case 4099: {
                    n2 = socketNativeIO.getIntOption(fileDescriptor, n);
                    return new Boolean(n2 != 0);
                }
                case 15: {
                    return SocketNativeIO.localAddress(fileDescriptor).getAddress();
                }
                case 3: 
                case 33: 
                case 4097: 
                case 4098: {
                    n2 = socketNativeIO.getIntOption(fileDescriptor, n);
                    return new Integer(n2);
                }
                case 16: {
                    return SocketNativeIO.getMulticastAddress(fileDescriptor);
                }
                case 31: {
                    return SocketNativeIO.getNetworkInterface(fileDescriptor);
                }
            }
        }
        catch (IOException iOException) {
            throw new SocketException(iOException.toString());
        }
        return null;
    }
}

