/*
 * Decompiled with CFR 0.152.
 */
package jrockit.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.SelectionKey;
import jrockit.nio.ch.PollArrayWrapper;
import jrockit.nio.ch.Selectable;
import jrockit.nio.ch.SelectionKeyImpl;
import jrockit.nio.ch.SelectorImpl;
import jrockit.nio.ch.SelectorProviderImpl;
import jrockit.vm.Access;

abstract class AbstractPollSelector
extends SelectorImpl {
    protected PollArrayWrapper pollWrapper;
    private Pipe iPipe;
    private int iFd;
    private ByteBuffer iBuf;
    protected FileDescriptor[] interrupts;

    AbstractPollSelector(SelectorProviderImpl selectorProviderImpl, int n) throws IOException {
        super(selectorProviderImpl, n);
        this.pollWrapper = selectorProviderImpl.createPollArrayWrapper(n);
        this.init();
    }

    protected void init() throws IOException {
        try {
            this.iPipe = Pipe.open();
            Pipe.SourceChannel sourceChannel = this.iPipe.source();
            sourceChannel.configureBlocking(false);
            SelectionKey selectionKey = sourceChannel.register(this, 1);
            this.keys.remove(selectionKey);
            this.iFd = Access.getFDHandle(((Selectable)((Object)sourceChannel)).getFD());
            this.iBuf = ByteBuffer.allocate(10);
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    protected void closeInterrupt() {
        try {
            this.iPipe.sink().close();
            this.iPipe.source().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearInterrupt() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (this.isInterrupted()) {
                while (true) {
                    this.iBuf.clear();
                    try {
                        if (this.iPipe.source().read(this.iBuf) != 0) continue;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    break;
                }
                super.clearInterrupt();
            }
        }
    }

    protected final int interruptFD() {
        return this.iFd;
    }

    protected void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        if (selectionKeyImpl.getIndex() < 0) {
            throw new Error(selectionKeyImpl.toString());
        }
        this.putEventOps(selectionKeyImpl.getFD(), selectionKeyImpl.getIndex(), n);
    }

    abstract void putEventOps(FileDescriptor var1, int var2, int var3);

    protected final void interrupt() {
        try {
            this.iBuf.clear();
            this.iBuf.put((byte)12).flip();
            this.iPipe.sink().write(this.iBuf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void implGrow(int n) {
        super.implGrow(n);
        this.pollWrapper.grow((SelectorProviderImpl)this.provider(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implClose() throws IOException {
        try {
            super.implClose();
        }
        finally {
            if (this.pollWrapper != null) {
                try {
                    this.closeInterrupt();
                }
                finally {
                    this.pollWrapper.free();
                    this.pollWrapper = null;
                }
            }
        }
    }
}

