/*
 * Decompiled with CFR 0.152.
 */
package jrockit.nio.ch;

import jrockit.memory.AllocatedNativeObject;
import jrockit.nio.ch.SelectorProviderImpl;

class PollArrayWrapper {
    static final short POLLIN = 1;
    static final short POLLOUT = 4;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    static final short POLLNVAL = 32;
    static final short POLLREMOVE = 2048;
    static final short POLLCONN = 4;
    static final short SIZE_POLLFD = 8;
    static final short FD_OFFSET = 0;
    static final short EVENT_OFFSET = 4;
    static final short REVENT_OFFSET = 6;
    private AllocatedNativeObject pollArray;
    private int totalChannels = 0;

    public PollArrayWrapper(int n) {
        this(new AllocatedNativeObject(n * 8, false), n);
    }

    protected PollArrayWrapper(AllocatedNativeObject allocatedNativeObject, int n) {
        this.pollArray = allocatedNativeObject;
        this.totalChannels = n;
    }

    String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n * 20);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(i);
            stringBuffer.append(" fh=");
            stringBuffer.append(this.getDescriptor(i));
            stringBuffer.append(" events=");
            stringBuffer.append(this.getEventOps(i));
            stringBuffer.append(" revents=");
            stringBuffer.append(this.getReventOps(i));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public void free() {
        this.pollArray.free();
    }

    public void grow(SelectorProviderImpl selectorProviderImpl, int n) {
        PollArrayWrapper pollArrayWrapper = selectorProviderImpl.createPollArrayWrapper(n);
        for (int i = 0; i < this.totalChannels; ++i) {
            this.replaceEntry(i, pollArrayWrapper, i);
        }
        this.pollArray.free();
        this.pollArray = pollArrayWrapper.pollArray;
        this.totalChannels = n;
    }

    void replaceEntry(int n, PollArrayWrapper pollArrayWrapper, int n2) {
        pollArrayWrapper.setDescriptor(n2, this.getDescriptor(n));
        pollArrayWrapper.setReventOps(n2, this.getReventOps(n));
        pollArrayWrapper.setEventOps(n2, this.getEventOps(n));
    }

    public int address() {
        return this.pollArray.address();
    }

    int getEventOps(int n) {
        int n2 = 8 * n + 4;
        return this.pollArray.getShort(n2);
    }

    int getReventOps(int n) {
        int n2 = 8 * n + 6;
        return this.pollArray.getShort(n2);
    }

    int getDescriptor(int n) {
        int n2 = 8 * n + 0;
        return this.pollArray.getInt(n2);
    }

    void setEventOps(int n, int n2) {
        int n3 = 8 * n + 4;
        this.pollArray.setShort(n3, (short)n2);
    }

    void setReventOps(int n, int n2) {
        int n3 = 8 * n + 6;
        this.pollArray.setShort(n3, (short)n2);
    }

    void setDescriptor(int n, int n2) {
        int n3 = 8 * n + 0;
        this.pollArray.setInt(n3, n2);
    }
}

