/*
 * Decompiled with CFR 0.152.
 */
package jrockit.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import jrockit.nio.ch.AbstractPollSelector;
import jrockit.nio.ch.SelectionKeyImpl;
import jrockit.nio.ch.SelectorProviderImpl;
import jrockit.vm.Access;

final class PollSelector
extends AbstractPollSelector {
    public PollSelector(SelectorProviderImpl selectorProviderImpl) throws IOException {
        super(selectorProviderImpl, 64);
    }

    protected final int poll(long l) throws IOException {
        int n = this.pollWrapper.address();
        if (n == 0) {
            throw new NullPointerException();
        }
        return PollSelector.poll(n, this.totalChannels, 0, l);
    }

    static native int poll(int var0, int var1, int var2, long var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearInterrupt() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (this.pollWrapper.getReventOps(0) != 0) {
                this.pollWrapper.setReventOps(0, 0);
            }
            super.clearInterrupt();
        }
    }

    protected int updateSelectedKeys(int n) {
        int n2 = 0;
        for (int i = 1; n > 0 && i < this.totalChannels; ++i) {
            int n3 = this.pollWrapper.getReventOps(i);
            this.pollWrapper.setReventOps(i, 0);
            if (n3 == 0) continue;
            if (this.implUpdate(this.channelArray[i], n3)) {
                ++n2;
            }
            --n;
        }
        return n2;
    }

    protected void putEventOps(FileDescriptor fileDescriptor, int n, int n2) {
        this.pollWrapper.setDescriptor(n, Access.getFDHandle(fileDescriptor));
        this.pollWrapper.setEventOps(n, n2);
        this.pollWrapper.setReventOps(n, 0);
    }

    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        super.implRegister(selectionKeyImpl);
        this.putEventOps(selectionKeyImpl.getFD(), this.totalChannels - 1, 0);
    }

    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        int n = selectionKeyImpl.getIndex();
        int n2 = this.totalChannels - 1;
        super.implDereg(selectionKeyImpl);
        if (n != n2) {
            this.pollWrapper.replaceEntry(n2, this.pollWrapper, n);
        }
    }
}

