/*
 * Decompiled with CFR 0.152.
 */
package jrockit.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import jrockit.nio.ch.PipeImpl;
import jrockit.nio.ch.Selectable;

public class WindowsPipeImpl
extends PipeImpl {
    public WindowsPipeImpl(SelectorProvider selectorProvider) throws IOException {
        SocketChannel socketChannel;
        int n = -20267334;
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().bind(new InetSocketAddress(InetAddress.getByName("127.0.0.1"), 0));
        SocketChannel socketChannel2 = SocketChannel.open(serverSocketChannel.socket().getLocalSocketAddress());
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        socketChannel2.write(byteBuffer);
        while (true) {
            socketChannel = serverSocketChannel.accept();
            byteBuffer.clear();
            socketChannel.read(byteBuffer);
            byteBuffer.rewind();
            if (byteBuffer.getInt() == n) break;
            socketChannel.close();
        }
        serverSocketChannel.close();
        this.sink = new WindowsSinkChannelImpl(selectorProvider, socketChannel2);
        this.source = new WindowsSourceChannelImpl(selectorProvider, socketChannel);
    }

    private final class WindowsSourceChannelImpl
    extends PipeImpl.SourceChannelImpl {
        private SocketChannel sc;

        WindowsSourceChannelImpl(SelectorProvider selectorProvider, SocketChannel socketChannel) {
            super(selectorProvider);
            this.sc = socketChannel;
        }

        public FileDescriptor getFD() {
            return ((Selectable)((Object)this.sc)).getFD();
        }

        protected void destroy() throws IOException {
            assert (!this.isOpen() && !this.isRegistered());
            this.sc.close();
        }

        protected void implConfigureBlocking(boolean bl) throws IOException {
            this.sc.configureBlocking(bl);
        }

        public int read(ByteBuffer byteBuffer) throws IOException {
            return this.sc.read(byteBuffer);
        }

        public long read(ByteBuffer[] byteBufferArray) throws IOException {
            return this.sc.read(byteBufferArray);
        }
    }

    private final class WindowsSinkChannelImpl
    extends PipeImpl.SinkChannelImpl {
        private SocketChannel sc;

        WindowsSinkChannelImpl(SelectorProvider selectorProvider, SocketChannel socketChannel) {
            super(selectorProvider);
            this.sc = socketChannel;
        }

        public FileDescriptor getFD() {
            return ((Selectable)((Object)this.sc)).getFD();
        }

        protected void destroy() throws IOException {
            assert (!this.isOpen() && !this.isRegistered());
            this.sc.close();
        }

        protected void implConfigureBlocking(boolean bl) throws IOException {
            this.sc.configureBlocking(bl);
        }

        public int write(ByteBuffer byteBuffer) throws IOException {
            return this.sc.write(byteBuffer);
        }

        public long write(ByteBuffer[] byteBufferArray) throws IOException {
            return this.sc.write(byteBufferArray);
        }
    }
}

