/*
 * Decompiled with CFR 0.152.
 */
package jrockit.reflect;

import java.lang.reflect.Constructor;
import jrockit.reflect.ConstructorInvoker;
import jrockit.reflect.NativeMethodInvoker;
import jrockit.vm.Reflect;
import jrockit.vm.VM;

class NativeConstructorInvoker
extends ConstructorInvoker {
    private final Class targetClass;
    private final Constructor constructor;
    private final Class[] paramTypes;
    private int invokes = 0;

    NativeConstructorInvoker(Constructor constructor) {
        this(constructor, constructor.getDeclaringClass());
    }

    NativeConstructorInvoker(Constructor constructor, Class clazz) {
        super(constructor);
        this.constructor = constructor;
        this.targetClass = clazz;
        this.paramTypes = constructor.getParameterTypes();
    }

    public Object newInstance(Object[] objectArray) throws IllegalArgumentException, InstantiationException {
        if (this.paramTypes.length > 0) {
            if (objectArray == null || objectArray.length != this.paramTypes.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < this.paramTypes.length; ++i) {
                if (Reflect.IClass.isInvocationAssignable(this.paramTypes[i], objectArray[i])) continue;
                throw new IllegalArgumentException();
            }
        }
        Object object = NativeConstructorInvoker.allocObject(this.targetClass);
        NativeMethodInvoker.invoke0(this, Reflect.IConstructor.getID(this.constructor), object, objectArray);
        if (VM.createCompiledInvokers && this.invokes++ > VM.compiledInvokerThreshold) {
            try {
                NativeConstructorInvoker.compileInvoker(this.constructor, this.targetClass);
            }
            catch (Throwable throwable) {
                this.invokes = 0;
            }
        }
        return object;
    }
}

