/*
 * Decompiled with CFR 0.152.
 */
package jrockit.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jrockit.annotations.Internal;
import jrockit.reflect.MethodInvoker;
import jrockit.vm.Reflect;
import jrockit.vm.VM;

class NativeMethodInvoker
extends MethodInvoker {
    private int invokes = 0;
    final Method method;
    final Class[] paramTypes;

    NativeMethodInvoker(Method method) {
        super(method);
        this.method = method;
        this.paramTypes = method.getParameterTypes();
    }

    @Internal
    public Object invoke(Object object, Object[] objectArray) throws IllegalArgumentException, InvocationTargetException {
        if (this.paramTypes.length > 0) {
            if (objectArray == null || objectArray.length != this.paramTypes.length) {
                throw new IllegalArgumentException("wrong number of arguments");
            }
            for (int i = 0; i < this.paramTypes.length; ++i) {
                if (Reflect.IClass.isInvocationAssignable(this.paramTypes[i], objectArray[i])) continue;
                throw new IllegalArgumentException("argument type mismatch");
            }
        } else if (objectArray != null && objectArray.length != 0) {
            throw new IllegalArgumentException("wrong number of arguments");
        }
        Object object2 = NativeMethodInvoker.invoke0(this, Reflect.IMethod.getID(this.method), object, objectArray);
        if (VM.createCompiledInvokers && this.invokes++ > VM.compiledInvokerThreshold) {
            try {
                NativeMethodInvoker.compileInvoker(this.method);
            }
            catch (Throwable throwable) {
                this.invokes = 0;
            }
        }
        return object2;
    }

    @Internal
    static native Object invoke0(Object var0, int var1, Object var2, Object[] var3) throws IllegalArgumentException;
}

