/*
 * Decompiled with CFR 0.152.
 */
package jrockit.rls;

public class StateSpace {
    private int NOOF_STATE_FEATURES;
    private int S1_NOOF_TILES;
    private int S2_NOOF_TILES;
    private int S3_NOOF_TILES;
    private int STATE_SIZE;
    private boolean one;
    private boolean two;
    private boolean three;

    public StateSpace(int n, int[] nArray, int[] nArray2) {
        this.setNoofStateFeatures(n);
        this.setStateFeatures(nArray);
        this.setTiles(nArray2);
        this.setStateSize();
    }

    private void setTiles(int[] nArray) {
        this.S1_NOOF_TILES = 0;
        this.S2_NOOF_TILES = 0;
        this.S3_NOOF_TILES = 0;
        switch (this.NOOF_STATE_FEATURES) {
            case 3: {
                this.S3_NOOF_TILES = nArray[2];
            }
            case 2: {
                this.S2_NOOF_TILES = nArray[1];
            }
            case 1: {
                this.S1_NOOF_TILES = nArray[0];
                break;
            }
            default: {
                System.err.println("No tiles were set.");
            }
        }
    }

    public int[] getTiles() {
        switch (this.NOOF_STATE_FEATURES) {
            case 1: {
                return new int[]{this.S1_NOOF_TILES};
            }
            case 2: {
                return new int[]{this.S1_NOOF_TILES, this.S2_NOOF_TILES};
            }
            case 3: {
                return new int[]{this.S1_NOOF_TILES, this.S2_NOOF_TILES, this.S3_NOOF_TILES};
            }
        }
        System.err.println("No tiles were found.");
        return new int[]{0};
    }

    private void setStateSize() {
        switch (this.NOOF_STATE_FEATURES) {
            case 1: {
                this.STATE_SIZE = this.S1_NOOF_TILES;
                break;
            }
            case 2: {
                this.STATE_SIZE = this.S1_NOOF_TILES + this.S2_NOOF_TILES;
                break;
            }
            case 3: {
                this.STATE_SIZE = this.S1_NOOF_TILES + this.S2_NOOF_TILES + this.S3_NOOF_TILES;
                break;
            }
            default: {
                System.err.println("State size were not set.");
            }
        }
    }

    public int getStateSize() {
        return this.STATE_SIZE;
    }

    private void setStateFeatures(int[] nArray) {
        this.one = false;
        this.two = false;
        this.three = false;
        block5: for (int i = 0; i < this.NOOF_STATE_FEATURES; ++i) {
            switch (nArray[i]) {
                case 3: {
                    this.three = true;
                    continue block5;
                }
                case 2: {
                    this.two = true;
                    continue block5;
                }
                case 1: {
                    this.one = true;
                    continue block5;
                }
                default: {
                    System.err.println("No state features were set.");
                }
            }
        }
    }

    public boolean isPresent(int n) {
        switch (n) {
            case 1: {
                return this.one;
            }
            case 2: {
                return this.two;
            }
            case 3: {
                return this.three;
            }
        }
        System.err.println("No state features are present.");
        return false;
    }

    private void setNoofStateFeatures(int n) {
        this.NOOF_STATE_FEATURES = n;
    }

    public int getNoofStateFeatures() {
        return this.NOOF_STATE_FEATURES;
    }

    public int getCombinedFeatureStateSize() {
        switch (this.NOOF_STATE_FEATURES) {
            case 1: {
                return this.S1_NOOF_TILES;
            }
            case 2: {
                return this.S1_NOOF_TILES * this.S2_NOOF_TILES;
            }
            case 3: {
                return this.S1_NOOF_TILES * this.S2_NOOF_TILES * this.S3_NOOF_TILES;
            }
        }
        System.err.println("No combined feature state size were found.");
        return 0;
    }
}

