/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.security.AccessControlContext;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import jrockit.annotations.ForceInline;
import jrockit.vm.Reflect;
import jrockit.vm.Threads;

@ForceInline
public class AccessController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object doPrivileged(PrivilegedAction privilegedAction, AccessControlContext accessControlContext, int n) {
        Thread thread = Thread.currentThread();
        int n2 = Threads.getCurrentVMThread();
        AccessControlContext accessControlContext2 = Threads.getAccessControlContext(thread);
        int n3 = Threads.getPrivilegedCallerClass(n2);
        Threads.setAccessControlContext(thread, accessControlContext);
        Threads.setPrivilegedCallerClass(n2, n);
        try {
            Object t = privilegedAction.run();
            return t;
        }
        finally {
            Threads.setAccessControlContext(thread, accessControlContext2);
            Threads.setPrivilegedCallerClass(n2, n3);
        }
    }

    private static Object doPrivileged(PrivilegedAction privilegedAction, int n) {
        return AccessController.doPrivileged(privilegedAction, null, n);
    }

    private static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext, int n) throws PrivilegedActionException {
        Thread thread = Thread.currentThread();
        int n2 = Threads.getCurrentVMThread();
        AccessControlContext accessControlContext2 = Threads.getAccessControlContext(thread);
        int n3 = Threads.getPrivilegedCallerClass(n2);
        Threads.setAccessControlContext(thread, accessControlContext);
        Threads.setPrivilegedCallerClass(n2, n);
        try {
            Object t = privilegedExceptionAction.run();
            return t;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
        finally {
            Threads.setAccessControlContext(thread, accessControlContext2);
            Threads.setPrivilegedCallerClass(n2, n3);
        }
    }

    private static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction, int n) throws PrivilegedActionException {
        return AccessController.doPrivileged(privilegedExceptionAction, null, n);
    }

    public static Object doPrivileged(PrivilegedAction privilegedAction) {
        return AccessController.doPrivileged(privilegedAction, null, Reflect.getCallerClassID());
    }

    public static Object doPrivileged(PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        return AccessController.doPrivileged(privilegedAction, accessControlContext, Reflect.getCallerClassID());
    }

    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return AccessController.doPrivileged(privilegedExceptionAction, null, Reflect.getCallerClassID());
    }

    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        return AccessController.doPrivileged(privilegedExceptionAction, accessControlContext, Reflect.getCallerClassID());
    }
}

