/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import jrockit.annotations.NoSafePoint;
import jrockit.memory.Finalizer;
import jrockit.vm.Access;
import jrockit.vm.Intrinsics;
import jrockit.vm.Memory;
import jrockit.vm.RNI;
import jrockit.vm.Reflect;
import jrockit.vm.VM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Allocator {
    static final int CLEAR_ON_ALLOC = 0;
    static final int CLEAR_CHUNKS = 1;
    static final int CLEAR_TLAS = 2;
    static final int CLEAR_ON_GC = 3;
    static int LARGE_OBJECT_SIZE;
    static int PREFETCH_SIZE;
    static int PREFETCH_DISTANCE;
    static boolean REDO_SOME_PREFETCHING;
    static boolean USE_PREFETCHING;
    static int CHUNK_SIZE;
    static int CLEAR_TYPE;
    static int tlaFreeListVec;

    public static <T extends Throwable> T newThrowable(Class<T> clazz, String string, Throwable throwable) {
        Throwable throwable2 = (Throwable)Allocator.allocObject(clazz);
        Access.lang().throwableSetDetailMessage(throwable2, string);
        Access.lang().throwableSetCause(throwable2, throwable);
        return (T)throwable2;
    }

    public static Object allocObject(Class clazz) {
        int n = Reflect.IClass.getID(clazz);
        Object object = Allocator.allocObject(n);
        if (VM.jvmtiVMObjectAllocs) {
            RNI.jvmtiVMObjectAlloc(object);
        }
        if ((Reflect.IClass.getFlags(n) & 2) != 0) {
            Finalizer.register(object);
        }
        return object;
    }

    public static Object allocArray(Class clazz, int n) {
        Object object = Allocator.allocArray(Reflect.IClass.getID(clazz), n);
        if (VM.jvmtiVMObjectAllocs) {
            RNI.jvmtiVMObjectAlloc(object);
        }
        return object;
    }

    public static Object allocMultiArray(Class clazz, int[] nArray) {
        Object object = Allocator.allocMultiArray0(Reflect.IClass.getID(clazz), nArray);
        if (VM.jvmtiVMObjectAllocs) {
            RNI.jvmtiVMObjectAlloc(object);
        }
        return object;
    }

    private Allocator() {
    }

    private static Object allocObject(int n) {
        int n2 = Reflect.IClassBlock.getCB(n);
        int n3 = Memory.getInt(n2, Reflect.offset(267));
        if (n3 > LARGE_OBJECT_SIZE) {
            return Allocator.allocLargeObject(n2, n3);
        }
        return Allocator.innerAllocate(n2, n3, -1);
    }

    public static Object allocArray(int n, int n2) {
        int n3 = Reflect.IClassBlock.getCB(n);
        int n4 = Memory.getInt(Reflect.IClassBlock.getClassID(n3), Reflect.offset(523));
        int n5 = n4 * n2 + 23 & 0xFFFFFFF8;
        if (n2 < 0 || n2 >= 0x10000000 || n5 > LARGE_OBJECT_SIZE) {
            return Allocator.allocLargeArray(n3, n2);
        }
        return Allocator.innerAllocate(n3, n5, n2);
    }

    @NoSafePoint
    private static Object innerAllocate(int n, int n2, int n3) {
        int n4;
        int n5 = Allocator.getTLA();
        int n6 = Allocator.getTLANextFree(n5);
        int n7 = n6 + n2;
        if (Intrinsics.cmpugt(n7, n4 = Allocator.getTLAMarker(n5))) {
            return Allocator.getMoreMemoryAndAlloc(n, n2, n7, n3);
        }
        Allocator.setTLANextFree(n5, n7);
        if (CLEAR_TYPE == 0) {
            Allocator.memclear(n6, n2);
        }
        Memory.setAddress(n6, 0, n);
        if (n3 >= 0) {
            Memory.setInt(n6, 8, n3);
        }
        return Allocator.addressToObject(n6);
    }

    @NoSafePoint
    private static Object getMoreMemoryAndAlloc(int n, int n2, int n3, int n4) {
        if (USE_PREFETCHING || CLEAR_TYPE == 1) {
            return Allocator.prepareNextChunkAndAlloc(n, n2, n3, n4);
        }
        return Allocator.getNewTLAAndAlloc(n, n2, n4);
    }

    @NoSafePoint
    private static Object prepareNextChunkAndAlloc(int n, int n2, int n3, int n4) {
        int n5 = Allocator.getTLA();
        int n6 = Memory.getAddress(n5, Reflect.offset(3076));
        int n7 = Allocator.getTLAMarker(n5);
        if (Intrinsics.cmpugt(n3, n6)) {
            return Allocator.getNewTLAAndAlloc(n, n2, n4);
        }
        int n8 = n3 - n2;
        int n9 = n7;
        while (Intrinsics.cmpugt(n3, n9 += CHUNK_SIZE)) {
        }
        if (Intrinsics.cmpugt(n9, n6)) {
            n9 = n6;
        }
        if (USE_PREFETCHING) {
            int n10 = REDO_SOME_PREFETCHING ? n7 : n7 + PREFETCH_DISTANCE;
            int n11 = n9 + PREFETCH_DISTANCE;
            while (Intrinsics.cmpugt(n11, n10)) {
                Intrinsics.prefetch(n10);
                n10 += PREFETCH_SIZE;
            }
        }
        if (CLEAR_TYPE == 1) {
            Allocator.memclear(n7, n9 - n7);
        }
        Allocator.setTLAMarker(n5, n9);
        Allocator.setTLANextFree(n5, n3);
        if (CLEAR_TYPE == 0) {
            Allocator.memclear(n8, n2);
        }
        Memory.setAddress(n8, 0, n);
        if (n4 >= 0) {
            Memory.setInt(n8, 8, n4);
        }
        return Allocator.addressToObject(n8);
    }

    @NoSafePoint
    private static Object getNewTLAAndAlloc(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        block10: {
            int n7 = -1;
            if (n7 < 0) {
                do {
                    Allocator.nativeGetNewTLA(n, n2);
                } while ((n6 = Allocator.getTLANextFree(n5 = Allocator.getTLA())) == 0);
            } else {
                int n8;
                n4 = Memory.getAddress(tlaFreeListVec, n7 * Memory.addressSize());
                n5 = Allocator.getTLA();
                do {
                    if ((n6 = Memory.getAddress(n4, Reflect.offset(3072))) == 0) {
                        Allocator.nativeGetNewTLA(n, n2);
                        n5 = Allocator.getTLA();
                        n6 = Allocator.getTLANextFree(n5);
                        break block10;
                    }
                    n8 = Memory.getAddress(n6, Reflect.offset(3073));
                } while (Memory.cas(n4, Reflect.offset(3072), n6, n8) != n6);
                Allocator.initializeTLA(n5, n6);
            }
        }
        if (USE_PREFETCHING) {
            for (n4 = 0; n4 < CHUNK_SIZE + PREFETCH_DISTANCE; n4 += PREFETCH_SIZE) {
                Intrinsics.prefetch(n6, n4);
            }
        }
        if (CLEAR_TYPE == 1) {
            Allocator.memclear(n6, CHUNK_SIZE);
        }
        if (USE_PREFETCHING || CLEAR_TYPE == 1) {
            Allocator.setTLAMarker(n5, n6 + CHUNK_SIZE);
        } else {
            Allocator.setTLAMarker(n5, Memory.getAddress(n5, Reflect.offset(3076)));
        }
        return Allocator.innerAllocate(n, n2, n3);
    }

    private static native Object allocLargeObject(int var0, int var1);

    private static native Object allocLargeArray(int var0, int var1);

    private static native int nativeGetNewTLA(int var0, int var1);

    private static native Object addressToObject(int var0);

    private static native int getTLA();

    private static native int getTLANextFree(int var0);

    private static native int getTLAMarker(int var0);

    private static native void setTLANextFree(int var0, int var1);

    private static native void setTLAMarker(int var0, int var1);

    private static int getTLANumber(int n) {
        return Memory.getInt(n, Reflect.offset(3078));
    }

    private static void initializeTLA(int n, int n2) {
        int n3 = Memory.getAddress(n2, Reflect.offset(3074));
        Memory.setAddress(n, Reflect.offset(3075), n2);
        Memory.setAddress(n, Reflect.offset(3077), n2);
        Memory.setAddress(n, Reflect.offset(3076), n2 + n3);
        Allocator.initializeTLA0(n2, n2 + n3);
        if (CLEAR_TYPE == 2) {
            Allocator.memclear(n2, n3);
        }
    }

    private static native void initializeTLA0(int var0, int var1);

    private static native void memclear(int var0, int var1);

    private static native Object alloc2DimArray(int var0, int var1, int var2);

    private static native Object allocMultiArray(int var0, int var1, int var2);

    private static native Object allocMultiArray0(int var0, int[] var1);
}

