/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import jrockit.annotations.ForceInline;
import jrockit.vm.Reflect;

public class ArrayCopy {
    private static final int base = 16;
    private static final int OBJPTRSIZE = 4;
    private static final int ALIGN = 4;
    private static final int BLOCKLENGTH = 4;
    private static final boolean DESTALIGNED_OK = true;
    private static final int BIGCOPY_SIZE = 2048;
    private static final int UNALIGNED_LARGE = 0x7FFF0000;
    private static final int UNALIGNED_SMALL = 15;

    @ForceInline
    public static void copy(Object object, int n, Object object2, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        try {
            if (object2 == null) {
                throw new NullPointerException("null array passed into arraycopy");
            }
            if (object2 instanceof long[]) {
                n4 = 8;
                n5 = ((long[])object).length;
                n6 = ((long[])object2).length;
            } else if (object2 instanceof double[]) {
                n4 = 8;
                n5 = ((double[])object).length;
                n6 = ((double[])object2).length;
            } else if (object2 instanceof int[]) {
                n4 = 4;
                n5 = ((int[])object).length;
                n6 = ((int[])object2).length;
            } else if (object2 instanceof float[]) {
                n4 = 4;
                n5 = ((float[])object).length;
                n6 = ((float[])object2).length;
            } else if (object2 instanceof short[]) {
                n4 = 2;
                n5 = ((short[])object).length;
                n6 = ((short[])object2).length;
            } else if (object2 instanceof char[]) {
                n4 = 2;
                n5 = ((char[])object).length;
                n6 = ((char[])object2).length;
            } else if (object2 instanceof byte[]) {
                n4 = 1;
                n5 = ((byte[])object).length;
                n6 = ((byte[])object2).length;
            } else if (object2 instanceof boolean[]) {
                n4 = 1;
                n5 = ((boolean[])object).length;
                n6 = ((boolean[])object2).length;
            } else {
                n4 = 4;
                n5 = ((Object[])object).length;
                n6 = ((Object[])object2).length;
                bl = true;
            }
        }
        catch (ClassCastException classCastException) {
            throw new ArrayStoreException("Non-arrays passed to arraycopy");
        }
        ArrayCopy.arraycopy_check(n5, n, n6, n2, n3);
        ArrayCopy.copy_checks_done(object, n, object2, n2, n3, n4, bl);
    }

    @ForceInline
    private static void copy_checks_done(Object object, int n, Object object2, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            if (object != object2 || n >= n2) {
                ArrayCopy.fcopyObject(object, n, object2, n2, n3, n4);
            } else {
                ArrayCopy.rcopyObject(object, n, n2, n3, n4);
            }
        } else if (object != object2 || n >= n2) {
            ArrayCopy.fcopy(object, n, object2, n2, n3, n4);
        } else {
            ArrayCopy.rcopy(object, n, n2, n3, n4);
        }
    }

    private static void copy_checks_done1(Object object, int n, Object object2, int n2, int n3) {
        ArrayCopy.copy_checks_done(object, n, object2, n2, n3, 1, false);
    }

    private static void copy_checks_done2(Object object, int n, Object object2, int n2, int n3) {
        ArrayCopy.copy_checks_done(object, n, object2, n2, n3, 2, false);
    }

    private static void copy_checks_done4(Object object, int n, Object object2, int n2, int n3) {
        ArrayCopy.copy_checks_done(object, n, object2, n2, n3, 4, false);
    }

    private static void copy_checks_done8(Object object, int n, Object object2, int n2, int n3) {
        ArrayCopy.copy_checks_done(object, n, object2, n2, n3, 8, false);
    }

    private static void copy_checks_doneObj(Object object, int n, Object object2, int n2, int n3) {
        ArrayCopy.copy_checks_done(object, n, object2, n2, n3, 4, true);
    }

    @ForceInline
    private static void arraycopy_check(int n, int n2, int n3, int n4, int n5) {
        int n6 = n2 + n5;
        int n7 = n4 + n5;
        if (n2 < 0 || n4 < 0 || n5 < 0 || n6 > n || n6 < 0 || n7 > n3 || n7 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @ForceInline
    private static boolean isOffsetAligned(int n) {
        return (n & 3) == 0;
    }

    @ForceInline
    private static boolean hasSameAlignment(int n, int n2) {
        return (n & 3) == (n2 & 3);
    }

    @ForceInline
    private static void fcopy(Object object, int n, Object object2, int n2, int n3, int n4) {
        n = 16 + n * n4;
        n2 = 16 + n2 * n4;
        int n5 = n3 * n4;
        if (!ArrayCopy.isOffsetAligned(n2)) {
            if (n5 <= 15) {
                ArrayCopy.memcpyUnaligned(object, n, object2, n2, n5, n4);
                return;
            }
            int n6 = 4 - (n2 & 3);
            n5 -= n6;
            ArrayCopy.memcpy_alignup(object, n, object2, n2, n6, n4);
            n += n6;
            n2 += n6;
        }
        ArrayCopy.memcpyBlock(object, n, object2, n2, n5, n4);
    }

    @ForceInline
    private static void memcpyBlock(Object object, int n, Object object2, int n2, int n3, int n4) {
        if (n4 == 2) {
            ArrayCopy.memcpy_block2(object, n, object2, n2, n3);
        } else if (n4 == 4) {
            ArrayCopy.memcpy_block4(object, n, object2, n2, n3);
        } else if (n4 == 8) {
            ArrayCopy.memcpy_block8(object, n, object2, n2, n3);
        } else {
            ArrayCopy.memcpy_block1(object, n, object2, n2, n3);
        }
    }

    @ForceInline
    private static void memcpyUnaligned(Object object, int n, Object object2, int n2, int n3, int n4) {
        if (n4 == 2) {
            ArrayCopy.memcpy_unaligned2(object, n, object2, n2, n3);
        } else {
            ArrayCopy.memcpy_unaligned1(object, n, object2, n2, n3);
        }
    }

    private static void rcopy(Object object, int n, int n2, int n3, int n4) {
        int n5 = n3 * n4;
        n = 16 + n * n4 + n5;
        n2 = 16 + n2 * n4 + n5;
        if (n5 < 4 || !ArrayCopy.isOffsetAligned(n2) || !ArrayCopy.isOffsetAligned(n)) {
            ArrayCopy.rmemcpy_unaligned(object, n, n2, n5, n4);
        } else {
            ArrayCopy.rmemcpy_block(object, n - 4, n2 - 4, n5 & 0xFFFFFFFC);
            n -= n5 & 0xFFFFFFFC;
            n2 -= n5 & 0xFFFFFFFC;
            if ((n5 &= 3) > 0) {
                ArrayCopy.rmemcpy_unaligned(object, n, n2, n5, n4);
            }
        }
    }

    @ForceInline
    private static void fcopyObject(Object object, int n, Object object2, int n2, int n3, int n4) {
        if (!Reflect.IClass.isAssignable(object2, object)) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            int n5 = n + n3;
            while (n < n5) {
                objectArray2[n2++] = objectArray[n++];
            }
            return;
        }
        n = 16 + n * n4;
        n2 = 16 + n2 * n4;
        int n6 = n3 * n4;
        ArrayCopy.memcpy_block_o(object, n, object2, n2, n6);
    }

    private static void rcopyObject(Object object, int n, int n2, int n3, int n4) {
        int n5 = n3 * n4;
        n = 16 + n * n4 + n5;
        n2 = 16 + n2 * n4 + n5;
        ArrayCopy.rmemcpy_block_o(object, n - 4, n2 - 4, n5);
    }

    private static native void memcpy_block1(Object var0, int var1, Object var2, int var3, int var4);

    private static native void memcpy_block2(Object var0, int var1, Object var2, int var3, int var4);

    private static native void memcpy_block4(Object var0, int var1, Object var2, int var3, int var4);

    private static native void memcpy_block8(Object var0, int var1, Object var2, int var3, int var4);

    private static native void memcpy_alignup(Object var0, int var1, Object var2, int var3, int var4, int var5);

    private static native void memcpy_unaligned1(Object var0, int var1, Object var2, int var3, int var4);

    private static native void memcpy_unaligned2(Object var0, int var1, Object var2, int var3, int var4);

    private static native void memcpy_unaligned4(Object var0, int var1, Object var2, int var3, int var4);

    private static native void memcpy_unaligned_large(Object var0, int var1, Object var2, int var3, int var4, int var5);

    private static native void rmemcpy_block(Object var0, int var1, int var2, int var3);

    private static native void rmemcpy_unaligned(Object var0, int var1, int var2, int var3, int var4);

    private static native void memcpy_block_o(Object var0, int var1, Object var2, int var3, int var4);

    private static native void rmemcpy_block_o(Object var0, int var1, int var2, int var3);

    private static native void memcpy_blockInner1(Object var0, Object var1, Object var2, Object var3, int var4);

    private static native void memcpy_blockInner2(Object var0, Object var1, Object var2, Object var3, int var4);

    private static native void memcpy_blockInner4(Object var0, Object var1, Object var2, Object var3, int var4);

    private static native void memcpy_blockInner8(Object var0, Object var1, Object var2, Object var3, int var4);
}

