/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import com.bea.jvm.ClassPreProcessor;
import java.lang.reflect.Method;
import jrockit.vm.Reflect;

public class ClassPreProcessorManager {
    private static ClassPreProcessor preProcessor = null;

    private ClassPreProcessorManager() {
    }

    public static void setPreProcessor(ClassPreProcessor classPreProcessor) {
        preProcessor = classPreProcessor;
        ClassPreProcessorManager.initialize();
    }

    public static ClassPreProcessor getPreProcessor() {
        return preProcessor;
    }

    static void initialize() {
        Class<ClassPreProcessorManager> clazz = ClassPreProcessorManager.class;
        if (preProcessor != null) {
            try {
                Method method = clazz.getDeclaredMethod("notifyClassPreProcessor", Integer.TYPE, String.class, byte[].class);
                ClassPreProcessorManager.setClassPreProcessorMethod(Reflect.IMethod.getID(method));
            }
            catch (Exception exception) {
                throw new InternalError(exception.getMessage());
            }
        } else {
            ClassPreProcessorManager.setClassPreProcessorMethod(0);
        }
    }

    private static byte[] notifyClassPreProcessor(int n, String string, byte[] byArray) {
        byte[] byArray2 = preProcessor.preProcess(Reflect.IClassLoader.get(n), string, byArray);
        if (byArray2 == null) {
            byArray2 = byArray;
        }
        return byArray2;
    }

    private static native void setClassPreProcessorMethod(int var0);
}

