/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import jrockit.mapi.ClassLibraryImpl;
import jrockit.nio.ch.DirectBuffer;
import jrockit.vm.FCECache;
import jrockit.vm.Reflect;

public final class Classes {
    private static ClassLibraryImpl classLibImpl;
    static FCECache fnCache;
    static FCECache flcCache;

    private Classes() {
    }

    public static void setClassLibraryImpl(ClassLibraryImpl classLibraryImpl) {
        classLibImpl = classLibraryImpl;
    }

    public static void setSystemClassLoader(ClassLoader classLoader) {
        Classes.setSystemClassLoader(Reflect.IClassLoader.getID(classLoader));
    }

    public static native void setSystemClassLoader(int var0);

    public static final Class findBootstrapClass(String string) throws ClassNotFoundException {
        return Classes.forName0(string, false, null);
    }

    public static final Class findLoadedClass(ClassLoader classLoader, String string) {
        if (string == null) {
            return null;
        }
        FCECache.FCEEntry fCEEntry = flcCache.find(classLoader, string);
        Class clazz = fCEEntry.get();
        if (clazz == null && (clazz = Classes.findLoadedClass0(classLoader, string)) != null) {
            fCEEntry.set(classLoader, clazz);
        }
        return clazz;
    }

    private static final native Class findLoadedClass0(ClassLoader var0, String var1);

    public static final Class forName(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        if (string.indexOf(47) != -1) {
            return null;
        }
        FCECache.FCEEntry fCEEntry = flcCache.find(classLoader, string);
        Class clazz = fCEEntry.get();
        if (clazz == null) {
            clazz = Classes.forName0(string, bl, classLoader);
            if (clazz != null) {
                fCEEntry.set(classLoader, clazz);
            }
        } else if (bl) {
            Reflect.IClass.ensureInitialized(clazz);
        }
        return clazz;
    }

    private static native Class forName0(String var0, boolean var1, ClassLoader var2);

    public static Class defineClass(ClassLoader classLoader, String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain, String string2) throws ClassFormatError {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 == 0) {
            throw new ClassFormatError(string);
        }
        Class clazz = Classes.defineClass0(classLoader, string, byArray, n, n2, protectionDomain, string2);
        if (clazz == null) {
            throw new ClassFormatError(string);
        }
        if (classLibImpl != null) {
            classLibImpl.classLoaded(clazz);
        }
        return clazz;
    }

    public static Class defineClass(ClassLoader classLoader, String string, ByteBuffer byteBuffer, int n, int n2, ProtectionDomain protectionDomain, String string2) throws ClassFormatError {
        if (!byteBuffer.isDirect()) {
            throw new InternalError();
        }
        int n3 = ((DirectBuffer)((Object)byteBuffer)).address();
        Class clazz = Classes.defineClass1(classLoader, string, n3, n, n2, protectionDomain, string2);
        if (clazz == null) {
            throw new ClassFormatError(string);
        }
        if (classLibImpl != null) {
            classLibImpl.classLoaded(clazz);
        }
        return clazz;
    }

    private static native Class defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, String var6);

    private static native Class defineClass1(ClassLoader var0, String var1, int var2, int var3, int var4, ProtectionDomain var5, String var6);

    public static native Class getFirstClassNamed(String var0);

    static {
        fnCache = new FCECache();
        flcCache = new FCECache();
    }
}

