/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import jrockit.annotations.Internal;
import jrockit.annotations.ThrowCycle;
import jrockit.vm.Reflect;
import jrockit.vm.Strings;

@Internal
public final class ExceptionHandler {
    private ExceptionHandler() {
    }

    private static native void setGuardPage();

    private static native void fillInStackTrace(Object var0);

    private static native void throwAsyncException();

    private static native Throwable protectCurrentStack(Throwable var0);

    @ThrowCycle
    public static native void throwException(Throwable var0);

    @ThrowCycle
    private static native void gotoHandler();

    private static void throwClassCastException(int n, int n2) {
        throw new ClassCastException(Reflect.IClassBlock.getClass(n).getName());
    }

    private static native void throwMissingCDPReference(int var0, int var1, int var2);

    private static void throwIncompatibleClassChangeError(int n) {
        throw new IncompatibleClassChangeError(Reflect.IClass.get(n).getName());
    }

    private static void throwIllegalAccess(int n) {
        throw new IllegalAccessError(Strings.getString(n));
    }

    private static void throwIllegalAccessInterface(int n) {
        throw new IllegalAccessError(Reflect.IMethod.getName(n));
    }

    private static void throwArrayStoreException() {
        throw new ArrayStoreException("Object and inner type of array differs");
    }

    private static void throwClassCastToArrayException() {
        throw new ClassCastException("Class cannot be casted to array");
    }

    private static void throwArrayTooLarge() {
        throw new OutOfMemoryError("array too large");
    }

    private static void throwNegativeArraySize() {
        throw new NegativeArraySizeException();
    }

    private static void throwInstantiationError(int n) {
        throw new InstantiationError(Reflect.IClass.get(n).getName());
    }

    private static void throwFinalFieldAssignedError() {
        throw new IncompatibleClassChangeError("Tried to assign final field");
    }
}

