/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import jrockit.rls.Rls;
import jrockit.rls.VmAdapter;
import jrockit.vm.Access;
import jrockit.vm.Classes;
import jrockit.vm.Locks;
import jrockit.vm.VM;

public final class Kickstart {
    private static final String USE_SERVER_PROPERTY = "jrockit.managementserver";
    private String[] managementClasses = new String[0];
    private String[] managementPaths = new String[0];

    private Kickstart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Kickstart kickstart = this;
        synchronized (kickstart) {
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Access.lang().systemInitializeSystemClass();
        boolean bl = this.parseManagementSettings();
        if (bl) {
            this.addManagementPath();
        }
        try {
            Locks.monitorExitForced(new byte[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Classes.setSystemClassLoader(classLoader);
        String string = System.getProperty("jrockit.use.rls");
        if (string != null && VmAdapter.approvedGC()) {
            Rls.start(Boolean.valueOf(string));
        }
        if (bl) {
            this.instantiateManagementClasses();
        }
        try {
            new String(new byte[0], "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private boolean parseManagementSettings() {
        boolean bl;
        String string = System.getProperty("com.bea.jvm.Client.Args");
        boolean bl2 = bl = Boolean.getBoolean(USE_SERVER_PROPERTY) || System.getProperty("com.sun.management.jmxremote.port") != null;
        if (string == null && !bl) {
            return false;
        }
        if (string != null && !"".equals(string)) {
            int n = 0;
            while (true) {
                int n2 = string.indexOf(61, n);
                int n3 = string.indexOf(44, n);
                if (n2 == -1) {
                    System.err.println("ERROR: illegal argument: " + string);
                    break;
                }
                String string2 = string.substring(n, n2);
                String string3 = n3 == -1 ? string.substring(n2 + 1) : string.substring(n2 + 1, n3);
                if (string2.equals("class")) {
                    this.managementClasses = Kickstart.addElementToArray(this.managementClasses, string3);
                } else if (string2.equals("classpath")) {
                    this.managementPaths = Kickstart.addElementToArray(this.managementPaths, string3);
                }
                if (n3 == -1) break;
                n = n3 + 1;
            }
        }
        return true;
    }

    private String[] getManagementPaths() {
        if (this.managementPaths.length == 0) {
            this.managementPaths = Kickstart.addElementToArray(this.managementPaths, System.getProperty("java.home") + "/lib/managementserver.jar");
            try {
                if (!new File(this.managementPaths[0]).exists()) {
                    this.managementPaths[0] = new File(VM.getProperty("jrockit.vm")).getParentFile().getParentFile().getParent() + "/console/server/managementserver.jar";
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this.managementPaths;
    }

    public boolean addManagementPath() {
        String[] stringArray = this.getManagementPaths();
        if (stringArray.length == 0) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder(System.getProperty("java.class.path"));
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(File.pathSeparatorChar);
            stringBuilder.append(stringArray[i]);
        }
        System.setProperty("java.class.path", stringBuilder.toString());
        return true;
    }

    private void instantiateManagementClasses() {
        for (int i = 0; i < this.managementClasses.length; ++i) {
            if (this.managementClasses[i] == null) continue;
            try {
                Class.forName(this.managementClasses[i], true, ClassLoader.getSystemClassLoader()).newInstance();
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("[JRockit] ERROR: class " + this.managementClasses[i] + " not found.");
                continue;
            }
            catch (Exception exception) {
                System.err.println("[JRockit] ERROR: failed to initialize class " + this.managementClasses[i] + ".");
            }
        }
    }

    private static String[] addElementToArray(String[] stringArray, String string) {
        String[] stringArray2 = null;
        int n = stringArray.length;
        stringArray2 = new String[n + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray2[n] = string;
        return stringArray2;
    }

    private static Class findManagementClass(final String string) {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return Class.forName(string, false, ClassLoader.getSystemClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        String[] stringArray = new Kickstart().getManagementPaths();
                        assert (stringArray.length == 1);
                        return new URLClassLoader(new URL[]{new File(stringArray[0]).toURL()}).loadClass(string);
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    private static void canIKickIt() {
        Kickstart kickstart = new Kickstart();
        kickstart.run();
    }
}

