/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.io.UnsupportedEncodingException;
import jrockit.vm.Intrinsics;
import jrockit.vm.Reflect;
import jrockit.vm.VM;

public final class Memory {
    private static volatile long maxDirectMemory = -1L;
    private static volatile long reservedDirectMemory = 0L;
    public static final int BYTES_INT = 4;
    public static final int BYTES_FLOAT = 4;
    public static final int BYTES_DOUBLE = 8;
    public static final int BYTES_LONG = 8;
    public static final int BYTES_SHORT = 2;
    public static final int BYTES_CHAR = 2;
    public static final int BYTES_BYTE = 1;
    public static final int BYTES_BOOLEAN = 1;
    public static final int BYTES_ADDRESS = 4;

    private Memory() {
    }

    public static native Object getObject(Object var0, int var1);

    public static native int getAddress(Object var0, int var1);

    public static native long getLong(Object var0, int var1);

    public static native int getInt(Object var0, int var1);

    public static native short getShort(Object var0, int var1);

    public static native char getChar(Object var0, int var1);

    public static native byte getByte(Object var0, int var1);

    public static native int getUByte(Object var0, int var1);

    public static native boolean getBoolean(Object var0, int var1);

    public static native double getDouble(Object var0, int var1);

    public static native float getFloat(Object var0, int var1);

    public static native Object getObject(int var0, int var1);

    public static native int getAddress(int var0, int var1);

    public static native long getLong(int var0, int var1);

    public static native int getInt(int var0, int var1);

    public static native short getShort(int var0, int var1);

    public static native char getChar(int var0, int var1);

    public static native byte getByte(int var0, int var1);

    public static native int getUByte(int var0, int var1);

    public static native boolean getBoolean(int var0, int var1);

    public static native double getDouble(int var0, int var1);

    public static native float getFloat(int var0, int var1);

    public static Object getObject(int n) {
        return Memory.getObject(n, 0);
    }

    public static int getAddress(int n) {
        return Memory.getAddress(n, 0);
    }

    public static long getLong(int n) {
        return Memory.getLong(n, 0);
    }

    public static int getInt(int n) {
        return Memory.getInt(n, 0);
    }

    public static short getShort(int n) {
        return Memory.getShort(n, 0);
    }

    public static char getChar(int n) {
        return Memory.getChar(n, 0);
    }

    public static byte getByte(int n) {
        return Memory.getByte(n, 0);
    }

    public static boolean getBoolean(int n) {
        return Memory.getBoolean(n, 0);
    }

    public static double getDouble(int n) {
        return Memory.getDouble(n, 0);
    }

    public static float getFloat(int n) {
        return Memory.getFloat(n, 0);
    }

    public static native void setObject(Object var0, int var1, Object var2);

    public static native void setObject(Class var0, int var1, Object var2);

    public static native void setAddress(Object var0, int var1, int var2);

    public static native void setAddress(Object var0, int var1, Object var2);

    public static native void setLong(Object var0, int var1, long var2);

    public static native void setInt(Object var0, int var1, int var2);

    public static native void setShort(Object var0, int var1, short var2);

    public static native void setChar(Object var0, int var1, char var2);

    public static native void setByte(Object var0, int var1, byte var2);

    public static native void setBoolean(Object var0, int var1, boolean var2);

    public static native void setDouble(Object var0, int var1, double var2);

    public static native void setFloat(Object var0, int var1, float var2);

    public static native void setObject(int var0, int var1, Object var2);

    public static native void setAddress(int var0, int var1, int var2);

    public static native void setAddress(int var0, int var1, Object var2);

    public static native void setLong(int var0, int var1, long var2);

    public static native void setInt(int var0, int var1, int var2);

    public static native void setShort(int var0, int var1, short var2);

    public static native void setChar(int var0, int var1, char var2);

    public static native void setByte(int var0, int var1, byte var2);

    public static native void setBoolean(int var0, int var1, boolean var2);

    public static native void setDouble(int var0, int var1, double var2);

    public static native void setFloat(int var0, int var1, float var2);

    public static void setObject(int n, Object object) {
        Memory.setObject(n, 0, object);
    }

    public static void setAddress(int n, int n2) {
        Memory.setAddress(n, 0, n2);
    }

    public static void setAddress(int n, Object object) {
        Memory.setAddress(n, 0, object);
    }

    public static void setLong(int n, long l) {
        Memory.setLong(n, 0, l);
    }

    public static void setInt(int n, int n2) {
        Memory.setInt(n, 0, n2);
    }

    public static void setShort(int n, short s) {
        Memory.setShort(n, 0, s);
    }

    public static void setChar(int n, char c) {
        Memory.setChar(n, 0, c);
    }

    public static void setByte(int n, byte by) {
        Memory.setByte(n, 0, by);
    }

    public static void setBoolean(int n, boolean bl) {
        Memory.setBoolean(n, 0, bl);
    }

    public static void setDouble(int n, double d) {
        Memory.setDouble(n, 0, d);
    }

    public static void setFloat(int n, float f) {
        Memory.setFloat(n, 0, f);
    }

    public static short getShortVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getShort(object, n);
    }

    public static void setShortVolatile(Object object, int n, short s) {
        Memory.setShort(object, n, s);
        Intrinsics.membar(0);
    }

    public static char getCharVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getChar(object, n);
    }

    public static void setCharVolatile(Object object, int n, char c) {
        Memory.setChar(object, n, c);
        Intrinsics.membar(0);
    }

    public static byte getByteVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getByte(object, n);
    }

    public static void setByteVolatile(Object object, int n, byte by) {
        Memory.setByte(object, n, by);
        Intrinsics.membar(0);
    }

    public static boolean getBooleanVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getBoolean(object, n);
    }

    public static void setBooleanVolatile(Object object, int n, boolean bl) {
        Memory.setBoolean(object, n, bl);
        Intrinsics.membar(0);
    }

    public static double getDoubleVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getDouble(object, n);
    }

    public static void setDoubleVolatile(Object object, int n, double d) {
        Memory.setDouble(object, n, d);
        Intrinsics.membar(0);
    }

    public static float getFloatVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getFloat(object, n);
    }

    public static void setFloatVolatile(Object object, int n, float f) {
        Memory.setFloat(object, n, f);
        Intrinsics.membar(0);
    }

    public static void setIntVolatile(Object object, int n, int n2) {
        Memory.setInt(object, n, n2);
        Intrinsics.membar(0);
    }

    public static int getIntVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getInt(object, n);
    }

    public static void setLongVolatile(Object object, int n, long l) {
        Memory.setLong(object, n, l);
        Intrinsics.membar(0);
    }

    public static long getLongVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getLong(object, n);
    }

    public static void setObjectVolatile(Object object, int n, Object object2) {
        Memory.setObject(object, n, object2);
        Intrinsics.membar(0);
    }

    public static Object getObjectVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getObject(object, n);
    }

    public static native long cas(Object var0, int var1, long var2, long var4);

    public static native int cas(Object var0, int var1, int var2, int var3);

    public static native short cas(Object var0, int var1, short var2, short var3);

    public static native byte cas(Object var0, int var1, byte var2, byte var3);

    public static native Object cas(Object var0, int var1, Object var2, Object var3);

    public static native long cas(int var0, int var1, long var2, long var4);

    public static native int cas(int var0, int var1, int var2, int var3);

    public static native short cas(int var0, int var1, short var2, short var3);

    public static native byte cas(int var0, int var1, byte var2, byte var3);

    public static native Object cas(int var0, int var1, Object var2, Object var3);

    public static long swap(Object object, int n, long l) {
        long l2;
        while (Memory.cas(object, n, l2 = Memory.getLong(object, n), l) != l2) {
        }
        return l2;
    }

    public static int swap(Object object, int n, int n2) {
        int n3;
        while (Memory.cas(object, n, n3 = Memory.getInt(object, n), n2) != n3) {
        }
        return n3;
    }

    public static native int getArrayData(long[] var0, int var1);

    public static native int getArrayData(int[] var0, int var1);

    public static native int getArrayData(short[] var0, int var1);

    public static native int getArrayData(char[] var0, int var1);

    public static native int getArrayData(byte[] var0, int var1);

    public static native int getArrayData(boolean[] var0, int var1);

    public static native int getArrayData(double[] var0, int var1);

    public static native int getArrayData(float[] var0, int var1);

    public static native int bswap(int var0);

    public static native short bswap(short var0);

    public static native char bswap(char var0);

    public static native long bswap(long var0);

    public static float bswap(float f) {
        return Float.intBitsToFloat(Memory.bswap(Float.floatToRawIntBits(f)));
    }

    public static double bswap(double d) {
        return Double.longBitsToDouble(Memory.bswap(Double.doubleToRawLongBits(d)));
    }

    public static int ntoh(int n) {
        return Memory.bswap(n);
    }

    public static short ntoh(short s) {
        return Memory.bswap(s);
    }

    public static char ntoh(char c) {
        return Memory.bswap(c);
    }

    public static long ntoh(long l) {
        return Memory.bswap(l);
    }

    public static int hton(int n) {
        return Memory.bswap(n);
    }

    public static short hton(short s) {
        return Memory.bswap(s);
    }

    public static char hton(char c) {
        return Memory.bswap(c);
    }

    public static long hton(long l) {
        return Memory.bswap(l);
    }

    public static int getArrayLength(Object object) {
        return Memory.getInt(object, 8);
    }

    public static Class[] getClasses(int n, int n2) {
        Class[] classArray = new Class[n2];
        for (int i = 0; i < n2; ++i) {
            classArray[i] = Reflect.IClass.get(Memory.getAddress(n, i * Memory.addressSize()));
        }
        return classArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reserveDirectMemory(long l) {
        Class<Memory> clazz = Memory.class;
        synchronized (Memory.class) {
            if (maxDirectMemory < 0L) {
                String string = VM.getProperty("jrockit.directmemory.max");
                maxDirectMemory = string == null ? Long.MAX_VALUE : Long.parseLong(string);
            }
            if (l <= maxDirectMemory - reservedDirectMemory) {
                reservedDirectMemory += l;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            System.runFinalization();
            clazz = Memory.class;
            synchronized (Memory.class) {
                if (l + reservedDirectMemory > maxDirectMemory) {
                    throw new OutOfMemoryError("Direct buffer memory");
                }
                reservedDirectMemory += l;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unreserveDirectMemory(long l) {
        Class<Memory> clazz = Memory.class;
        synchronized (Memory.class) {
            reservedDirectMemory -= l;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    public static long getReservedDirectMemory() {
        return reservedDirectMemory;
    }

    public static native int allocateMemory(int var0);

    public static native int reallocateMemory(int var0, int var1);

    public static native void freeMemory(int var0);

    public static native void releaseGlobalRef(int var0);

    public static native void copyMemory(int var0, int var1, int var2);

    public static native void setMemory(int var0, int var1, int var2);

    public static native int pageSize();

    public static final int addressSize() {
        return 4;
    }

    public static final int objectHeaderSize() {
        return 8;
    }

    public static final int baseObjectSize() {
        return 8;
    }

    public static final int arrayHeaderSize() {
        return 16;
    }

    public static native Object getLockToken(Object var0, int var1);

    public static native Object getObjectFromToken(Object var0);

    public static native int objectAsAddress(Object var0);

    public static class DumpReader {
        private int pointer;

        public DumpReader(int n) {
            this.pointer = n;
        }

        public int align(int n) {
            while (this.pointer % n != 0) {
                ++this.pointer;
            }
            return this.pointer;
        }

        public int readInt() {
            int n = Memory.getInt(this.align(4));
            this.pointer += 4;
            return n;
        }

        public byte readByte() {
            byte by = Memory.getByte(this.pointer);
            ++this.pointer;
            return by;
        }

        public boolean readBoolean() {
            boolean bl = Memory.getBoolean(this.pointer);
            ++this.pointer;
            return bl;
        }

        public short readShort() {
            short s = Memory.getShort(this.align(2));
            this.pointer += 2;
            return s;
        }

        public char readChar() {
            char c = Memory.getChar(this.align(2));
            this.pointer += 2;
            return c;
        }

        public long readLong() {
            long l = Memory.getLong(this.align(8));
            this.pointer += 8;
            return l;
        }

        public float readFloat() {
            float f = Memory.getFloat(this.align(4));
            this.pointer += 4;
            return f;
        }

        public double readDouble() {
            double d = Memory.getDouble(this.align(8));
            this.pointer += 8;
            return d;
        }

        public int readAddress() {
            int n = Memory.getAddress(this.align(4));
            this.pointer += 4;
            return n;
        }

        public String readIString(boolean bl) {
            int n = this.readInt();
            if (n == 0) {
                return null;
            }
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.readByte();
                if (!bl || byArray[i] != 47) continue;
                byArray[i] = 46;
            }
            try {
                return new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return "...";
            }
        }

        public String readJString() {
            int n = this.readInt();
            if (n == 0) {
                return null;
            }
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.readChar();
            }
            return new String(cArray);
        }
    }
}

