/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jrockit.annotations.ImmutableLoad;
import jrockit.annotations.NoSafePoint;
import jrockit.vm.Memory;
import jrockit.vm.Strings;

public class Reflect {
    public static final int CG_STRATEGY_TRAMPOLINE = -1;
    public static final int CG_STRATEGY_NORMAL = 0;
    public static final int CG_STRATEGY_QUICK = 1;
    public static final int CG_STRATEGY_OPTIMIZED = 2;
    public static final int CG_STRATEGY_CODECACHE = 3;

    private Reflect() {
    }

    public static native int offset(int var0);

    public static void checkArrayStore(Object object, Object object2) {
        int n;
        int n2;
        if (object2 != null && (n2 = IClassBlock.getCB(object2)) != (n = IClassBlock.getInnerCB(IClassBlock.getCB(object)))) {
            boolean bl;
            int n3 = IClassBlock.getJlcType(n);
            switch (n3) {
                case 1: {
                    bl = IClassBlock.isAssignableNormal(n, n2);
                    break;
                }
                case 3: {
                    bl = IClassBlock.isAssignableArray(n, n2);
                    break;
                }
                case 2: {
                    bl = IClassBlock.isAssignableInterface(n, n2);
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (!bl) {
                throw new ArrayStoreException("Cannot store " + object2.getClass().getName() + " in " + object.getClass().getName());
            }
        }
    }

    public static native int[] getMethodIDContext(boolean var0);

    public static native int getCallerClassID();

    public static native Class getCallerClass();

    public static native ClassLoader getCallerClassLoader();

    public static native int getCallerClassLoaderID();

    private static native int getStrategy0(int var0);

    private static native boolean isOptimized0(int var0);

    private static native int getCallerClassID(int var0);

    private static Class getCallerClass(int n) {
        return IClass.get(Reflect.getCallerClassID(n));
    }

    public static Class getCallerClass(Class clazz) {
        return IClass.get(Reflect.getCallerClassID(IClass.getID(clazz)));
    }

    private static int getCallerClassLoaderID(int n) {
        return IClass.getClassLoaderID(Reflect.getCallerClassID(n));
    }

    private static ClassLoader getCallerClassLoader(int n) {
        int n2 = Reflect.getCallerClassLoaderID(n);
        return n2 == 0 ? null : IClassLoader.get(n2);
    }

    private static native String getConstantString(Class var0, int var1);

    public static final class IZipEntry {
        public static long getCSize(int n) {
            long l = Memory.getInt(n, Reflect.offset(3840));
            if (l == 0L) {
                l = IZipEntry.getSize(n);
            }
            return l;
        }

        public static int getMethod(int n) {
            if (Memory.getInt(n, Reflect.offset(3840)) == 0) {
                return 0;
            }
            return 8;
        }

        public static long getSize(int n) {
            return Memory.getInt(n, Reflect.offset(3841));
        }

        public static long getPos(int n) {
            return Memory.getInt(n, Reflect.offset(3842));
        }
    }

    public static final class IZStream {
        public static final int Z_OK = 0;
        public static final int Z_STREAM_END = 1;
        public static final int Z_NEED_DICT = 2;
        public static final int Z_ERRNO = -1;
        public static final int Z_STREAM_ERROR = -2;
        public static final int Z_DATA_ERROR = -3;
        public static final int Z_MEM_ERROR = -4;
        public static final int Z_BUF_ERROR = -5;
        public static final int Z_VERSION_ERROR = -6;

        public static int getAvailIn(int n) {
            return Memory.getInt(n, Reflect.offset(3328));
        }

        public static int getAvailOut(int n) {
            return Memory.getInt(n, Reflect.offset(3329));
        }
    }

    public static class DTableIterator {
        private int table;
        private int end;
        private int curr;
        private int size;

        public DTableIterator(int n) {
            this.table = n;
            this.reset();
        }

        private void reset() {
            this.size = Memory.getAddress(this.table, Reflect.offset(2818));
            this.end = this.table + this.size * Reflect.offset(2816);
            this.curr = this.table + Reflect.offset(2816);
        }

        public long getSize() {
            return this.size;
        }

        public boolean valid() {
            return this.curr < this.end;
        }

        public void next() {
            this.curr += Reflect.offset(2816);
        }

        public int getIMethod() {
            return Memory.getAddress(this.curr, Reflect.offset(2817));
        }

        public int getImplCount() {
            return Memory.getInt(this.curr, Reflect.offset(2819));
        }
    }

    public static final class IMethodIterator {
        public static final int ALL = 0;
        public static final int STATICS = 1;
        public static final int INSTANCE = 2;
        public static final int INITS = 3;
        private int cID;
        private int mID;
        private int endID;
        private int type;

        public IMethodIterator(int n, int n2) {
            this.cID = n;
            this.type = n2;
            this.reset();
        }

        public IMethodIterator(Class clazz, int n) {
            this(IClass.getID(clazz), n);
        }

        public IMethodIterator(Class clazz) {
            this(clazz, 0);
        }

        public IMethodIterator(int n) {
            this(n, 0);
        }

        public boolean valid() {
            return this.mID < this.endID;
        }

        public int getNumStatics() {
            return Memory.getShort(this.cID, Reflect.offset(539));
        }

        public int getNumInstance() {
            return Memory.getShort(this.cID, Reflect.offset(540));
        }

        public int getNumConstuctors() {
            return Memory.getShort(this.cID, Reflect.offset(541));
        }

        public int getNumMethods() {
            return this.getNumStatics() + this.getNumInstance() + this.getNumConstuctors();
        }

        public void reset() {
            this.mID = Memory.getAddress(this.cID, Reflect.offset(534));
            if (IClass.hasClinit(this.cID)) {
                this.mID += Reflect.offset(867);
            }
            switch (this.type) {
                case 0: {
                    this.endID = this.mID + Reflect.offset(867) * this.getNumMethods();
                    break;
                }
                case 1: {
                    this.endID = this.mID + Reflect.offset(867) * this.getNumStatics();
                    break;
                }
                case 2: {
                    this.mID += Reflect.offset(867) * (this.getNumStatics() + this.getNumConstuctors());
                    this.endID = this.mID + Reflect.offset(867) * this.getNumInstance();
                    break;
                }
                case 3: {
                    this.mID += Reflect.offset(867) * this.getNumStatics();
                    this.endID = this.mID + Reflect.offset(867) * this.getNumConstuctors();
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        public int getIMethod() {
            return this.mID;
        }

        public void next() {
            this.mID += Reflect.offset(867);
        }
    }

    public static final class IFieldIterator {
        public static final int ALL = 0;
        public static final int STATICS = 1;
        public static final int INSTANCE = 2;
        private int cID;
        private int fID;
        private int endID;
        private int statVars;
        private int off;
        private int type;

        public IFieldIterator(int n, int n2) {
            this.cID = n;
            this.type = n2;
            this.reset();
        }

        public IFieldIterator(int n) {
            this(n, 0);
        }

        public IFieldIterator(Class clazz, int n) {
            this(IClass.getID(clazz), n);
        }

        public IFieldIterator(Class clazz) {
            this(clazz, 0);
        }

        public boolean valid() {
            return this.fID < this.endID;
        }

        public int getNumStatics() {
            return Memory.getShort(this.cID, Reflect.offset(543));
        }

        public int getNumInstance() {
            return Memory.getShort(this.cID, Reflect.offset(542));
        }

        public int getNumFields() {
            return this.getNumStatics() + this.getNumInstance();
        }

        public void reset() {
            this.fID = Memory.getAddress(this.cID, Reflect.offset(544));
            switch (this.type) {
                case 0: {
                    this.endID = this.fID + Reflect.offset(1123) * this.getNumFields();
                    break;
                }
                case 1: {
                    this.endID = this.fID + Reflect.offset(1123) * this.getNumStatics();
                    break;
                }
                case 2: {
                    this.fID = Memory.getAddress(this.cID, Reflect.offset(544)) + Reflect.offset(1123) * this.getNumStatics();
                    this.endID = this.fID + Reflect.offset(1123) * this.getNumInstance();
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            this.statVars = Memory.getAddress(this.cID, Reflect.offset(556));
            this.off = Memory.getInt(this.fID, Reflect.offset(1029));
        }

        public int getIField() {
            return this.fID;
        }

        public int getIType() {
            return Memory.getAddress(this.fID, Reflect.offset(1024));
        }

        public int getJlcType() {
            return IClass.getJlcType(this.getIType());
        }

        public void next() {
            this.fID += Reflect.offset(1123);
            this.off = Memory.getInt(this.fID, Reflect.offset(1029));
        }
    }

    public static class IClassLoader {
        @ImmutableLoad
        public static ClassLoader get(int n) {
            return n == 0 ? null : IClassLoader.getNoCheck(n);
        }

        @ImmutableLoad
        public static ClassLoader getNoCheck(int n) {
            return (ClassLoader)Memory.getObject(n, Reflect.offset(1536));
        }

        @ImmutableLoad
        public static int getID(ClassLoader classLoader) {
            return classLoader == null ? 0 : IClassLoader.getIDNoCheck(classLoader);
        }

        @ImmutableLoad
        public static int getIDNoCheck(ClassLoader classLoader) {
            return Memory.getAddress(classLoader, Reflect.offset(4098));
        }

        public static void setParent(ClassLoader classLoader, ClassLoader classLoader2) {
            IClassLoader.setParent(IClassLoader.getID(classLoader), IClassLoader.getID(classLoader2));
        }

        public static void setParent(int n, int n2) {
            Memory.setAddress(n, Reflect.offset(1537), n2);
        }
    }

    public static class IField
    extends IAccessibleObject {
        public static final int INVALID_FIELD_OFFSET = 0;

        @ImmutableLoad
        public static int getAccessFlags(Field field) {
            return IField.getAccessFlags(IField.getID(field));
        }

        @ImmutableLoad
        public static int getAccessFlags(int n) {
            return (short)(Memory.getInt(n, Reflect.offset(1030)) & 0xFFFF);
        }

        @ImmutableLoad
        public static Class getType(Field field) {
            return IField.getType(IField.getID(field));
        }

        @ImmutableLoad
        public static Class getType(int n) {
            return IClass.getNoCheck(IField.getTypeID(n));
        }

        @ImmutableLoad
        public static int getTypeID(int n) {
            return Memory.getAddress(n, Reflect.offset(1024));
        }

        @ImmutableLoad
        public static int getJlcType(int n) {
            return IClass.getJlcType(IField.getTypeID(n));
        }

        @ImmutableLoad
        public static boolean isPrimitive(int n) {
            return IField.getJlcType(n) < 0;
        }

        @ImmutableLoad
        public static int getOffset(int n) {
            return Memory.getInt(n, Reflect.offset(1029));
        }

        @ImmutableLoad
        public static int getOffset(Field field) {
            return IField.getOffset(IField.getID(field));
        }

        @ImmutableLoad
        public static boolean hasGenericSignature(Field field) {
            return IField.hasGenericSignature(IField.getID(field));
        }

        @ImmutableLoad
        public static boolean hasGenericSignature(int n) {
            return IField.getGenericSignatureIndex(n) != 0;
        }

        @ImmutableLoad
        public static int getGenericSignatureIndex(int n) {
            return Memory.getShort(n, Reflect.offset(1031));
        }

        @ImmutableLoad
        public static int getGenericSignatureIndex(Field field) {
            return IField.getGenericSignatureIndex(IField.getID(field));
        }

        public static String getGenericSignature(Field field) {
            return Reflect.getConstantString(field.getDeclaringClass(), IField.getGenericSignatureIndex(field));
        }
    }

    public static class IConstructor
    extends IMethod {
        public static boolean isCompiled(Constructor constructor) {
            return IConstructor.isCompiled(IConstructor.getID(constructor));
        }

        public static boolean isOptimized(Constructor constructor) {
            return IConstructor.isOptimized(IConstructor.getID(constructor));
        }

        @ImmutableLoad
        public static int getAccessFlags(Constructor constructor) {
            return IConstructor.getAccessFlags(IConstructor.getID(constructor));
        }

        @ImmutableLoad
        public static String getDescriptor(Constructor constructor) {
            return IConstructor.getDescriptor(IConstructor.getID(constructor));
        }

        @ImmutableLoad
        public static boolean hasGenericSignature(Constructor constructor) {
            return IConstructor.hasGenericSignature(IConstructor.getID(constructor));
        }

        @ImmutableLoad
        public static int getGenericSignatureIndex(Constructor constructor) {
            return IConstructor.getGenericSignatureIndex(IConstructor.getID(constructor));
        }

        @ImmutableLoad
        public static String getGenericSignature(Constructor constructor) {
            return Reflect.getConstantString(constructor.getDeclaringClass(), IConstructor.getGenericSignatureIndex(constructor));
        }

        @ImmutableLoad
        public static boolean isEmptyVoid(Constructor constructor) {
            return IConstructor.isEmptyVoid(IConstructor.getID(constructor));
        }
    }

    public static class IMethod
    extends IAccessibleObject {
        public static final int INVALID_METHOD_OFFSET = 0;

        @ImmutableLoad
        public static int getAccessFlags(Method method) {
            return IMethod.getAccessFlags(IMethod.getID(method));
        }

        @ImmutableLoad
        public static int getAccessFlags(int n) {
            return (short)(Memory.getInt(n, Reflect.offset(773)) & 0xFFFF);
        }

        @ImmutableLoad
        public static int getOffset(int n) {
            return Memory.getInt(n, Reflect.offset(772));
        }

        @ImmutableLoad
        public static int getOffset(Method method) {
            return IMethod.getOffset(IMethod.getID(method));
        }

        @ImmutableLoad
        private static int getStateFlags(int n) {
            return IMethod.getAccessFlags(n);
        }

        @ImmutableLoad
        public static boolean isConstructor(int n) {
            return (IMethod.getStateFlags(n) & 0x4000000) == 0x4000000;
        }

        @ImmutableLoad
        public static boolean isClinit(int n) {
            return (IMethod.getStateFlags(n) & 0x2000000) == 0x2000000;
        }

        public static boolean isCompiled(int n) {
            return Reflect.getStrategy0(n) != -1;
        }

        public static boolean isCompiled(Method method) {
            return IMethod.isCompiled(IMethod.getID(method));
        }

        public static boolean isOptimized(int n) {
            return Reflect.getStrategy0(n) == 2;
        }

        public static boolean isOptimized(Method method) {
            return IMethod.isOptimized(IMethod.getID(method));
        }

        public static int getStrategy(Method method) {
            return IMethod.getStrategy(IMethod.getID(method));
        }

        public static int getStrategy(Constructor constructor) {
            return IMethod.getStrategy(IMethod.getID(constructor));
        }

        public static int getStrategy(int n) {
            return Reflect.getStrategy0(n);
        }

        @ImmutableLoad
        public static boolean hasGenericSignature(Method method) {
            return IMethod.hasGenericSignature(IMethod.getID(method));
        }

        @ImmutableLoad
        public static boolean hasGenericSignature(int n) {
            return IMethod.getGenericSignatureIndex(n) != 0;
        }

        @ImmutableLoad
        public static int getGenericSignatureIndex(int n) {
            return Memory.getShort(n, Reflect.offset(789));
        }

        @ImmutableLoad
        public static int getGenericSignatureIndex(Method method) {
            return IMethod.getGenericSignatureIndex(IMethod.getID(method));
        }

        public static String getGenericSignature(Method method) {
            return Reflect.getConstantString(method.getDeclaringClass(), IMethod.getGenericSignatureIndex(method));
        }

        @ImmutableLoad
        public static boolean isEmptyVoid(int n) {
            return Strings.getIStringByteAt(IMethod.getIDescriptor(n), 1) == 41 && Strings.getIStringByteAt(IMethod.getIDescriptor(n), 2) == 86;
        }

        @ImmutableLoad
        public static boolean isEmptyVoid(Method method) {
            return IMethod.isEmptyVoid(IMethod.getID(method));
        }
    }

    public static class IAccessibleObject {
        @ImmutableLoad
        public static int getID(AccessibleObject accessibleObject) {
            return Memory.getAddress(accessibleObject, Reflect.offset(4099));
        }

        @ImmutableLoad
        public static String getName(AccessibleObject accessibleObject) {
            return IAccessibleObject.getName(IAccessibleObject.getID(accessibleObject));
        }

        @ImmutableLoad
        public static String getName(int n) {
            return Strings.getString(IAccessibleObject.getIName(n), false);
        }

        @ImmutableLoad
        public static int getIName(AccessibleObject accessibleObject) {
            return IAccessibleObject.getIName(IAccessibleObject.getID(accessibleObject));
        }

        @ImmutableLoad
        public static int getIName(int n) {
            return Memory.getAddress(n, Reflect.offset(2050));
        }

        public static String getDescriptor(AccessibleObject accessibleObject) {
            return Strings.getString(IAccessibleObject.getIDescriptor(accessibleObject), true);
        }

        public static String getDescriptor(int n) {
            return Strings.getString(IAccessibleObject.getIDescriptor(n), true);
        }

        @ImmutableLoad
        public static int getIDescriptor(AccessibleObject accessibleObject) {
            return IAccessibleObject.getIDescriptor(IAccessibleObject.getID(accessibleObject));
        }

        @ImmutableLoad
        public static int getIDescriptor(int n) {
            return Memory.getAddress(n, Reflect.offset(2051));
        }

        @ImmutableLoad
        public static Class getDeclaringClass(int n) {
            return IClass.getNoCheck(IAccessibleObject.getDeclaringClassID(n));
        }

        @ImmutableLoad
        public static Class getDeclaringClass(AccessibleObject accessibleObject) {
            return IClass.getNoCheck(IAccessibleObject.getDeclaringClassID(IAccessibleObject.getID(accessibleObject)));
        }

        @ImmutableLoad
        public static int getDeclaringClassID(AccessibleObject accessibleObject) {
            return IAccessibleObject.getDeclaringClassID(IAccessibleObject.getID(accessibleObject));
        }

        @ImmutableLoad
        public static int getDeclaringClassID(int n) {
            return Memory.getAddress(n, Reflect.offset(2049));
        }
    }

    public static class IClass {
        @ImmutableLoad
        public static Class get(int n) {
            return n == 0 ? null : IClass.getNoCheck(n);
        }

        @ImmutableLoad
        public static Class get(Object object) {
            return IClassBlock.getClass(IClassBlock.getCB(object));
        }

        @ImmutableLoad
        public static Class getNoCheck(int n) {
            return (Class)Memory.getObject(n, Reflect.offset(518));
        }

        @ImmutableLoad
        public static int getID(Object object) {
            return Memory.getAddress(IClassBlock.getCB(object), Reflect.offset(256));
        }

        @ImmutableLoad
        public static int getID(Class clazz) {
            return Memory.getAddress(clazz, Reflect.offset(4097));
        }

        @ImmutableLoad
        public static String getName(Class clazz) {
            return Strings.getString(IClass.getIName(clazz), true);
        }

        @ImmutableLoad
        public static String getName(int n) {
            return Strings.getString(IClass.getIName(n), true);
        }

        @ImmutableLoad
        public static int getIName(Class clazz) {
            return IClass.getIName(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static int getIName(int n) {
            return Memory.getAddress(n, Reflect.offset(516));
        }

        @ImmutableLoad
        public static ClassLoader getClassLoader(Class clazz) {
            return IClassLoader.get(IClass.getClassLoaderID(IClass.getID(clazz)));
        }

        @ImmutableLoad
        public static ClassLoader getClassLoader(int n) {
            return IClassLoader.get(IClass.getClassLoaderID(n));
        }

        @ImmutableLoad
        public static int getClassLoaderID(Class clazz) {
            return IClass.getClassLoaderID(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static int getClassLoaderID(int n) {
            return Memory.getAddress(n, Reflect.offset(513));
        }

        @ImmutableLoad
        public static Class getSuperClass(Class clazz) {
            return IClass.get(IClass.getSuperClassID(IClass.getID(clazz)));
        }

        @ImmutableLoad
        public static Class getSuperClass(int n) {
            return IClass.get(IClass.getSuperClassID(n));
        }

        @ImmutableLoad
        public static int getSuperClassID(Class clazz) {
            return IClass.getSuperClassID(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static int getSuperClassID(int n) {
            return Memory.getAddress(n, Reflect.offset(512));
        }

        @ImmutableLoad
        public static Class getInnerType(Class clazz) {
            return IClassBlock.getClass(IClassBlock.getInnerCB(IClassBlock.getCB(clazz)));
        }

        @ImmutableLoad
        public static int getStatVars(int n) {
            return Memory.getAddress(n, Reflect.offset(556));
        }

        @ImmutableLoad
        public static int getStatVars(Class clazz) {
            return IClass.getStatVars(IClass.getID(clazz));
        }

        public static String getSourceFile(Class clazz) {
            return IClass.getSourceFile(IClass.getID(clazz));
        }

        private static native String getSourceFile(int var0);

        @ImmutableLoad
        static int getFlags(int n) {
            return Memory.getShort(n, Reflect.offset(521));
        }

        @ImmutableLoad
        public static int getJlcType(int n) {
            return Memory.getInt(n, Reflect.offset(522));
        }

        @ImmutableLoad
        public static int getInnerJlcType(int n) {
            return IClassBlock.getInnerJlcType(IClassBlock.getCB(n));
        }

        @ImmutableLoad
        public static int getAccessFlags(int n) {
            return Memory.getInt(n, Reflect.offset(519)) & 0xFFFF;
        }

        @ImmutableLoad
        public static int getAccessFlags(Class clazz) {
            return IClass.getAccessFlags(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static boolean hasClinit(int n) {
            return (IClass.getFlags(n) & 1) == 1;
        }

        @ImmutableLoad
        public static boolean hasClinit(Class clazz) {
            return IClass.hasClinit(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static boolean hasFinalizer(Class clazz) {
            return (IClass.getFlags(IClass.getID(clazz)) & 2) == 2;
        }

        @ImmutableLoad
        public static boolean isAnnotation(Class clazz) {
            return (IClass.getAccessFlags(IClass.getID(clazz)) & 0x2000) != 0;
        }

        @ImmutableLoad
        public static boolean isEnum(Class clazz) {
            return (Memory.getShort(IClass.getID(clazz), Reflect.offset(519)) & 0x4000) != 0;
        }

        @ImmutableLoad
        public static boolean isNormal(int n) {
            return IClass.getJlcType(n) == 1;
        }

        @ImmutableLoad
        public static boolean isNormal(Class clazz) {
            return IClass.isNormal(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static boolean isArray(Class clazz) {
            return IClass.getJlcType(IClass.getID(clazz)) == 3;
        }

        @ImmutableLoad
        public static boolean isInterface(Class clazz) {
            return IClass.getJlcType(IClass.getID(clazz)) == 2;
        }

        @ImmutableLoad
        public static boolean isClassLoader(Class clazz) {
            return (IClass.getFlags(IClass.getID(clazz)) & 8) == 8;
        }

        @ImmutableLoad
        public static boolean isLarge(Class clazz) {
            return (IClass.getFlags(IClass.getID(clazz)) & 0x800) == 2048;
        }

        @ImmutableLoad
        public static boolean isPrimitive(Class clazz) {
            return IClass.getJlcType(IClass.getID(clazz)) < 0;
        }

        @ImmutableLoad
        public static void ensureInitialized(Class clazz) {
            int n = IClass.getID(clazz);
            int n2 = Memory.getInt(n, Reflect.offset(520));
            if (n2 != 2) {
                IClass.runClinit(n);
            }
        }

        @ImmutableLoad
        public static boolean isInitialized(Class clazz) {
            int n = IClass.getID(clazz);
            int n2 = Memory.getInt(n, Reflect.offset(520));
            return n2 == 2;
        }

        private static native void runClinit(int var0);

        @ImmutableLoad
        public static int getEmptyConstructorID(int n) {
            int n2 = Memory.getShort(n, Reflect.offset(541));
            if (n2 > 0) {
                int n3 = Memory.getAddress(n, Reflect.offset(534));
                short s = Memory.getShort(n, Reflect.offset(539));
                n3 += s * Reflect.offset(867);
                for (int i = 0; i < n2; ++i) {
                    int n4 = IMethod.getIDescriptor(n3);
                    if (Strings.getIStringLength(n4) == 3) {
                        return n3;
                    }
                    n3 += Reflect.offset(867);
                }
            }
            return 0;
        }

        @ImmutableLoad
        public static boolean hasGenericSignature(Class clazz) {
            return IClass.hasGenericSignature(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static boolean hasGenericSignature(int n) {
            return IClass.getGenericSignatureIndex(n) != 0;
        }

        @ImmutableLoad
        public static int getGenericSignatureIndex(int n) {
            return Memory.getShort(n, Reflect.offset(557));
        }

        @ImmutableLoad
        public static int getGenericSignatureIndex(Class clazz) {
            return IClass.getGenericSignatureIndex(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static String getGenericSignature(Class clazz) {
            return Reflect.getConstantString(clazz, IClass.getGenericSignatureIndex(clazz));
        }

        public static boolean isAssignable(Class clazz, Class clazz2) {
            return IClassBlock.isAssignable(IClassBlock.getCB(clazz), IClassBlock.getCB(clazz2));
        }

        public static boolean isAssignableNormal(Class clazz, Class clazz2) {
            return IClassBlock.isAssignableNormal(IClassBlock.getCB(clazz), IClassBlock.getCB(clazz2));
        }

        public static boolean isAssignable(Object object, Object object2) {
            return IClassBlock.isAssignable(IClassBlock.getCB(object), IClassBlock.getCB(object2));
        }

        public static boolean isAssignable(Class clazz, Object object) {
            return IClassBlock.isAssignable(IClassBlock.getCB(clazz), IClassBlock.getCB(object));
        }

        public static boolean isAssignable(int n, Object object) {
            return IClassBlock.isAssignable(IClassBlock.getCB(n), IClassBlock.getCB(object));
        }

        public static boolean isInvocationAssignable(Class clazz, Object object) {
            if (clazz.isPrimitive()) {
                if (object == null) {
                    return false;
                }
                int n = IClassBlock.getCB(object);
                if (IClassBlock.getJlcType(n) == 3) {
                    return false;
                }
                int n2 = IClassBlock.getJlcType(IClassBlock.getCB(clazz));
                int n3 = IClassBlock.getInnerCB(n);
                if (n3 == 0) {
                    return false;
                }
                int n4 = IClassBlock.getJlcType(n3);
                if (n2 == n4) {
                    return true;
                }
                switch (n2) {
                    case -6: {
                        return n4 == -4;
                    }
                    case -8: {
                        return n4 == -4 || n4 == -6 || n4 == -5;
                    }
                    case -10: {
                        return n4 == -4 || n4 == -6 || n4 == -8 || n4 == -5;
                    }
                    case -7: {
                        return n4 == -4 || n4 == -6 || n4 == -8 || n4 == -10 || n4 == -5;
                    }
                    case -9: {
                        return n4 == -4 || n4 == -6 || n4 == -8 || n4 == -7 || n4 == -10 || n4 == -5;
                    }
                }
                return false;
            }
            return object == null ? true : IClass.isAssignable(clazz, object);
        }

        @ImmutableLoad
        private static int getDTable(Class clazz, int n) {
            if (IClass.isInterface(clazz) || IClass.isArray(clazz)) {
                return 0;
            }
            int n2 = IClass.getID(clazz);
            if (n2 != 0) {
                return Memory.getAddress(n2, n);
            }
            return 0;
        }

        @ImmutableLoad
        public static int getDTable(Class clazz) {
            return IClass.getDTable(clazz, Reflect.offset(558));
        }

        @ImmutableLoad
        public static int getIFDTable(Class clazz) {
            return IClass.getDTable(clazz, Reflect.offset(559));
        }

        @ImmutableLoad
        public static int getPackage(int n) {
            return Memory.getAddress(n, Reflect.offset(560));
        }

        @ImmutableLoad
        public static int getPackage(Class clazz) {
            return IClass.getPackage(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static boolean isSamePackage(int n, int n2) {
            return IClass.getPackage(n) == IClass.getPackage(n2);
        }

        @ImmutableLoad
        public static boolean isSamePackage(Class clazz, Class clazz2) {
            return IClass.getPackage(IClass.getID(clazz)) == IClass.getPackage(IClass.getID(clazz2));
        }
    }

    public static class IClassBlock {
        @ImmutableLoad
        public static native int getCB(Object var0);

        @ImmutableLoad
        public static int getCB(Class clazz) {
            return IClassBlock.getCB(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static int getCB(int n) {
            return Memory.getAddress(n, Reflect.offset(517));
        }

        @ImmutableLoad
        public static int getClassID(int n) {
            return Memory.getAddress(n, Reflect.offset(256));
        }

        @ImmutableLoad
        public static Class getClass(int n) {
            return IClass.get(IClassBlock.getClassID(n));
        }

        @ImmutableLoad
        public static int getJlcType(int n) {
            return Memory.getInt(n, Reflect.offset(266));
        }

        @ImmutableLoad
        public static int getJlcType(Object object) {
            return IClassBlock.getJlcType(IClassBlock.getCB(object));
        }

        @ImmutableLoad
        public static int getInnerCB(int n) {
            return Memory.getAddress(n, Reflect.offset(257));
        }

        @ImmutableLoad
        public static int getInnerCB(Object object) {
            return IClassBlock.getInnerCB(IClassBlock.getCB(object));
        }

        @ImmutableLoad
        public static int getInnerCB(Class clazz) {
            return IClassBlock.getInnerCB(IClassBlock.getCB(clazz));
        }

        @ImmutableLoad
        public static int getInnerJlcType(int n) {
            return IClassBlock.getJlcType(IClassBlock.getInnerCB(n));
        }

        @ImmutableLoad
        public static int getInnerJlcType(Object object) {
            return IClassBlock.getJlcType(IClassBlock.getInnerCB(object));
        }

        @ImmutableLoad
        public static boolean isArray(int n) {
            return IClassBlock.getJlcType(n) == 3;
        }

        @ImmutableLoad
        public static boolean isArray(Object object) {
            return IClassBlock.getJlcType(IClassBlock.getCB(object)) == 3;
        }

        @ImmutableLoad
        public static int getTGClassHeight(int n) {
            return Memory.getInt(n, Reflect.offset(264));
        }

        public static boolean isAssignableNormal(int n, int n2) {
            int n3;
            if (n == n2) {
                return true;
            }
            int n4 = IClassBlock.getJlcType(n2);
            if (n4 < 1) {
                return false;
            }
            int n5 = IClassBlock.getTGClassHeight(n);
            int n6 = IClassBlock.getTGClassHeight(n2);
            if (n5 == 0) {
                return true;
            }
            if (n5 > n6) {
                return false;
            }
            if (n5 < 8) {
                n3 = Memory.getAddress(n2, Reflect.offset(261) + n5 * 4);
            } else {
                int n7 = Memory.getAddress(n2, Reflect.offset(262));
                n3 = Memory.getAddress(n7, (n5 - 8) * 4);
            }
            return n3 == n;
        }

        public static boolean isAssignableArray(int n, int n2) {
            if (n == n2) {
                return true;
            }
            int n3 = IClassBlock.getJlcType(n);
            int n4 = IClassBlock.getJlcType(n2);
            while (n3 == 3 && n4 == 3) {
                n = IClassBlock.getInnerCB(n);
                n2 = IClassBlock.getInnerCB(n2);
                n3 = IClassBlock.getJlcType(n);
                n4 = IClassBlock.getJlcType(n2);
            }
            if (n3 == 3 || n4 == 3) {
                return n3 == 1 && IClassBlock.getTGClassHeight(n) == 0;
            }
            if (n3 < 1) {
                return n3 == n4;
            }
            if (n3 == 2) {
                return IClassBlock.isAssignableInterface(n, n2);
            }
            return IClassBlock.isAssignableNormal(n, n2);
        }

        public static boolean isAssignable(int n, Object object) {
            return IClassBlock.isAssignable(n, IClassBlock.getCB(object));
        }

        @NoSafePoint
        public static boolean isAssignableInterface(int n, int n2) {
            if (n == n2) {
                return true;
            }
            int n3 = IClassBlock.getJlcType(n2);
            if (n3 < 1) {
                return false;
            }
            int n4 = Memory.getInt(n, Reflect.offset(265));
            int n5 = Memory.getAddress(n2, Reflect.offset(259));
            int n6 = Memory.getAddress(n5, n4 * 4);
            return n == n6;
        }

        public static boolean isAssignable(int n, int n2) {
            if (n == n2) {
                return true;
            }
            int n3 = IClassBlock.getJlcType(n);
            int n4 = IClassBlock.getJlcType(n2);
            switch (n3) {
                case 1: {
                    return n4 >= 1 ? IClassBlock.isAssignableNormal(n, n2) : false;
                }
                case 3: {
                    return n4 >= 1 ? IClassBlock.isAssignableArray(n, n2) : false;
                }
                case 2: {
                    return n4 >= 1 ? IClassBlock.isAssignableInterface(n, n2) : false;
                }
            }
            return n3 == n4;
        }

        static void incrThinLockAcquired(int n) {
            int n2 = Reflect.offset(271);
            n = Memory.getAddress(n, n2);
            int n3 = Reflect.offset(2561);
            Memory.setInt(n, n3, Memory.getInt(n, n3) + 1);
        }

        static void incrThinLockAcquiredRecursive(int n) {
            int n2 = Reflect.offset(271);
            n = Memory.getAddress(n, n2);
            int n3 = Reflect.offset(2563);
            Memory.setInt(n, n3, Memory.getInt(n, n3) + 1);
        }

        static void incrThinLockAcquiredContended(int n) {
            int n2 = Reflect.offset(271);
            n = Memory.getAddress(n, n2);
            int n3 = Reflect.offset(2562);
            Memory.setInt(n, n3, Memory.getInt(n, n3) + 1);
        }

        static void incrFatLockAcquired(int n) {
            int n2 = Reflect.offset(271);
            n = Memory.getAddress(n, n2);
            int n3 = Reflect.offset(2564);
            Memory.setInt(n, n3, Memory.getInt(n, n3) + 1);
        }

        static void incrFatLockAcquiredContended(int n) {
            int n2 = Reflect.offset(271);
            n = Memory.getAddress(n, n2);
            int n3 = Reflect.offset(2565);
            Memory.setInt(n, n3, Memory.getInt(n, n3) + 1);
        }

        static void incrFatLockAcquiredRecursive(int n) {
            int n2 = Reflect.offset(271);
            n = Memory.getAddress(n, n2);
            int n3 = Reflect.offset(2566);
            Memory.setInt(n, n3, Memory.getInt(n, n3) + 1);
        }

        static void incrFatLockAcquiredSleep(int n) {
            int n2 = Reflect.offset(271);
            n = Memory.getAddress(n, n2);
            int n3 = Reflect.offset(2567);
            Memory.setInt(n, n3, Memory.getInt(n, n3) + 1);
        }

        static void incrFLReserveBitUncontended(int n) {
            int n2 = Reflect.offset(271);
            n = Memory.getAddress(n, n2);
            int n3 = Reflect.offset(2568);
            Memory.setInt(n, n3, Memory.getInt(n, n3) + 1);
        }

        static void incrFLReserveBitContended(int n) {
            int n2 = Reflect.offset(271);
            n = Memory.getAddress(n, n2);
            int n3 = Reflect.offset(2569);
            Memory.setInt(n, n3, Memory.getInt(n, n3) + 1);
        }
    }
}

