/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import jrockit.vm.Access;
import jrockit.vm.Memory;

public class Strings {
    private static final Access.Lang langAccess = Access.lang();
    private static final String[] toStringLookupTable = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};

    private Strings() {
    }

    public static int getIStringHashCode(int n) {
        return Memory.getInt(n, 4);
    }

    public static int getIStringLength(int n) {
        return Memory.getInt(n, 8);
    }

    public static int getIStringArrayLength(int n) {
        return Memory.getInt(n, 12);
    }

    public static int getIStringArray(int n) {
        return Memory.getAddress(n, 0);
    }

    public static int getIStringByteAt(int n, int n2) {
        return Memory.getUByte(Strings.getIStringArray(n), n2);
    }

    public static int compare(int n, int n2) {
        int n3 = Strings.getIStringArrayLength(n);
        int n4 = Strings.getIStringArrayLength(n2);
        int n5 = Math.min(n3, n4);
        int n6 = Strings.getIStringArray(n);
        int n7 = Strings.getIStringArray(n2);
        for (int i = 0; i < n5; ++i) {
            int n8;
            int n9 = Memory.getUByte(n6, i);
            if (n9 == (n8 = Memory.getUByte(n7, i))) continue;
            return n9 - n8;
        }
        return n3 - n4;
    }

    public static String getString(int n, boolean bl) {
        try {
            int n2 = Strings.getIStringLength(n);
            int n3 = Strings.getIStringArrayLength(n);
            char[] cArray = new char[n2];
            Strings.utf2unicode(Strings.getIStringArray(n), n3, cArray, 0);
            if (bl) {
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] != '/') continue;
                    cArray[i] = 46;
                }
            }
            return langAccess.stringNew(cArray, 0, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            throw arrayIndexOutOfBoundsException;
        }
    }

    public static String getString(int n) {
        return Strings.getString(n, false);
    }

    private static void utf2unicode(int n, int n2, char[] cArray, int n3) {
        int n4 = 0;
        n4 = 0;
        while (n4 < n2) {
            byte by = Memory.getByte(n, n4++);
            boolean bl = true;
            int n5 = 128;
            switch (by >> 4 & 0xF) {
                default: {
                    n5 = (char)by;
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 15: {
                    break;
                }
                case 12: 
                case 13: {
                    byte by2 = Memory.getByte(n, n4);
                    if ((by2 & 0xC0) != 128) break;
                    char c = (char)(by & 0x1F);
                    char c2 = (char)(by2 & 0x3F);
                    n5 = (char)((c << 6) + c2);
                    ++n4;
                    break;
                }
                case 14: {
                    char c2;
                    char c;
                    byte by2 = Memory.getByte(n, n4);
                    byte by3 = Memory.getByte(n, n4 + 1);
                    if ((by2 & 0xC0) != 128) break;
                    if ((by3 & 0xC0) == 128) {
                        c = (char)(by & 0xF);
                        c2 = (char)(by2 & 0x3F);
                        char c3 = (char)(by3 & 0x3F);
                        n5 = (char)(((c << 6) + c2 << 6) + c3);
                        n4 += 2;
                        break;
                    }
                    ++n4;
                }
            }
            cArray[n3++] = n5;
        }
    }

    private static String toString(Integer n) {
        int n2 = n;
        if (n2 >= 0 && n2 < toStringLookupTable.length) {
            return toStringLookupTable[n2];
        }
        return n.toString();
    }
}

