/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import jrockit.vm.Locks;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;
import jrockit.vm.VM;

public final class Threads {
    public static final int STATE_NEW = 0;
    public static final int STATE_ALIVE = 1;
    public static final int STATE_TERMINATED = 2;
    public static final int STATE_RUNNABLE = 4;
    public static final int STATE_WAITING_INDEFINITELY = 16;
    public static final int STATE_WAITING_WITH_TIMEOUT = 32;
    public static final int STATE_SLEEPING = 64;
    public static final int STATE_WAITING = 128;
    public static final int STATE_IN_OBJECT_WAIT = 256;
    public static final int STATE_PARKED = 512;
    public static final int STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    public static final int STATE_SUSPENDED = 0x100000;
    public static final int STATE_INTERRUPTED = 0x200000;
    public static final int STATE_IN_NATIVE = 0x400000;
    public static final int STATE_THIN_LOCK = 0x10000000;
    public static final int STATE_SUSPENDCRITICAL = 0x20000000;
    private static final int MAX_NO_PINNED = 3;
    private static ThreadGroup rootGroup;

    public static native int getCurrentVMThread();

    public static native int getVMThread(Thread var0);

    public static native Thread getThread(int var0);

    public static native int getThreadIndex(int var0);

    public static boolean isThreadSuspended(Thread thread) {
        int n = Threads.getVMThread(thread);
        if (n != 0) {
            int n2 = Memory.getInt(n, Reflect.offset(2306));
            return n2 > 0;
        }
        return false;
    }

    public static boolean isTimeoutExpired(int n) {
        int n2 = Memory.getInt(n, Reflect.offset(2307));
        return n2 != 0;
    }

    public static void clearTimeoutExpired(int n) {
        Memory.setInt(n, Reflect.offset(2307), 0);
    }

    public static native int getLockState(int var0);

    public static native void setLockState(int var0, int var1);

    public static boolean changeLockState(int n, int n2, int n3) {
        int n4 = Memory.cas(n, Reflect.offset(2305), n2, n3);
        return n4 == n2;
    }

    public static native void signalWaiter(int var0);

    public static native void waitForSignal();

    public static native void waitForSignalWithTimeout(long var0);

    public static native void setCurrentWaitingObject(Thread var0, Object var1);

    public static native Thread getWaitNext(Thread var0);

    public static native void setWaitNext(Thread var0, Thread var1);

    public static native Thread getLockNext(Thread var0);

    public static native void setLockNext(Thread var0, Thread var1);

    public static native AccessControlContext getAccessControlContext(Thread var0);

    public static native void setAccessControlContext(Thread var0, AccessControlContext var1);

    public static native int getPrivilegedCallerClass(int var0);

    public static native void setPrivilegedCallerClass(int var0, int var1);

    public static native boolean isInterrupted(Thread var0, boolean var1);

    public static native void setBlockingOnObject(Thread var0, Object var1);

    public static native int getWaitingOnRawMonitor(int var0);

    public static native void setThreadStatus(Thread var0, int var1);

    public static native int getThreadStatus(Thread var0);

    public static native void shortNap(int var0);

    public static void pinObject(Object object) {
        Threads.pinObject(Threads.getCurrentVMThread(), object);
    }

    public static void pinObject(int n, Object object) {
        int n2 = Memory.getInt(n, Reflect.offset(2310));
        if (n2 >= 3) {
            throw new InternalError("pinned object overflow!");
        }
        Memory.setObject(n, Reflect.offset(2311) + n2 * 4, object);
        Memory.setInt(n, Reflect.offset(2310), n2 + 1);
    }

    public static void unpinLastObject() {
        Threads.unpinLastObject(Threads.getCurrentVMThread());
    }

    public static void unpinLastObject(int n) {
        int n2 = Memory.getInt(n, Reflect.offset(2310));
        if (n2 <= 0) {
            throw new InternalError("pinned object underflow!");
        }
        Memory.setAddress(n, Reflect.offset(2311) + --n2 * 4, 0);
        Memory.setInt(n, Reflect.offset(2310), n2);
    }

    public static native Object getBlockThreadStop(Thread var0);

    public static native void setBlockThreadStop(Thread var0, Object var1);

    public static Thread.State getEnumStateFromBitmapState(int n) {
        int n2 = n & 0x436;
        switch (n2) {
            case 2: {
                return Thread.State.TERMINATED;
            }
            case 1024: {
                return Thread.State.BLOCKED;
            }
            case 16: {
                return Thread.State.WAITING;
            }
            case 32: {
                return Thread.State.TIMED_WAITING;
            }
            case 4: {
                return Thread.State.RUNNABLE;
            }
        }
        return Thread.State.NEW;
    }

    private static native int getThreadSnapShot0(Thread[] var0, int var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readMonitor(ThreadDumpCallback threadDumpCallback, Memory.DumpReader dumpReader, int n) {
        int n2 = dumpReader.readAddress();
        if (n2 != 0) {
            try {
                Object object = Memory.getObject(n2);
                int n3 = dumpReader.readInt();
                long l = dumpReader.readLong();
                threadDumpCallback.addMonitor(object, n3, l, n);
            }
            finally {
                Memory.releaseGlobalRef(n2);
                return true;
            }
        }
        return false;
    }

    public static void dumpThreads(ThreadDumpCallback threadDumpCallback, Thread[] threadArray, boolean bl) {
        Threads.dumpThreads(threadDumpCallback, threadArray, Integer.MAX_VALUE, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpThreads(ThreadDumpCallback threadDumpCallback, Thread[] threadArray, int n, boolean bl) {
        block10: {
            int n2 = 0;
            try {
                long l;
                n2 = Threads.getThreadSnapShot0(threadArray, n, bl);
                if (n2 == 0) break block10;
                Memory.DumpReader dumpReader = new Memory.DumpReader(n2);
                while ((l = dumpReader.readLong()) != 0L) {
                    String string;
                    int n3 = dumpReader.readInt();
                    int n4 = dumpReader.readInt();
                    long l2 = dumpReader.readLong();
                    int n5 = dumpReader.readInt();
                    long l3 = dumpReader.readLong();
                    long l4 = dumpReader.readLong();
                    long l5 = dumpReader.readLong();
                    long l6 = dumpReader.readLong();
                    String string2 = dumpReader.readJString();
                    if (string2 == null) {
                        string2 = "<no name>";
                    }
                    if (VM.threadContentionMonitoringIsSupported && !Locks.threadContentionMonitoringIsEnabled) {
                        l4 = -1L;
                        l6 = -1L;
                    }
                    threadDumpCallback.beginThread(string2, l, n3, n4, l2, n5, l3, l4, l5, l6);
                    Threads.readMonitor(threadDumpCallback, dumpReader, 1);
                    Threads.readMonitor(threadDumpCallback, dumpReader, 0);
                    while ((string = dumpReader.readIString(true)) != null && string.length() != 0) {
                        String string3 = dumpReader.readIString(false);
                        String string4 = dumpReader.readIString(true);
                        String string5 = dumpReader.readIString(false);
                        short s = dumpReader.readShort();
                        int n6 = dumpReader.readInt();
                        threadDumpCallback.beginStackFrame(string, string3, string4, string5, s, n6);
                        do {
                        } while (Threads.readMonitor(threadDumpCallback, dumpReader, 2));
                        threadDumpCallback.endStackFrame();
                    }
                    threadDumpCallback.endThread();
                }
            }
            finally {
                if (n2 != 0) {
                    Memory.freeMemory(n2);
                }
            }
        }
    }

    public static StackTraceElement[][] dumpThreads(Thread[] threadArray) {
        final StackTraceElement[][] stackTraceElementArray = new StackTraceElement[threadArray.length][];
        StackTraceElementCallback stackTraceElementCallback = new StackTraceElementCallback(){
            private int index = 0;

            public void endThread() {
                stackTraceElementArray[this.index++] = this.getCurrentTrace();
            }
        };
        Threads.dumpThreads(stackTraceElementCallback, threadArray, false);
        return stackTraceElementArray;
    }

    private static ThreadGroup getRootGroup() {
        if (rootGroup == null) {
            rootGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup;
                    ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
                    while ((threadGroup = threadGroup2.getParent()) != null) {
                        threadGroup2 = threadGroup;
                    }
                    return threadGroup2;
                }
            });
        }
        return rootGroup;
    }

    public static native Thread[] getThreads();

    public static native int getThreadCount();

    public static native int getDaemonThreadCount();

    public static native void resetPeakThreadCount();

    public static native Thread[] getThreads(String var0);

    public static native Thread getThreadFromId(long var0);

    public static native Thread[] getThreadsFromIds(long[] var0);

    public static native long getThreadCpuTime(long var0);

    public static native long getThreadCpuTime(Thread var0);

    public static native long getThreadUserCpuTime(long var0);

    public static native long getThreadUserCpuTime(Thread var0);

    public static boolean isThreadCpuTimeSupported() {
        return true;
    }

    public static boolean isThreadContentionMonitoringSupported() {
        return VM.threadContentionMonitoringIsSupported;
    }

    public static boolean isThreadContentionMonitoringEnabled() {
        return Locks.threadContentionMonitoringIsEnabled;
    }

    public static void setThreadContentionMonitoringEnabled(boolean bl) {
        Locks.threadContentionMonitoringIsEnabled = bl;
        if (bl) {
            Threads.resetContentionMonitoring();
        }
    }

    private static native void resetContentionMonitoring();

    public static native long getMonitorBlockedCount(int var0);

    public static native void setMonitorBlockedCount(int var0, long var1);

    public static native long getMonitorBlockedTime(int var0);

    public static native void setMonitorBlockedTime(int var0, long var1);

    public static native long getMonitorWaitedCount(int var0);

    public static native void setMonitorWaitedCount(int var0, long var1);

    public static native long getMonitorWaitedTime(int var0);

    public static native void setMonitorWaitedTime(int var0, long var1);

    public static void incrementMonitorBlockedCount(int n) {
        Threads.setMonitorBlockedCount(n, Threads.getMonitorBlockedCount(n) + 1L);
    }

    public static void incrementMonitorBlockedTime(int n, long l) {
        Threads.setMonitorBlockedTime(n, Threads.getMonitorBlockedTime(n) + l);
    }

    public static void incrementMonitorWaitedCount(int n) {
        Threads.setMonitorWaitedCount(n, Threads.getMonitorWaitedCount(n) + 1L);
    }

    public static void incrementMonitorWaitedTime(int n, long l) {
        Threads.setMonitorWaitedTime(n, Threads.getMonitorWaitedTime(n) + l);
    }

    public static native long[] getDeadlockedThreadIds();

    public static abstract class StackTraceElementCallback
    implements ThreadDumpCallback {
        private ArrayList<StackTraceElement> trace = new ArrayList();

        public StackTraceElement[] getCurrentTrace() {
            return this.trace.toArray(new StackTraceElement[this.trace.size()]);
        }

        public void beginThread(String string, long l, int n, int n2, long l2, int n3, long l3, long l4, long l5, long l6) {
            this.trace.clear();
        }

        public void beginStackFrame(String string, String string2, String string3, String string4, int n, int n2) {
            this.trace.add(new StackTraceElement(string, string2, string4, n));
        }

        public void addMonitor(Object object, int n, long l, int n2) {
        }

        public void endStackFrame() {
        }
    }

    public static interface ThreadDumpCallback {
        public static final int MONITOR_WAITING_ON = 0;
        public static final int MONITOR_BLOCKED_ON = 1;
        public static final int MONITOR_STACKFRAME = 2;

        public void beginThread(String var1, long var2, int var4, int var5, long var6, int var8, long var9, long var11, long var13, long var15);

        public void beginStackFrame(String var1, String var2, String var3, String var4, int var5, int var6);

        public void addMonitor(Object var1, int var2, long var3, int var5);

        public void endStackFrame();

        public void endThread();
    }
}

