/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import jrockit.management.GarbageCollectionStrategy;
import jrockit.management.GarbageCollectionStrategyCompositeData;
import jrockit.management.MethodIdentifier;
import jrockit.management.MethodIdentifierCompositeData;
import sun.management.MemoryNotifInfoCompositeData;
import sun.management.MemoryUsageCompositeData;
import sun.management.ThreadInfoCompositeData;
import sun.management.Util;

public abstract class MappedMXBeanType {
    private static final WeakHashMap<Type, MappedMXBeanType> convertedTypes;
    boolean isBasicType = false;
    OpenType openType = inProgress;
    Class mappedTypeClass;
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String[] mapIndexNames;
    private static final String[] mapItemNames;
    private static final Class COMPOSITE_DATA_CLASS;
    private static final OpenType inProgress;
    private static final OpenType[] simpleTypes;

    static synchronized MappedMXBeanType newMappedType(Type type) throws OpenDataException {
        ParameterizedType parameterizedType;
        Type type2;
        MappedMXBeanType mappedMXBeanType = null;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            mappedMXBeanType = clazz.isEnum() ? new EnumMXBeanType(clazz) : (clazz.isArray() ? new ArrayMXBeanType(clazz) : new CompositeDataMXBeanType(clazz));
        } else if (type instanceof ParameterizedType && (type2 = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class clazz = (Class)type2;
            if (clazz == List.class) {
                mappedMXBeanType = new ListMXBeanType(parameterizedType);
            } else if (clazz == Map.class) {
                mappedMXBeanType = new MapMXBeanType(parameterizedType);
            }
        }
        if (mappedMXBeanType == null) {
            throw new OpenDataException(type + " is not a supported MXBean type.");
        }
        convertedTypes.put(type, mappedMXBeanType);
        return mappedMXBeanType;
    }

    static synchronized MappedMXBeanType newBasicType(Class clazz, OpenType openType) throws OpenDataException {
        BasicMXBeanType basicMXBeanType = new BasicMXBeanType(clazz, openType);
        convertedTypes.put(clazz, basicMXBeanType);
        return basicMXBeanType;
    }

    static synchronized MappedMXBeanType getMappedType(Type type) throws OpenDataException {
        MappedMXBeanType mappedMXBeanType = convertedTypes.get(type);
        if (mappedMXBeanType == null) {
            mappedMXBeanType = MappedMXBeanType.newMappedType(type);
        }
        if (mappedMXBeanType.getOpenType() instanceof InProgress) {
            throw new OpenDataException("Recursive data structure");
        }
        return mappedMXBeanType;
    }

    public static synchronized OpenType toOpenType(Type type) throws OpenDataException {
        MappedMXBeanType mappedMXBeanType = MappedMXBeanType.getMappedType(type);
        return mappedMXBeanType.getOpenType();
    }

    public static Object toJavaTypeData(Object object, Type type) throws OpenDataException, InvalidObjectException {
        if (object == null) {
            return null;
        }
        MappedMXBeanType mappedMXBeanType = MappedMXBeanType.getMappedType(type);
        return mappedMXBeanType.toJavaTypeData(object);
    }

    public static Object toOpenTypeData(Object object, Type type) throws OpenDataException {
        if (object == null) {
            return null;
        }
        MappedMXBeanType mappedMXBeanType = MappedMXBeanType.getMappedType(type);
        return mappedMXBeanType.toOpenTypeData(object);
    }

    OpenType getOpenType() {
        return this.openType;
    }

    boolean isBasicType() {
        return this.isBasicType;
    }

    String getTypeName() {
        return this.getMappedTypeClass().getName();
    }

    Class getMappedTypeClass() {
        return this.mappedTypeClass;
    }

    abstract Type getJavaType();

    abstract String getName();

    abstract Object toOpenTypeData(Object var1) throws OpenDataException;

    abstract Object toJavaTypeData(Object var1) throws OpenDataException, InvalidObjectException;

    private static String decapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    static {
        InProgress inProgress;
        convertedTypes = new WeakHashMap();
        mapIndexNames = new String[]{KEY};
        mapItemNames = new String[]{KEY, VALUE};
        COMPOSITE_DATA_CLASS = CompositeData.class;
        try {
            inProgress = new InProgress();
        }
        catch (OpenDataException openDataException) {
            throw Util.newAssertionError((Exception)openDataException);
        }
        MappedMXBeanType.inProgress = inProgress;
        simpleTypes = new OpenType[]{SimpleType.BIGDECIMAL, SimpleType.BIGINTEGER, SimpleType.BOOLEAN, SimpleType.BYTE, SimpleType.CHARACTER, SimpleType.DATE, SimpleType.DOUBLE, SimpleType.FLOAT, SimpleType.INTEGER, SimpleType.LONG, SimpleType.OBJECTNAME, SimpleType.SHORT, SimpleType.STRING, SimpleType.VOID};
        try {
            for (int i = 0; i < simpleTypes.length; ++i) {
                Class<?> clazz;
                OpenType openType = simpleTypes[i];
                try {
                    clazz = Class.forName(openType.getClassName(), false, String.class.getClassLoader());
                    MappedMXBeanType.newBasicType(clazz, openType);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw Util.newAssertionError((Exception)classNotFoundException);
                }
                catch (OpenDataException openDataException) {
                    throw Util.newAssertionError((Exception)openDataException);
                }
                if (!clazz.getName().startsWith("java.lang.")) continue;
                try {
                    Field field = clazz.getField("TYPE");
                    Class clazz2 = (Class)field.get(null);
                    MappedMXBeanType.newBasicType(clazz2, openType);
                    continue;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw Util.newAssertionError((Exception)illegalAccessException);
                }
            }
        }
        catch (OpenDataException openDataException) {
            throw Util.newAssertionError((Exception)openDataException);
        }
    }

    private static class InProgress
    extends OpenType {
        private static final String description = "Marker to detect recursive type use -- internal use only!";

        InProgress() throws OpenDataException {
            super("java.lang.String", "java.lang.String", description);
        }

        public String toString() {
            return description;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }

        public boolean isValue(Object object) {
            return false;
        }
    }

    static class CompositeDataMXBeanType
    extends MappedMXBeanType {
        final Class javaClass;
        final boolean isCompositeData;
        Method fromMethod = null;

        CompositeDataMXBeanType(Class clazz) throws OpenDataException {
            Serializable serializable;
            this.javaClass = clazz;
            this.mappedTypeClass = COMPOSITE_DATA_CLASS;
            try {
                this.fromMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        return CompositeDataMXBeanType.this.javaClass.getMethod("from", COMPOSITE_DATA_CLASS);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                serializable = new OpenDataException("from(CompositeData) method doesn't exist in " + clazz.getName());
            }
            if (COMPOSITE_DATA_CLASS.isAssignableFrom(clazz)) {
                this.isCompositeData = true;
                this.openType = null;
            } else {
                this.isCompositeData = false;
                Method[] methodArray = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return CompositeDataMXBeanType.this.javaClass.getMethods();
                    }
                });
                serializable = new ArrayList();
                ArrayList<OpenType> arrayList = new ArrayList<OpenType>();
                for (int i = 0; i < methodArray.length; ++i) {
                    String string;
                    Method method = methodArray[i];
                    String string2 = method.getName();
                    Type type = method.getGenericReturnType();
                    if (string2.startsWith("get")) {
                        string = string2.substring(3);
                    } else {
                        if (!string2.startsWith("is") || !(type instanceof Class) || (Class)type != Boolean.TYPE) continue;
                        string = string2.substring(2);
                    }
                    if (string.equals("") || method.getParameterTypes().length > 0 || type == Void.TYPE || string.equals("Class") || string.equals("DeclaringClass")) continue;
                    serializable.add(MappedMXBeanType.decapitalize(string));
                    arrayList.add(CompositeDataMXBeanType.toOpenType(type));
                }
                String[] stringArray = serializable.toArray(new String[0]);
                this.openType = new CompositeType(clazz.getName(), clazz.getName(), stringArray, stringArray, arrayList.toArray(new OpenType[0]));
            }
        }

        Type getJavaType() {
            return this.javaClass;
        }

        String getName() {
            return this.javaClass.getName();
        }

        Object toOpenTypeData(Object object) throws OpenDataException {
            if (object instanceof MemoryUsage) {
                return MemoryUsageCompositeData.toCompositeData((MemoryUsage)object);
            }
            if (object instanceof ThreadInfo) {
                return ThreadInfoCompositeData.toCompositeData((ThreadInfo)object);
            }
            if (object instanceof MemoryNotificationInfo) {
                return MemoryNotifInfoCompositeData.toCompositeData((MemoryNotificationInfo)object);
            }
            if (object instanceof MethodIdentifier) {
                return MethodIdentifierCompositeData.toCompositeData((MethodIdentifier)object);
            }
            if (object instanceof GarbageCollectionStrategy) {
                return GarbageCollectionStrategyCompositeData.toCompositeData((GarbageCollectionStrategy)object);
            }
            if (this.isCompositeData) {
                CompositeData compositeData = (CompositeData)object;
                CompositeType compositeType = compositeData.getCompositeType();
                String[] stringArray = compositeType.keySet().toArray(new String[0]);
                Object[] objectArray = compositeData.getAll(stringArray);
                return new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            throw new OpenDataException(this.javaClass.getName() + " is not supported for platform MXBeans");
        }

        Object toJavaTypeData(Object object) throws OpenDataException, InvalidObjectException {
            try {
                return this.fromMethod.invoke(null, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw Util.newAssertionError((Exception)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                OpenDataException openDataException = new OpenDataException("Failed to invoke " + this.fromMethod.getName() + " to convert CompositeData " + " to " + this.javaClass.getName());
                openDataException.initCause(invocationTargetException);
                throw openDataException;
            }
        }
    }

    static class MapMXBeanType
    extends MappedMXBeanType {
        final ParameterizedType javaType;
        final MappedMXBeanType keyType;
        final MappedMXBeanType valueType;
        final String typeName;

        MapMXBeanType(ParameterizedType parameterizedType) throws OpenDataException {
            this.javaType = parameterizedType;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            assert (typeArray.length == 2);
            this.keyType = MapMXBeanType.getMappedType(typeArray[0]);
            this.valueType = MapMXBeanType.getMappedType(typeArray[1]);
            this.typeName = "Map<" + this.keyType.getName() + "," + this.valueType.getName() + ">";
            OpenType[] openTypeArray = new OpenType[]{this.keyType.getOpenType(), this.valueType.getOpenType()};
            CompositeType compositeType = new CompositeType(this.typeName, this.typeName, mapItemNames, mapItemNames, openTypeArray);
            this.openType = new TabularType(this.typeName, this.typeName, compositeType, mapIndexNames);
            this.mappedTypeClass = TabularData.class;
        }

        Type getJavaType() {
            return this.javaType;
        }

        String getName() {
            return this.typeName;
        }

        Object toOpenTypeData(Object object) throws OpenDataException {
            Map map = (Map)object;
            TabularType tabularType = (TabularType)this.openType;
            TabularDataSupport tabularDataSupport = new TabularDataSupport(tabularType);
            CompositeType compositeType = tabularType.getRowType();
            for (Map.Entry entry : map.entrySet()) {
                Object object2 = this.keyType.toOpenTypeData(entry.getKey());
                Object object3 = this.valueType.toOpenTypeData(entry.getValue());
                CompositeDataSupport compositeDataSupport = new CompositeDataSupport(compositeType, mapItemNames, new Object[]{object2, object3});
                tabularDataSupport.put(compositeDataSupport);
            }
            return tabularDataSupport;
        }

        Object toJavaTypeData(Object object) throws OpenDataException, InvalidObjectException {
            TabularData tabularData = (TabularData)object;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (CompositeData compositeData : tabularData.values()) {
                Object object2 = this.keyType.toJavaTypeData(compositeData.get(MappedMXBeanType.KEY));
                Object object3 = this.valueType.toJavaTypeData(compositeData.get(MappedMXBeanType.VALUE));
                hashMap.put(object2, object3);
            }
            return hashMap;
        }
    }

    static class ListMXBeanType
    extends MappedMXBeanType {
        final ParameterizedType javaType;
        final MappedMXBeanType paramType;
        final String typeName;

        ListMXBeanType(ParameterizedType parameterizedType) throws OpenDataException {
            this.javaType = parameterizedType;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            assert (typeArray.length == 1);
            if (!(typeArray[0] instanceof Class)) {
                throw new OpenDataException("Element Type for " + parameterizedType + " not supported");
            }
            Class clazz = (Class)typeArray[0];
            if (clazz.isArray()) {
                throw new OpenDataException("Element Type for " + parameterizedType + " not supported");
            }
            this.paramType = ListMXBeanType.getMappedType(clazz);
            this.typeName = "List<" + this.paramType.getName() + ">";
            try {
                this.mappedTypeClass = Class.forName("[L" + this.paramType.getTypeName() + ";");
            }
            catch (ClassNotFoundException classNotFoundException) {
                OpenDataException openDataException = new OpenDataException("Array class not found");
                openDataException.initCause(classNotFoundException);
                throw openDataException;
            }
            this.openType = new ArrayType(1, this.paramType.getOpenType());
        }

        Type getJavaType() {
            return this.javaType;
        }

        String getName() {
            return this.typeName;
        }

        Object toOpenTypeData(Object object) throws OpenDataException {
            List list = (List)object;
            Object[] objectArray = (Object[])Array.newInstance(this.paramType.getMappedTypeClass(), list.size());
            int n = 0;
            for (Object e : list) {
                objectArray[n++] = this.paramType.toOpenTypeData(e);
            }
            return objectArray;
        }

        Object toJavaTypeData(Object object) throws OpenDataException, InvalidObjectException {
            Object[] objectArray = (Object[])object;
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (Object object2 : objectArray) {
                arrayList.add(this.paramType.toJavaTypeData(object2));
            }
            return arrayList;
        }
    }

    static class ArrayMXBeanType
    extends MappedMXBeanType {
        final Class arrayClass;
        final MappedMXBeanType componentType;
        final MappedMXBeanType baseElementType;

        ArrayMXBeanType(Class clazz) throws OpenDataException {
            this.arrayClass = clazz;
            this.componentType = ArrayMXBeanType.getMappedType(clazz.getComponentType());
            StringBuilder stringBuilder = new StringBuilder();
            Class<?> clazz2 = clazz;
            int n = 0;
            while (clazz2.isArray()) {
                stringBuilder.append('[');
                clazz2 = clazz2.getComponentType();
                ++n;
            }
            this.baseElementType = ArrayMXBeanType.getMappedType(clazz2);
            if (clazz2.isPrimitive()) {
                stringBuilder = new StringBuilder(clazz.getName());
            } else {
                stringBuilder.append("L" + this.baseElementType.getTypeName() + ";");
            }
            try {
                this.mappedTypeClass = Class.forName(stringBuilder.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                OpenDataException openDataException = new OpenDataException("Cannot obtain array class");
                openDataException.initCause(classNotFoundException);
                throw openDataException;
            }
            try {
                this.openType = new ArrayType(n, this.baseElementType.getOpenType());
            }
            catch (Throwable throwable) {
                System.err.println("Failed creating array type: mappedTypeClass= " + this.mappedTypeClass + " dim=" + n + " baseElement= " + this.baseElementType.getName() + " baseElementType= " + this.baseElementType.getTypeName() + " openType= " + this.baseElementType.getOpenType());
                throw (OpenDataException)throwable;
            }
        }

        Type getJavaType() {
            return this.arrayClass;
        }

        String getName() {
            return this.arrayClass.getName();
        }

        Object toOpenTypeData(Object object) throws OpenDataException {
            if (this.baseElementType.isBasicType()) {
                return object;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])Array.newInstance(this.componentType.getMappedTypeClass(), objectArray.length);
            int n = 0;
            for (Object object2 : objectArray) {
                objectArray2[n] = object2 == null ? null : this.componentType.toOpenTypeData(object2);
                ++n;
            }
            return objectArray2;
        }

        Object toJavaTypeData(Object object) throws OpenDataException, InvalidObjectException {
            if (this.baseElementType.isBasicType()) {
                return object;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])Array.newInstance((Class)this.componentType.getJavaType(), objectArray.length);
            int n = 0;
            for (Object object2 : objectArray) {
                objectArray2[n] = object2 == null ? null : this.componentType.toJavaTypeData(object2);
                ++n;
            }
            return objectArray2;
        }
    }

    static class EnumMXBeanType
    extends MappedMXBeanType {
        final Class enumClass;

        EnumMXBeanType(Class clazz) {
            this.enumClass = clazz;
            this.openType = SimpleType.STRING;
            this.mappedTypeClass = String.class;
        }

        Type getJavaType() {
            return this.enumClass;
        }

        String getName() {
            return this.enumClass.getName();
        }

        Object toOpenTypeData(Object object) throws OpenDataException {
            return ((Enum)object).name();
        }

        Object toJavaTypeData(Object object) throws OpenDataException, InvalidObjectException {
            try {
                return Enum.valueOf(this.enumClass, (String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                InvalidObjectException invalidObjectException = new InvalidObjectException("Enum constant named " + (String)object + " is missing");
                invalidObjectException.initCause(illegalArgumentException);
                throw invalidObjectException;
            }
        }
    }

    static class BasicMXBeanType
    extends MappedMXBeanType {
        final Class basicType;

        BasicMXBeanType(Class clazz, OpenType openType) {
            this.basicType = clazz;
            this.openType = openType;
            this.mappedTypeClass = clazz;
            this.isBasicType = true;
        }

        Type getJavaType() {
            return this.basicType;
        }

        String getName() {
            return this.basicType.getName();
        }

        Object toOpenTypeData(Object object) throws OpenDataException {
            return object;
        }

        Object toJavaTypeData(Object object) throws OpenDataException, InvalidObjectException {
            return object;
        }
    }
}

