/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

class MuxingAttributeSet
implements AttributeSet,
Serializable {
    private AttributeSet[] attrs;

    public MuxingAttributeSet(AttributeSet[] attributeSetArray) {
        this.attrs = attributeSetArray;
    }

    protected MuxingAttributeSet() {
    }

    protected synchronized void setAttributes(AttributeSet[] attributeSetArray) {
        this.attrs = attributeSetArray;
    }

    protected synchronized AttributeSet[] getAttributes() {
        return this.attrs;
    }

    protected synchronized void insertAttributeSetAt(AttributeSet attributeSet, int n2) {
        int n3 = this.attrs.length;
        AttributeSet[] attributeSetArray = new AttributeSet[n3 + 1];
        if (n2 < n3) {
            if (n2 > 0) {
                System.arraycopy(this.attrs, 0, attributeSetArray, 0, n2);
                System.arraycopy(this.attrs, n2, attributeSetArray, n2 + 1, n3 - n2);
            } else {
                System.arraycopy(this.attrs, 0, attributeSetArray, 1, n3);
            }
        } else {
            System.arraycopy(this.attrs, 0, attributeSetArray, 0, n3);
        }
        attributeSetArray[n2] = attributeSet;
        this.attrs = attributeSetArray;
    }

    protected synchronized void removeAttributeSetAt(int n2) {
        int n3 = this.attrs.length;
        AttributeSet[] attributeSetArray = new AttributeSet[n3 - 1];
        if (n3 > 0) {
            if (n2 == 0) {
                System.arraycopy(this.attrs, 1, attributeSetArray, 0, n3 - 1);
            } else if (n2 < n3 - 1) {
                System.arraycopy(this.attrs, 0, attributeSetArray, 0, n2);
                System.arraycopy(this.attrs, n2 + 1, attributeSetArray, n2, n3 - n2 - 1);
            } else {
                System.arraycopy(this.attrs, 0, attributeSetArray, 0, n3 - 1);
            }
        }
        this.attrs = attributeSetArray;
    }

    public int getAttributeCount() {
        AttributeSet[] attributeSetArray = this.getAttributes();
        int n2 = 0;
        for (int i2 = 0; i2 < attributeSetArray.length; ++i2) {
            n2 += attributeSetArray[i2].getAttributeCount();
        }
        return n2;
    }

    public boolean isDefined(Object object) {
        AttributeSet[] attributeSetArray = this.getAttributes();
        for (int i2 = 0; i2 < attributeSetArray.length; ++i2) {
            if (!attributeSetArray[i2].isDefined(object)) continue;
            return true;
        }
        return false;
    }

    public boolean isEqual(AttributeSet attributeSet) {
        return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
    }

    public AttributeSet copyAttributes() {
        AttributeSet[] attributeSetArray = this.getAttributes();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        boolean bl2 = false;
        for (int i2 = attributeSetArray.length - 1; i2 >= 0; --i2) {
            simpleAttributeSet.addAttributes(attributeSetArray[i2]);
        }
        return simpleAttributeSet;
    }

    public Object getAttribute(Object object) {
        AttributeSet[] attributeSetArray = this.getAttributes();
        int n2 = attributeSetArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = attributeSetArray[i2].getAttribute(object);
            if (object2 == null) continue;
            return object2;
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        return new MuxingAttributeNameEnumeration();
    }

    public boolean containsAttribute(Object object, Object object2) {
        return object2.equals(this.getAttribute(object));
    }

    public boolean containsAttributes(AttributeSet attributeSet) {
        boolean bl2 = true;
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (bl2 && enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            bl2 = attributeSet.getAttribute(obj).equals(this.getAttribute(obj));
        }
        return bl2;
    }

    public AttributeSet getResolveParent() {
        return null;
    }

    private class MuxingAttributeNameEnumeration
    implements Enumeration {
        private int attrIndex;
        private Enumeration currentEnum;

        MuxingAttributeNameEnumeration() {
            this.updateEnum();
        }

        public boolean hasMoreElements() {
            if (this.currentEnum == null) {
                return false;
            }
            return this.currentEnum.hasMoreElements();
        }

        public Object nextElement() {
            if (this.currentEnum == null) {
                throw new NoSuchElementException("No more names");
            }
            Object e2 = this.currentEnum.nextElement();
            if (!this.currentEnum.hasMoreElements()) {
                this.updateEnum();
            }
            return e2;
        }

        void updateEnum() {
            AttributeSet[] attributeSetArray = MuxingAttributeSet.this.getAttributes();
            this.currentEnum = null;
            while (this.currentEnum == null && this.attrIndex < attributeSetArray.length) {
                this.currentEnum = attributeSetArray[this.attrIndex++].getAttributeNames();
                if (this.currentEnum.hasMoreElements()) continue;
                this.currentEnum = null;
            }
        }
    }
}

