/*
 * Decompiled with CFR 0.152.
 */
package sun.security.timestamp;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Extension;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class TSRequest {
    private static final ObjectIdentifier SHA1_OID;
    private static final ObjectIdentifier MD5_OID;
    private int version = 1;
    private ObjectIdentifier hashAlgorithmId = null;
    private byte[] hashValue;
    private String policyId = null;
    private BigInteger nonce = null;
    private boolean returnCertificate = false;
    private X509Extension[] extensions = null;

    public TSRequest(byte[] byArray, String string) {
        if ("MD5".equalsIgnoreCase(string)) {
            this.hashAlgorithmId = MD5_OID;
            assert (byArray.length == 16);
        } else if ("SHA-1".equalsIgnoreCase(string) || "SHA".equalsIgnoreCase(string) || "SHA1".equalsIgnoreCase(string)) {
            this.hashAlgorithmId = SHA1_OID;
            assert (byArray.length == 20);
        }
        this.hashValue = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.hashValue, 0, byArray.length);
    }

    public void setVersion(int n2) {
        this.version = n2;
    }

    public void setPolicyId(String string) {
        this.policyId = string;
    }

    public void setNonce(BigInteger bigInteger) {
        this.nonce = bigInteger;
    }

    public void requestCertificate(boolean bl2) {
        this.returnCertificate = bl2;
    }

    public void setExtensions(X509Extension[] x509ExtensionArray) {
        this.extensions = x509ExtensionArray;
    }

    public byte[] encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putOID(this.hashAlgorithmId);
        derOutputStream2.write((byte)48, derOutputStream3);
        derOutputStream2.putOctetString(this.hashValue);
        derOutputStream.write((byte)48, derOutputStream2);
        if (this.policyId != null) {
            derOutputStream.putOID(new ObjectIdentifier(this.policyId));
        }
        if (this.nonce != null) {
            derOutputStream.putInteger(this.nonce);
        }
        if (this.returnCertificate) {
            derOutputStream.putBoolean(true);
        }
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.write((byte)48, derOutputStream);
        return derOutputStream4.toByteArray();
    }

    static {
        ObjectIdentifier objectIdentifier = null;
        ObjectIdentifier objectIdentifier2 = null;
        try {
            objectIdentifier = new ObjectIdentifier("1.3.14.3.2.26");
            objectIdentifier2 = new ObjectIdentifier("1.2.840.113549.2.5");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SHA1_OID = objectIdentifier;
        MD5_OID = objectIdentifier2;
    }
}

