/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo;

import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.DataObjects;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.conf.TransactionDemarcation;
import org.exolab.castor.jdo.conf.TransactionManager;
import org.exolab.castor.jdo.engine.DatabaseImpl;
import org.exolab.castor.jdo.engine.DatabaseRegistry;
import org.exolab.castor.jdo.engine.JDOConfLoader;
import org.exolab.castor.jdo.engine.TxDatabaseMap;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerAcquireException;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerFactory;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerFactoryRegistry;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.OutputLogInterceptor;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.InstanceFactory;
import org.exolab.castor.persist.spi.LogInterceptor;
import org.exolab.castor.util.Messages;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JDO2
implements DataObjects,
Referenceable,
ObjectFactory,
Serializable {
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$jdo$JDO2 == null ? (class$org$exolab$castor$jdo$JDO2 = JDO2.class$("org.exolab.castor.jdo.JDO2")) : class$org$exolab$castor$jdo$JDO2);
    private static Map _jdoInstances = new HashMap();
    private InputSource _jdoConfURI;
    private LogInterceptor _logInterceptor;
    private CallbackInterceptor _callbackInterceptor;
    private InstanceFactory _instanceFactory;
    public static final int DEFAULT_LOCK_TIMEOUT = 10;
    private int _lockTimeout = 10;
    private String _databaseName;
    public static final String DEFAULT_DESCRIPTION = "Castor JDO";
    private String _description = "Castor JDO";
    private TransactionManagerFactory _transactionManagerFactory = null;
    private javax.transaction.TransactionManager _transactionManager = null;
    private static ClassLoader _classLoader;
    private static EntityResolver _entityResolver;
    private static InputSource _source;
    private TxDatabaseMap _txDbPool;
    private boolean _autoStore = false;
    static /* synthetic */ Class class$org$exolab$castor$jdo$JDO2;

    private JDO2() {
    }

    private JDO2(String name) {
        this._databaseName = name;
    }

    public static JDO2 createInstance(String databaseName) throws MappingException {
        if (!DatabaseRegistry.hasDatabaseRegistries()) {
            throw new MappingException(Messages.message("jdo.missing.jdo.configuration"));
        }
        if (DatabaseRegistry.getDatabaseRegistry(databaseName) == null) {
            throw new MappingException(Messages.format("jdo.missing.database.configuration", databaseName));
        }
        JDO2 jdoInstance = (JDO2)_jdoInstances.get(databaseName);
        if (jdoInstance == null) {
            jdoInstance = new JDO2(databaseName);
            jdoInstance.setConfiguration(_source);
            jdoInstance.setEntityResolver(_entityResolver);
            jdoInstance.setClassLoader(_classLoader);
            _jdoInstances.put(databaseName, jdoInstance);
            _log.debug((Object)("Successfully created JDO instance: " + jdoInstance));
        }
        return jdoInstance;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this._logInterceptor = logWriter == null ? null : new OutputLogInterceptor(logWriter);
    }

    public void setLogInterceptor(LogInterceptor logInterceptor) {
        this._logInterceptor = logInterceptor;
    }

    public void setCallbackInterceptor(CallbackInterceptor callback) {
        this._callbackInterceptor = callback;
    }

    public void setInstanceFactory(InstanceFactory factory) {
        this._instanceFactory = factory;
    }

    public LogInterceptor getLogInterceptor() {
        return this._logInterceptor;
    }

    private void setClassLoader(ClassLoader classLoader) {
        _classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return _classLoader;
    }

    private void setEntityResolver(EntityResolver entityResolver) {
        _entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return _entityResolver;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new NullPointerException("DataSource: Argument 'description' is null");
        }
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    public void setLockTimeout(int seconds) {
        this._lockTimeout = seconds;
    }

    public int getLockTimeout() {
        return this._lockTimeout;
    }

    public void setConfiguration(InputSource source) {
        this._jdoConfURI = source;
    }

    public InputSource getConfiguration() {
        return this._jdoConfURI;
    }

    public void setDatabasePooling(boolean pool) {
        if (!pool) {
            if (this._txDbPool == null) {
                return;
            }
            if (this._txDbPool.isEmpty()) {
                this._txDbPool = null;
                return;
            }
            throw new IllegalStateException("JDO Pooling started. It can not be set to false");
        }
        if (this._txDbPool == null) {
            this._txDbPool = new TxDatabaseMap();
        }
    }

    public boolean getDatabasePooling() {
        return this._txDbPool != null;
    }

    public void setAutoStore(boolean autoStore) {
        this._autoStore = autoStore;
    }

    public boolean isAutoStore() {
        return this._autoStore;
    }

    public Database getDatabase() throws DatabaseNotFoundException, PersistenceException {
        block22: {
            if (this._databaseName == null) {
                throw new IllegalStateException(Messages.message("jdo.missing.database.name"));
            }
            if (DatabaseRegistry.getDatabaseRegistry(this._databaseName) == null) {
                if (this._jdoConfURI == null) {
                    throw new DatabaseNotFoundException(Messages.format("jdo.dbNoMapping", this._databaseName));
                }
                try {
                    DatabaseRegistry.loadDatabase(this._jdoConfURI, _entityResolver, _classLoader);
                }
                catch (MappingException except) {
                    throw new DatabaseNotFoundException(Messages.format("jdo.problem.loading.conf", this._jdoConfURI), except);
                }
            }
            try {
                TransactionManagerFactoryRegistry.load(this._jdoConfURI, _entityResolver);
            }
            catch (TransactionManagerAcquireException e) {
                throw new PersistenceException(Messages.message("jdo.transaction.problemToInitializeTransactionManagerFactory"), e);
            }
            if (this._transactionManagerFactory == null) {
                String transactionMode;
                block21: {
                    transactionMode = null;
                    try {
                        TransactionDemarcation demarcation = JDOConfLoader.getTransactionDemarcation(this._jdoConfURI, _entityResolver);
                        String demarcationMode = demarcation.getMode();
                        TransactionManager transactionManager = demarcation.getTransactionManager();
                        if (transactionManager != null) {
                            transactionMode = transactionManager.getName();
                            break block21;
                        }
                        if (demarcationMode.equals("local")) {
                            transactionMode = "local";
                            break block21;
                        }
                        throw new PersistenceException(Messages.message("jdo.transaction.missingTransactionManagerConfiguration"));
                    }
                    catch (MappingException e) {
                        throw new PersistenceException("jdo.transaction.noValidTransactionMode", e);
                    }
                }
                this._transactionManagerFactory = TransactionManagerFactoryRegistry.getTransactionManagerFactory(transactionMode);
                if (this._transactionManagerFactory == null) {
                    throw new DatabaseNotFoundException(Messages.format("jdo.transaction.missingTransactionManagerFactory", transactionMode));
                }
                try {
                    this._transactionManager = this._transactionManagerFactory.getTransactionManager();
                }
                catch (TransactionManagerAcquireException e) {
                    throw new DatabaseNotFoundException(Messages.format("jdo.transaction.unableToAcquireTransactionManager", this._transactionManagerFactory.getName(), e));
                }
            }
            if (this._transactionManagerFactory.getName().equals("local") && this._transactionManager != null) {
                try {
                    Transaction tx = this._transactionManager.getTransaction();
                    if (this._txDbPool != null && this._txDbPool.containsTx(tx)) {
                        return this._txDbPool.get(tx);
                    }
                    if (tx != null && tx.getStatus() == 0) {
                        DatabaseImpl dbImpl = new DatabaseImpl(this._databaseName, this._lockTimeout, this._callbackInterceptor, this._instanceFactory, tx, _classLoader, this._autoStore);
                        if (this._txDbPool != null) {
                            this._txDbPool.put(tx, dbImpl);
                        }
                        tx.registerSynchronization((Synchronization)dbImpl);
                        return dbImpl;
                    }
                }
                catch (Exception except) {
                    if (this._logInterceptor == null) break block22;
                    this._logInterceptor.exception(except);
                }
            }
        }
        return new DatabaseImpl(this._databaseName, this._lockTimeout, this._callbackInterceptor, this._instanceFactory, null, _classLoader, this._autoStore);
    }

    public static void loadConfiguration(InputSource source, EntityResolver resolver, ClassLoader loader) throws MappingException {
        DatabaseRegistry.loadDatabase(source, resolver, loader);
        _classLoader = loader;
        _entityResolver = resolver;
        _source = source;
    }

    public static void loadConfiguration(String url, ClassLoader loader) throws MappingException {
        JDO2.loadConfiguration(new InputSource(url), null, loader);
    }

    public static void loadConfiguration(String url) throws MappingException {
        JDO2.loadConfiguration(new InputSource(url), null, null);
    }

    public synchronized Reference getReference() {
        Reference ref = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        if (this._description != null) {
            ref.add(new StringRefAddr("description", this._description));
        }
        if (this._databaseName != null) {
            ref.add(new StringRefAddr("databaseName", this._databaseName));
        }
        if (this._jdoConfURI != null) {
            ref.add(new StringRefAddr("configuration", this._jdoConfURI.toString()));
        }
        ref.add(new StringRefAddr("lockTimeout", Integer.toString(this._lockTimeout)));
        return ref;
    }

    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws NamingException {
        if (refObj instanceof Reference) {
            JDO2 ds;
            Reference ref = (Reference)refObj;
            if (!ref.getClassName().equals(this.getClass().getName())) {
                throw new NamingException(Messages.format("jdo.reference.wrong.type", ref.getClassName()));
            }
            try {
                ds = (JDO2)Class.forName(ref.getClassName()).newInstance();
            }
            catch (Exception except) {
                NamingException ne = new NamingException(Messages.format("jdo.problem.loading.class", ref.getClassName()));
                ne.setRootCause(except);
                throw ne;
            }
            RefAddr addr = ref.get("description");
            if (addr != null) {
                ds._description = (String)addr.getContent();
            }
            if ((addr = ref.get("databaseName")) != null) {
                ds._databaseName = (String)addr.getContent();
            }
            if ((addr = ref.get("configuration")) != null) {
                ds._jdoConfURI = (InputSource)addr.getContent();
            }
            if ((addr = ref.get("lockTimeout")) != null) {
                ds._lockTimeout = Integer.parseInt((String)addr.getContent());
            }
            return ds;
        }
        if (refObj instanceof Remote) {
            return refObj;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

