/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.transactionmanager.spi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerAcquireException;
import org.exolab.castor.jdo.transactionmanager.spi.BaseTransactionManagerFactory;
import org.exolab.castor.util.Messages;

public class WebSphere51TransactionManagerFactory
extends BaseTransactionManagerFactory {
    private static final String FACTORY_CLASS_NAME = "com.ibm.ws.Transaction.TransactionManagerFactory";
    private static final String FACTORY_METHOD_NAME = "getTransactionManager";
    private TransactionManager _transactionManager;
    private final String _name = "websphere51";

    public TransactionManager getTransactionManager() throws TransactionManagerAcquireException {
        Class<?> webSphereTxMgrFactory = null;
        Method method = null;
        try {
            webSphereTxMgrFactory = Class.forName(FACTORY_CLASS_NAME);
            method = webSphereTxMgrFactory.getMethod(FACTORY_METHOD_NAME, null);
            this._transactionManager = (TransactionManager)method.invoke(webSphereTxMgrFactory, null);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.unableToAcquireTransactionManager", cnfe.getMessage()));
        }
        catch (IllegalAccessException iae) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.unableToAcquireTransactionManager", iae.getMessage()));
        }
        catch (InvocationTargetException ite) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.unableToAcquireTransactionManager", ite.getMessage()));
        }
        catch (NoSuchMethodException nsme) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.unableToAcquireTransactionManager", nsme.getMessage()));
        }
        return this._transactionManager;
    }

    public String getName() {
        return "websphere51";
    }
}

