/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.persist.FieldMolder;

abstract class CollectionProxy {
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$exolab$castor$persist$CollectionProxy$ColProxy;

    CollectionProxy() {
    }

    abstract Object getCollection();

    abstract void add(Object var1, Object var2);

    abstract void close();

    static CollectionProxy create(FieldMolder fm, Object object, ClassLoader cl) {
        Class cls = fm.getCollectionType();
        if (cls == (class$java$util$Vector == null ? (class$java$util$Vector = CollectionProxy.class$("java.util.Vector")) : class$java$util$Vector)) {
            return new ColProxy(fm, object, cl, new Vector());
        }
        if (cls == (class$java$util$ArrayList == null ? (class$java$util$ArrayList = CollectionProxy.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
            return new ColProxy(fm, object, cl, new ArrayList());
        }
        if (cls == (class$java$util$Collection == null ? (class$java$util$Collection = CollectionProxy.class$("java.util.Collection")) : class$java$util$Collection)) {
            return new ColProxy(fm, object, cl, new ArrayList());
        }
        if (cls == (class$java$util$Set == null ? (class$java$util$Set = CollectionProxy.class$("java.util.Set")) : class$java$util$Set)) {
            return new ColProxy(fm, object, cl, new HashSet());
        }
        if (cls == (class$java$util$HashSet == null ? (class$java$util$HashSet = CollectionProxy.class$("java.util.HashSet")) : class$java$util$HashSet)) {
            return new ColProxy(fm, object, cl, new HashSet());
        }
        if (cls == (class$java$util$Hashtable == null ? (class$java$util$Hashtable = CollectionProxy.class$("java.util.Hashtable")) : class$java$util$Hashtable)) {
            return new MapProxy(fm, object, cl, new Hashtable());
        }
        if (cls == (class$java$util$HashMap == null ? (class$java$util$HashMap = CollectionProxy.class$("java.util.HashMap")) : class$java$util$HashMap)) {
            return new MapProxy(fm, object, cl, new HashMap());
        }
        if (cls == (class$java$util$Map == null ? (class$java$util$Map = CollectionProxy.class$("java.util.Map")) : class$java$util$Map)) {
            return new MapProxy(fm, object, cl, new HashMap());
        }
        throw new IllegalArgumentException("Collection Proxy doesn't exist for this type : " + cls);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MapProxy
    extends CollectionProxy {
        private Map _map;
        private FieldMolder _fm;
        private Object _object;
        private ClassLoader _cl;

        private MapProxy(FieldMolder fm, Object object, ClassLoader cl, Map map) {
            this._cl = cl;
            this._map = map;
            this._fm = fm;
            this._object = object;
        }

        Object getCollection() {
            return this._map;
        }

        void add(Object key, Object value) {
            this._map.put(key, value);
        }

        void close() {
            if (!this._fm.isAddable()) {
                this._fm.setValue(this._object, this._map, this._cl);
            }
        }
    }

    private static class ColProxy
    extends CollectionProxy {
        private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$persist$CollectionProxy$ColProxy == null ? (class$org$exolab$castor$persist$CollectionProxy$ColProxy = CollectionProxy.class$("org.exolab.castor.persist.CollectionProxy$ColProxy")) : class$org$exolab$castor$persist$CollectionProxy$ColProxy);
        private Collection _col;
        private FieldMolder _fm;
        private Object _object;
        private ClassLoader _cl;

        private ColProxy(FieldMolder fm, Object object, ClassLoader cl, Collection col) {
            this._cl = cl;
            this._fm = fm;
            this._col = col;
            this._object = object;
        }

        Object getCollection() {
            return this._col;
        }

        void add(Object key, Object value) {
            if (!this._fm.isAddable()) {
                this._col.add(value);
            } else {
                this._fm.addValue(this._object, value, this._cl);
            }
        }

        void close() {
            if (!this._fm.isAddable()) {
                this._fm.setValue(this._object, this._col, this._cl);
            }
        }
    }
}

