/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.persist.cache.Cache;
import org.exolab.castor.persist.cache.CacheAcquireException;
import org.exolab.castor.persist.cache.CacheFactory;
import org.exolab.castor.util.LocalConfiguration;

public final class CacheRegistry {
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$persist$cache$CacheRegistry == null ? (class$org$exolab$castor$persist$cache$CacheRegistry = CacheRegistry.class$("org.exolab.castor.persist.cache.CacheRegistry")) : class$org$exolab$castor$persist$cache$CacheRegistry);
    private static final String CACHE_IMPLEMENTATION_PROPERTY = "org.exolab.castor.jdo.cacheFactories";
    private static final String DEFAULT_CACHE_TYPE = "count-limited";
    private static final int DEFAULT_CAPACITY = 30;
    private static Hashtable _cacheFactories;
    static /* synthetic */ Class class$org$exolab$castor$persist$cache$CacheRegistry;

    public static Cache getCache(String cacheType, int capacity, String className, ClassLoader classLoader) throws CacheAcquireException {
        CacheFactory cacheFactory;
        CacheRegistry.load();
        Cache cache = null;
        if (cacheType == null || cacheType == "") {
            cacheType = DEFAULT_CACHE_TYPE;
            capacity = 30;
        }
        if (capacity == 0) {
            capacity = 30;
        }
        if ((cacheFactory = (CacheFactory)_cacheFactories.get(cacheType)) != null) {
            cache = cacheFactory.getCache(classLoader);
            cache.setCacheType(cacheType);
            cache.setCapacity(capacity);
            cache.setClassName(className);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Successfully instantiated '" + cache.getCacheType() + "' cache instance [" + cache.getCapacity() + "/" + cache.getClassName() + "]"));
        }
        return cache;
    }

    public static String[] getCacheFactories() {
        CacheRegistry.load();
        String[] names = new String[_cacheFactories.size()];
        Enumeration enumeration = _cacheFactories.keys();
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)enumeration.nextElement();
        }
        return names;
    }

    public static Collection getCaches() {
        CacheRegistry.load();
        return Collections.unmodifiableCollection(_cacheFactories.keySet());
    }

    private static synchronized void load() {
        if (_cacheFactories == null) {
            CacheFactory cacheFactory = null;
            _cacheFactories = new Hashtable();
            String prop = LocalConfiguration.getInstance().getProperty(CACHE_IMPLEMENTATION_PROPERTY, "");
            StringTokenizer tokenizer = new StringTokenizer(prop, ", ");
            while (tokenizer.hasMoreTokens()) {
                prop = tokenizer.nextToken();
                try {
                    Class<?> cls = (class$org$exolab$castor$persist$cache$CacheRegistry == null ? CacheRegistry.class$("org.exolab.castor.persist.cache.CacheRegistry") : class$org$exolab$castor$persist$cache$CacheRegistry).getClassLoader().loadClass(prop);
                    cacheFactory = (CacheFactory)cls.newInstance();
                    _cacheFactories.put(cacheFactory.getName(), cacheFactory);
                }
                catch (Exception except) {
                    _log.error((Object)"Problem instantiating cache implementation.", (Throwable)except);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

