/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.base;

import com.intel.wizards.base.AbstractWizardPage;
import com.intel.wizards.base.DependentProperties;
import com.intel.wizards.base.controls.IControl;
import com.intel.wizards.dom.KeyNotFoundException;
import com.intel.wizards.listeners.ControlDependencyListener;
import com.intel.wizards.logger.WizardLogger;
import com.intel.wizards.managers.IControlManager;
import com.intel.wizards.managers.ISnapshotManager;
import com.intel.wizards.xml.Item_dependency;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractViewWizard
extends Wizard {
    protected IControlManager controlManager;
    protected ISnapshotManager snapshotManager;
    protected ArrayList<String> targ_osArrayList;
    protected ArrayList<String> chipsetArrayList;
    protected static Properties prop;
    protected static String propertyFileName;
    protected String XML_EXT = ".xml";
    protected final String SEPERATOR = "#";
    private Hashtable<String, Vector<DependentProperties>> dependentControlDetailsTable = new Hashtable();
    private Hashtable<String, Item_dependency> conditionalItemDetailsTable = new Hashtable();
    protected boolean childWizard;

    private void loadProperties() {
        try {
            URL uRL = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.intel.graphics"), (IPath)new Path("/"), null));
            propertyFileName = String.valueOf(uRL.getPath()) + "properties/props.properties";
            prop = new Properties();
            prop.load(new BufferedInputStream(new FileInputStream(propertyFileName)));
            String string = prop.getProperty("target_chipset");
            String string2 = prop.getProperty("target_os");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2] = stringTokenizer.nextToken().trim();
                ++n2;
            }
            this.targ_osArrayList = new ArrayList(Arrays.asList(stringArray));
            String[] stringArray2 = string.split(",");
            this.chipsetArrayList = new ArrayList(Arrays.asList(stringArray2));
        }
        catch (Exception exception) {
            exception.getMessage();
        }
    }

    Properties convertBundleToProperties(ResourceBundle resourceBundle) {
        Properties properties = new Properties();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            properties.put(string, resourceBundle.getString(string));
        }
        return properties;
    }

    public AbstractViewWizard(ISnapshotManager iSnapshotManager, IControlManager iControlManager) {
        this.controlManager = iControlManager;
        this.snapshotManager = iSnapshotManager;
        this.childWizard = false;
        this.loadProperties();
    }

    public abstract void addPages();

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        this.addHelp();
        this.addControlDependendencies();
        this.loadSnapshot();
        this.checkNonStaticControls();
    }

    private void addHelp() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = 0;
        while (n < iWizardPageArray.length) {
            ((AbstractWizardPage)iWizardPageArray[n]).addHelp();
            ++n;
        }
    }

    protected AbstractWizardPage getAbstractWizardPage(String string) {
        return (AbstractWizardPage)this.getPage(string);
    }

    protected void addControlDependendencies() {
        IWizardPage[] iWizardPageArray = super.getPages();
        int n = 0;
        while (n < this.getPageCount()) {
            AbstractWizardPage abstractWizardPage = this.getAbstractWizardPage(iWizardPageArray[n].getName());
            HashMap<String, IControl> hashMap = abstractWizardPage.getControlMap();
            String[] stringArray = new String[hashMap.size()];
            stringArray = hashMap.keySet().toArray(stringArray);
            int n2 = 0;
            while (n2 < stringArray.length) {
                Object object;
                if (this.controlManager.isDependencyExists(stringArray[n2])) {
                    if (this.isDependenciesSameWizard(stringArray[n2])) {
                        this.addControlActionListeners(stringArray[n2], abstractWizardPage);
                    }
                    if (this.isDependencyChildWizard(stringArray[n2])) {
                        object = this.controlManager.getItemNames(stringArray[n2]);
                        int n3 = 0;
                        while (n3 < ((Vector)object).size()) {
                            Item_dependency[] item_dependencyArray = this.controlManager.getDependentControls(stringArray[n2], (String)((Vector)object).get(n3));
                            int n4 = 0;
                            while (n4 < item_dependencyArray.length) {
                                String string = String.valueOf(item_dependencyArray[n4].getItk_ref()) + "#" + item_dependencyArray[n4].getPage_ref();
                                DependentProperties dependentProperties = new DependentProperties(stringArray[n2], abstractWizardPage.getName(), item_dependencyArray[n4].getRule().toString(), (String)((Vector)object).get(n3), abstractWizardPage, item_dependencyArray[n4].getItk_ref(), item_dependencyArray[n4].getPage_ref());
                                Vector<DependentProperties> vector = null;
                                vector = this.dependentControlDetailsTable.containsKey(string) ? this.dependentControlDetailsTable.get(string) : new Vector<DependentProperties>();
                                vector.add(dependentProperties);
                                this.dependentControlDetailsTable.put(string, vector);
                                String string2 = String.valueOf(stringArray[n2]) + "#" + abstractWizardPage.getName() + "#" + (String)((Vector)object).get(n3) + "#" + item_dependencyArray[n4].getRule().toString() + "#" + item_dependencyArray[n4].getItk_ref() + "#" + item_dependencyArray[n4].getPage_ref();
                                if (!this.conditionalItemDetailsTable.containsKey(string2)) {
                                    this.conditionalItemDetailsTable.put(string2, item_dependencyArray[n4]);
                                }
                                ++n4;
                            }
                            ++n3;
                        }
                    }
                }
                if (this.childWizard) {
                    object = String.valueOf(stringArray[n2]) + "#" + abstractWizardPage;
                    this.setDependentWizardAction((String)object);
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean isDependencyChildWizard(String string) {
        Vector<String> vector = this.controlManager.getItemNames(string);
        int n = 0;
        while (n < vector.size()) {
            Item_dependency[] item_dependencyArray = this.controlManager.getDependentControls(string, vector.get(n));
            int n2 = 0;
            while (n2 < item_dependencyArray.length) {
                String string2 = item_dependencyArray[n2].getPage_ref();
                if (string2 != null && this.getPage(string2) == null) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    private boolean isDependenciesSameWizard(String string) {
        Vector<String> vector = this.controlManager.getItemNames(string);
        int n = 0;
        while (n < vector.size()) {
            Item_dependency[] item_dependencyArray = this.controlManager.getDependentControls(string, vector.get(n));
            int n2 = 0;
            while (n2 < item_dependencyArray.length) {
                String string2 = item_dependencyArray[n2].getPage_ref();
                if (string2 == null || this.getPage(string2) != null) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    private void addControlActionListeners(String string, AbstractWizardPage abstractWizardPage) {
        try {
            IControl iControl = abstractWizardPage.getControlByItemType(string);
            ControlDependencyListener controlDependencyListener = new ControlDependencyListener(this, abstractWizardPage.getName());
            iControl.addControlDependencyEventListener(controlDependencyListener);
            abstractWizardPage.addToControlDependancyList(iControl);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            WizardLogger.writeLogMessage(1, keyNotFoundException);
        }
    }

    protected void setDependentWizardAction(String string) {
    }

    protected boolean isItemExists(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Hashtable<String, Vector<DependentProperties>> getDepControlDetails() {
        return this.dependentControlDetailsTable;
    }

    public Hashtable<String, Item_dependency> getItemTableRef() {
        return this.conditionalItemDetailsTable;
    }

    public IControlManager getControlManager() {
        return this.controlManager;
    }

    public ISnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    protected abstract boolean loadSnapshot();

    public abstract void saveSelections();

    protected void checkNonStaticControls() {
    }
}

