/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.base;

import com.intel.wizards.base.AbstractViewWizard;
import com.intel.wizards.base.IPage;
import com.intel.wizards.base.Status;
import com.intel.wizards.base.controls.AbstractControl;
import com.intel.wizards.base.controls.ControlDependencyEvent;
import com.intel.wizards.base.controls.ControlValidationEvent;
import com.intel.wizards.base.controls.ControlValidationEventListener;
import com.intel.wizards.base.controls.IControl;
import com.intel.wizards.dom.KeyNotFoundException;
import com.intel.wizards.dom.KeyParsingException;
import com.intel.wizards.logger.WizardLogger;
import com.intel.wizards.managers.IControlManager;
import com.intel.wizards.managers.ISnapshotManager;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWizardPage
extends WizardPage
implements IPage {
    private HashMap<String, IControl> controlMap = new HashMap();
    private ArrayList<AbstractControl> controlValidationList = new ArrayList();
    private ArrayList<IControl> controlDependancyList = new ArrayList();
    private boolean pageIncluded = true;
    private ScrolledComposite scrolledComposite;
    private Composite mainComposite = null;
    private String contextId = null;
    protected static Properties prop;
    protected static String propertyFileName;
    protected ArrayList<String> osArrayList;
    protected ArrayList<String> chipsetArrayList;

    public AbstractWizardPage(String string, String string2, ImageDescriptor imageDescriptor) {
        super(string, string2, imageDescriptor);
        this.loadProperties();
    }

    private void loadProperties() {
        try {
            URL uRL = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.intel.graphics"), (IPath)new Path("/"), null));
            propertyFileName = String.valueOf(uRL.getPath()) + "properties/props.properties";
            prop = new Properties();
            prop.load(new BufferedInputStream(new FileInputStream(propertyFileName)));
            String string = prop.getProperty("target_chipset");
            String string2 = prop.getProperty("target_os");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2] = stringTokenizer.nextToken().trim();
                ++n2;
            }
            this.osArrayList = new ArrayList(Arrays.asList(stringArray));
            String[] stringArray2 = string.split(",");
            this.chipsetArrayList = new ArrayList(Arrays.asList(stringArray2));
        }
        catch (Exception exception) {
            exception.getMessage();
            exception.printStackTrace();
        }
    }

    Properties convertBundleToProperties(ResourceBundle resourceBundle) {
        Properties properties = new Properties();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            properties.put(string, resourceBundle.getString(string));
        }
        return properties;
    }

    @Override
    public IControl getControlByItemType(String string) throws KeyNotFoundException {
        if (this.controlMap.containsKey(string)) {
            return this.controlMap.get(string);
        }
        throw new KeyNotFoundException("No control of item type " + string + " exists on page " + this.getTitle());
    }

    public boolean controlExists(String string) {
        return this.controlMap.containsKey(string);
    }

    public Status validateControls() {
        Status status = Status.STATUS_OK;
        Status status2 = Status.STATUS_OK;
        for (AbstractControl abstractControl : this.controlValidationList) {
            Status status3 = abstractControl.validateControl();
            int n = status3.getSeverity();
            switch (n) {
                case 4: {
                    return status3;
                }
                case 2: {
                    status = status3;
                    break;
                }
                case 1: {
                    status2 = status3;
                    break;
                }
            }
        }
        if (status.getSeverity() == 2) {
            return status;
        }
        if (status2.getSeverity() == 1) {
            return status2;
        }
        return Status.STATUS_OK;
    }

    public void validateControlDependencies() {
        int n = 0;
        while (n < this.controlDependancyList.size()) {
            ((AbstractControl)this.controlDependancyList.get(n)).addControlDependencyEvent(new ControlDependencyEvent((AbstractControl)this.controlDependancyList.get(n)));
            ++n;
        }
    }

    protected void addNewControlToList(IControl iControl) {
        this.controlMap.put(iControl.getItemTypeKey(), iControl);
    }

    protected void clearControlMap() {
        this.controlMap.clear();
        this.controlValidationList = new ArrayList();
        this.controlDependancyList = new ArrayList();
    }

    protected void addToControlDependancyList(IControl iControl) {
        if (!this.controlDependancyList.contains(iControl)) {
            this.controlDependancyList.add(iControl);
        }
    }

    public void createControl(Composite composite) {
        this.scrolledComposite = new ScrolledComposite(composite, 2816);
        this.mainComposite = new Composite((Composite)this.scrolledComposite, 0);
        FormLayout formLayout = new FormLayout();
        this.mainComposite.setLayout((Layout)formLayout);
        this.scrolledComposite.setContent((Control)this.mainComposite);
        this.scrolledComposite.setAlwaysShowScrollBars(false);
        try {
            this.createControls(this.mainComposite).pack();
        }
        catch (KeyParsingException keyParsingException) {
            WizardLogger.writeLogMessage(1, keyParsingException);
        }
        this.mainComposite.pack();
        this.addControlToLists(this.mainComposite.getChildren());
        this.setControl((Control)this.scrolledComposite);
    }

    protected void addControlToLists(Control[] controlArray) {
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof Composite) {
                this.addControlToLists(((Composite)controlArray[n]).getChildren());
                if (controlArray[n] instanceof AbstractControl) {
                    AbstractControl abstractControl = (AbstractControl)controlArray[n];
                    this.controlMap.put(abstractControl.getItemTypeKey(), abstractControl);
                    if (abstractControl.isControlValidated()) {
                        this.controlValidationList.add(abstractControl);
                        abstractControl.addControlValidationEventListener(new ControlValidationEventListener(){

                            public void controlChangeEvent(ControlValidationEvent controlValidationEvent) {
                                Status status = AbstractWizardPage.this.validateControls();
                                AbstractWizardPage.this.setPageComplete(true);
                                if (status.getSeverity() == 4) {
                                    AbstractWizardPage.this.setPageComplete(false);
                                }
                                AbstractWizardPage.this.updateMessage(status);
                            }
                        });
                    }
                }
            }
            ++n;
        }
    }

    @Override
    public abstract Composite createControls(Composite var1) throws KeyParsingException;

    @Override
    public IControlManager getControlManager() {
        if (super.getWizard() != null) {
            return ((AbstractViewWizard)super.getWizard()).getControlManager();
        }
        return null;
    }

    @Override
    public ISnapshotManager getSnapshotManager() {
        if (super.getWizard() != null) {
            return ((AbstractViewWizard)super.getWizard()).getSnapshotManager();
        }
        return null;
    }

    public void setVisible(boolean bl) {
        this.validatePage();
        super.setVisible(bl);
    }

    public void validatePage() {
        this.setPageComplete(true);
        if (!this.pageIncluded) {
            this.updateMessage(Status.STATUS_OK);
        }
        this.validateControlDependencies();
        Status status = this.validateControls();
        this.updateMessage(status);
        if (status.getSeverity() == 4) {
            this.setPageComplete(false);
        }
    }

    @Override
    public void updateMessage(Status status) {
        if (status.getSeverity() == 4) {
            this.setMessage(status.getMessage(), 3);
        } else if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
        } else if (status.getSeverity() == 1) {
            this.setMessage(status.getMessage(), 1);
        } else {
            this.setMessage(null);
        }
    }

    public HashMap<String, IControl> getControlMap() {
        return this.controlMap;
    }

    public boolean isPageIncluded() {
        return this.pageIncluded;
    }

    public void setPageIncluded(boolean bl) {
        this.pageIncluded = bl;
    }

    public void setHelpContext(String string) {
        this.contextId = string;
    }

    public void addHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.contextId);
    }
}

