/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.base.controls;

import com.intel.wizards.base.Status;
import com.intel.wizards.base.controls.ControlDependencyEvent;
import com.intel.wizards.base.controls.ControlDependencyEventListener;
import com.intel.wizards.base.controls.ControlValidationEvent;
import com.intel.wizards.base.controls.ControlValidationEventListener;
import com.intel.wizards.base.controls.IControl;
import com.intel.wizards.xml.Control;
import com.intel.wizards.xml.Item;
import com.intel.wizards.xml.Items;
import com.intel.wizards.xml.types.ControlData_typeType;
import java.util.Vector;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractControl
extends Composite
implements IControl {
    protected Control controlView;
    protected Vector<ControlValidationEventListener> controlValidationEventListeners;
    protected Vector<ControlDependencyEventListener> controlDependencyEventListeners;
    private boolean controlRequired;
    private boolean controlValidated;
    private boolean controlDependencies;
    private boolean useControlDependency = true;
    private boolean requireWhenDisabled = false;
    protected final int DEFAULT_SELECTION = 0;

    public AbstractControl(Control control, Composite composite) {
        super(composite, 0);
        this.controlView = control;
        this.controlValidationEventListeners = new Vector();
        this.controlDependencyEventListeners = new Vector();
        this.createControl(this);
        this.addControlValidationEventListener();
        this.addControlDependencyEventListener();
        this.controlRequired = false;
        if (control.getValidation() != null) {
            this.controlValidated = control.getValidation().isValid();
            this.controlRequired = Boolean.parseBoolean(control.getValidation().getRequired());
        } else {
            this.controlRequired = false;
            this.controlValidated = false;
        }
    }

    public void createControl(Composite composite) {
        this.createControls(composite);
    }

    public void addControlDependencyEventListener(ControlDependencyEventListener controlDependencyEventListener) {
        this.controlDependencyEventListeners.addElement(controlDependencyEventListener);
    }

    public void removeControlDependencyEventListener(ControlDependencyEventListener controlDependencyEventListener) {
        this.controlDependencyEventListeners.removeElement(controlDependencyEventListener);
    }

    public void addControlValidationEventListener(ControlValidationEventListener controlValidationEventListener) {
        this.controlValidationEventListeners.addElement(controlValidationEventListener);
    }

    public void removeControlValidationEventListener(ControlValidationEventListener controlValidationEventListener) {
        this.controlValidationEventListeners.removeElement(controlValidationEventListener);
    }

    public Status validateControl() {
        return Status.STATUS_OK;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.checkParentEnabled(bl);
        if (bl) {
            this.addControlDependencyEvent(new ControlDependencyEvent(this));
        }
        this.addControlValidationEvent(new ControlValidationEvent(this));
    }

    private void checkParentEnabled(boolean bl) {
        if (this.getParent().isEnabled()) {
            this.setControlEnabled(bl);
        } else {
            this.setControlEnabled(false);
        }
    }

    protected abstract void setControlEnabled(boolean var1);

    public abstract void createControls(Composite var1);

    public String getItemTypeKey() {
        return this.controlView.getItem_type_key();
    }

    public abstract void addControlValidationEventListener();

    public void addControlValidationEvent(ControlValidationEvent controlValidationEvent) {
        int n = 0;
        while (n < this.controlValidationEventListeners.size()) {
            ControlValidationEventListener controlValidationEventListener = this.controlValidationEventListeners.elementAt(n);
            controlValidationEventListener.controlChangeEvent(controlValidationEvent);
            ++n;
        }
    }

    public abstract void addControlDependencyEventListener();

    public void addControlDependencyEvent(ControlDependencyEvent controlDependencyEvent) {
        if (this.isEnabled() && this.useControlDependency || this.isRequiredWhenDisabled() && this.useControlDependency) {
            int n = 0;
            while (n < this.controlDependencyEventListeners.size()) {
                ControlDependencyEventListener controlDependencyEventListener = this.controlDependencyEventListeners.elementAt(n);
                controlDependencyEventListener.controlChangeEvent(controlDependencyEvent);
                ++n;
            }
        }
    }

    public boolean isControlValidated() {
        return this.controlValidated;
    }

    public void setControlValidated(boolean bl) {
        this.controlValidated = bl;
    }

    public boolean controlHasDependantControls() {
        return this.controlDependencies;
    }

    public void setControlHasDependantControls(boolean bl) {
        this.controlDependencies = bl;
    }

    public int getDataType() {
        ControlData_typeType controlData_typeType = this.controlView.getData_type();
        return controlData_typeType.getType();
    }

    public void setRequired(boolean bl) {
        this.controlRequired = bl;
        if (bl) {
            this.addControlDependencyEvent(new ControlDependencyEvent(this));
        }
    }

    public boolean getRequired() {
        return this.controlRequired;
    }

    public void setControlDependenciesRequired(boolean bl) {
        this.useControlDependency = bl;
        if (bl) {
            this.addControlDependencyEvent(new ControlDependencyEvent(this));
        }
    }

    public boolean getControlDependenciesRequired() {
        return this.useControlDependency;
    }

    protected Item createItemFromControlView(Control control) {
        Item item = new Item();
        item.setItem_name(control.getItems().getItem(0).getItem_name());
        item.setItem_value(control.getItems().getItem(0).getItem_value());
        item.setItem_id(control.getItems().getItem(0).getItem_id());
        return item;
    }

    public Items getControlItems() {
        return this.controlView.getItems();
    }

    public boolean isRequiredWhenDisabled() {
        return this.requireWhenDisabled;
    }

    public void setRequiredWhenDisabled(boolean bl) {
        this.setRequired(bl);
        this.requireWhenDisabled = bl;
    }
}

