/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.controls;

import com.intel.wizards.base.Status;
import com.intel.wizards.base.controls.AbstractControl;
import com.intel.wizards.base.controls.ControlValidationEvent;
import com.intel.wizards.dom.SelectionLoadException;
import com.intel.wizards.logger.WizardLogger;
import com.intel.wizards.xml.Control;
import com.intel.wizards.xml.Item;
import com.intel.wizards.xml.Items;
import com.intel.wizards.xml.Validation;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BrowseControl
extends AbstractControl {
    private static final String BMP = "*.bmp";
    protected static final String OPEN = "OPEN";
    private static final String PNG = "*.png";
    protected Button btn;
    protected Text filePath;

    public BrowseControl(Control control, Composite composite) {
        super(control, composite);
    }

    public void addControlDependencyEventListener() {
    }

    public void addControlValidationEventListener() {
        this.btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(BrowseControl.this.getShell(), 4096);
                fileDialog.setText(BrowseControl.OPEN);
                String[] stringArray = new String[]{BrowseControl.BMP, BrowseControl.PNG};
                fileDialog.setFilterExtensions(stringArray);
                String string = fileDialog.open();
                BrowseControl.this.filePath.setText(string);
                BrowseControl.this.addControlValidationEvent(new ControlValidationEvent(selectionEvent));
            }
        });
        this.filePath.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                BrowseControl.this.addControlValidationEvent(new ControlValidationEvent(keyEvent));
            }
        });
    }

    public void createControls(Composite composite) {
        this.setParent(composite);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.widthHint = 200;
        this.filePath = new Text((Composite)this, 2048);
        this.filePath.setEditable(false);
        this.filePath.setLayoutData((Object)gridData);
        this.btn = new Button((Composite)this, 8);
        this.btn.setText(this.controlView.getControl_title());
    }

    protected void setControlEnabled(boolean bl) {
        this.btn.setEnabled(bl);
        this.filePath.setEnabled(bl);
    }

    public Object getSelection() {
        return this.filePath.getText();
    }

    public Items getSelectionItems() {
        if (this.filePath.getText().length() > 0 && this.getEnabled()) {
            Items items = new Items();
            String string = this.filePath.getText();
            Item item = new Item();
            item.setItem_name(string);
            item.setItem_value(string);
            items.addItem(item);
            return items;
        }
        return null;
    }

    public void setSelection(String string) {
        this.filePath.setText(string);
    }

    public void setSelection(String[] stringArray) {
        try {
            if (stringArray.length > 1) {
                throw new SelectionLoadException("Number in array is greater than one for EditControl with key: " + this.getItemTypeKey());
            }
            this.setSelection(stringArray[0]);
        }
        catch (SelectionLoadException selectionLoadException) {
            WizardLogger.writeLogMessage(1, selectionLoadException);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.btn.addSelectionListener(selectionListener);
    }

    public Status validateControl() {
        Validation validation = this.controlView.getValidation();
        if (validation == null || !this.getEnabled() && !this.isRequiredWhenDisabled()) {
            return Status.STATUS_OK;
        }
        String string = "";
        String string2 = this.filePath.getText();
        if (string2.equals(string)) {
            if (this.getRequired()) {
                return new Status(validation.getSeverityStatus(), validation.getValidation_message(), null);
            }
            return Status.STATUS_OK;
        }
        return Status.STATUS_OK;
    }
}

