/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.controls;

import com.intel.wizards.base.Status;
import com.intel.wizards.base.controls.AbstractControl;
import com.intel.wizards.base.controls.ControlDependencyEvent;
import com.intel.wizards.base.controls.ControlValidationEvent;
import com.intel.wizards.dom.SelectionLoadException;
import com.intel.wizards.logger.WizardLogger;
import com.intel.wizards.xml.Control;
import com.intel.wizards.xml.Items;
import com.intel.wizards.xml.Validation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CheckControl
extends AbstractControl {
    private Button checkBox;

    public CheckControl(Control control, Composite composite) {
        super(control, composite);
    }

    public void createControls(Composite composite) {
        this.setParent(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1, 0x1000000, false, false);
        this.checkBox = new Button((Composite)this, 32);
        this.checkBox.setLayoutData((Object)gridData);
        this.checkBox.setText(this.controlView.getControl_title());
    }

    protected void setControlEnabled(boolean bl) {
        this.checkBox.setEnabled(bl);
    }

    public void setControlText(String string) {
        this.checkBox.setText(string);
    }

    public String getControlText() {
        return this.checkBox.getText();
    }

    public void addControlValidationEventListener() {
        this.checkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CheckControl.this.addControlValidationEvent(new ControlValidationEvent(selectionEvent));
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                CheckControl.this.addControlValidationEvent(new ControlValidationEvent(selectionEvent));
            }
        });
    }

    public Object getSelection() {
        return Boolean.toString(this.checkBox.getSelection());
    }

    public void setSelection(boolean bl) {
        this.checkBox.setSelection(bl);
    }

    public void setSelection(String[] stringArray) {
        try {
            if (stringArray.length != 0) {
                if (stringArray.length > 1) {
                    throw new SelectionLoadException("Number in array is greater than one for CheckControl with key: " + this.getItemTypeKey());
                }
                this.setSelection(Boolean.parseBoolean(stringArray[0]));
            }
        }
        catch (SelectionLoadException selectionLoadException) {
            WizardLogger.writeLogMessage(1, selectionLoadException);
        }
    }

    public void addControlDependencyEventListener() {
        this.checkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CheckControl.this.addControlDependencyEvent(new ControlDependencyEvent(CheckControl.this));
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                CheckControl.this.addControlDependencyEvent(new ControlDependencyEvent(CheckControl.this));
            }
        });
    }

    public Items getSelectionItems() {
        Items items = new Items();
        if (this.checkBox.getSelection() && this.getEnabled() && this.controlView.getItems() != null) {
            items.addItem(this.createItemFromControlView(this.controlView));
            return items;
        }
        return null;
    }

    public Status validateControl() {
        Validation validation = this.controlView.getValidation();
        if (validation == null) {
            return Status.STATUS_OK;
        }
        if (!this.getEnabled()) {
            if (this.isRequiredWhenDisabled()) {
                return new Status(validation.getSeverityStatus(), validation.getValidation_message(), null);
            }
            return Status.STATUS_OK;
        }
        if (this.getRequired() && !this.checkBox.getSelection()) {
            return new Status(validation.getSeverityStatus(), validation.getValidation_message(), null);
        }
        return Status.STATUS_OK;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkBox.addSelectionListener(selectionListener);
    }

    public void setChecked(boolean bl) {
        this.checkBox.setSelection(bl);
    }

    public boolean isChecked() {
        return this.checkBox.getSelection();
    }
}

