/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.controls;

import com.intel.wizards.base.Status;
import com.intel.wizards.base.controls.AbstractControl;
import com.intel.wizards.base.controls.ControlDependencyEvent;
import com.intel.wizards.base.controls.ControlValidationEvent;
import com.intel.wizards.base.controls.INonStaticItems;
import com.intel.wizards.dom.KeyNotFoundException;
import com.intel.wizards.logger.WizardLogger;
import com.intel.wizards.xml.Allowed_item;
import com.intel.wizards.xml.Item;
import com.intel.wizards.xml.Item_dependency;
import com.intel.wizards.xml.Items;
import com.intel.wizards.xml.Validation;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckTableControl
extends AbstractControl
implements INonStaticItems {
    protected Group controlGroup;
    protected Table table;
    private boolean nonStaticItem;
    private SelectionStates selectedState;
    private ArrayList<String> disabledDevices;
    public final String lockImagePath = "icons/locksmall.jpg";
    private String currentOS;

    public CheckTableControl(com.intel.wizards.xml.Control control, Composite composite) {
        super(control, composite);
        this.setNonStaticItem(false);
        this.setSelectedState(SelectionStates.NONE);
        this.disabledDevices = new ArrayList();
    }

    @Override
    public void createControls(Composite composite) {
        this.setParent(composite);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.controlGroup = new Group((Composite)this, 0);
        this.controlGroup.setText(this.controlView.getControl_title());
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        this.controlGroup.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(200, 75);
        this.table = new Table((Composite)this.controlGroup, 2592);
        this.table.setLayoutData((Object)gridData);
        this.addItems(this.getItemsAsStrings());
    }

    protected String[] getItemsAsStrings() {
        Items items = this.controlView.getItems();
        if (items == null) {
            return null;
        }
        String[] stringArray = new String[items.getItemCount()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = items.getItem(n).getItem_name();
            ++n;
        }
        return stringArray;
    }

    protected void addItems(String[] stringArray) {
        this.table.removeAll();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.validateInItems(stringArray[n])) {
                    TableItem tableItem = new TableItem(this.table, 0);
                    tableItem.setText(stringArray[n]);
                    this.setDefaultItemImage(tableItem);
                }
                ++n;
            }
        }
    }

    private void setDefaultItemImage(TableItem tableItem) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.intel.graphics", (String)"icons/locksmall.jpg");
        Image image = new Image(null, imageDescriptor.getImageData());
        tableItem.setImage(image);
        image = null;
        tableItem.setImage(image);
    }

    protected boolean validateInItems(String string) {
        Items items = this.controlView.getItems();
        int n = 0;
        while (n < items.getItemCount()) {
            if (items.getItem(n).getItem_name().equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    protected void setControlEnabled(boolean bl) {
        this.controlGroup.setEnabled(bl);
        Control[] controlArray = this.controlGroup.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].setEnabled(bl);
            ++n;
        }
    }

    @Override
    public void addControlValidationEventListener() {
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CheckTableControl.this.addControlValidationEvent(new ControlValidationEvent(selectionEvent));
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                CheckTableControl.this.addControlValidationEvent(new ControlValidationEvent(selectionEvent));
            }
        });
    }

    @Override
    public Object getSelection() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TableItem[] tableItemArray = this.table.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            switch (this.selectedState) {
                case NONE: {
                    this.getSelectedItemsList(arrayList, tableItemArray, n);
                    break;
                }
                case STM: {
                    if (!this.disabledDevices.contains(tableItemArray[n].getText())) {
                        this.lockItem(tableItemArray, n);
                        break;
                    }
                    this.getSelectedItemsList(arrayList, tableItemArray, n);
                    break;
                }
                case OTHERS: {
                    if (this.disabledDevices.contains(tableItemArray[n].getText())) {
                        this.lockItem(tableItemArray, n);
                        break;
                    }
                    this.getSelectedItemsList(arrayList, tableItemArray, n);
                }
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            this.stateNoneSelected();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void getSelectedItemsList(ArrayList<String> arrayList, TableItem[] tableItemArray, int n) {
        if (tableItemArray[n].getChecked()) {
            arrayList.add(tableItemArray[n].getText());
        }
    }

    private void lockItem(TableItem[] tableItemArray, int n) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.intel.graphics", (String)"icons/locksmall.jpg");
        if (tableItemArray[n].getImage() == null) {
            Image image = new Image(null, imageDescriptor.getImageData());
            tableItemArray[n].setImage(image);
        }
        tableItemArray[n].setChecked(false);
    }

    public void stateSTMSelected() {
        if (this.selectedState == SelectionStates.NONE) {
            this.selectedState = SelectionStates.STM;
        }
    }

    public void stateOthersSelected() {
        if (this.selectedState == SelectionStates.NONE) {
            this.selectedState = SelectionStates.OTHERS;
        }
    }

    public void stateNoneSelected() {
        if (this.selectedState != SelectionStates.NONE) {
            this.selectedState = SelectionStates.NONE;
            TableItem[] tableItemArray = this.table.getItems();
            int n = 0;
            while (n < tableItemArray.length) {
                Image image = null;
                tableItemArray[n].setImage(image);
                ++n;
            }
        }
    }

    public void selectAll(boolean bl) {
        TableItem[] tableItemArray = this.table.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            tableItemArray[n].setChecked(bl);
            ++n;
        }
    }

    @Override
    public void setSelection(String[] stringArray) {
        this.selectAll(false);
        TableItem[] tableItemArray = this.table.getItems();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < tableItemArray.length) {
                if (stringArray[n].equals(tableItemArray[n2].getText())) {
                    tableItemArray[n2].setChecked(true);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void unCheckSelection(String string) {
        TableItem[] tableItemArray = this.table.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            if (string.equals(tableItemArray[n].getText()) && tableItemArray[n].getChecked()) {
                tableItemArray[n].setChecked(false);
            }
            ++n;
        }
    }

    public Group getControlGroup() {
        return this.controlGroup;
    }

    @Override
    public void addControlDependencyEventListener() {
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CheckTableControl.this.addControlDependencyEvent(new ControlDependencyEvent(CheckTableControl.this));
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                CheckTableControl.this.addControlDependencyEvent(new ControlDependencyEvent(CheckTableControl.this));
            }
        });
    }

    @Override
    public Items getSelectionItems() {
        if (this.getEnabled()) {
            Items items = new Items();
            String[] stringArray = (String[])this.getSelection();
            if (this.isNonStaticItem()) {
                if (stringArray.length > 0) {
                    int n = 0;
                    while (n < stringArray.length) {
                        Item item = new Item();
                        item.setItem_name(stringArray[n]);
                        item.setItem_value(stringArray[n]);
                        item.setItem_id(stringArray[n]);
                        items.addItem(item);
                        ++n;
                    }
                    return items;
                }
                return null;
            }
            int n = 0;
            Items items2 = null;
            try {
                items2 = this.controlView.getItems();
                n = items2.getItemCount();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println(this.controlView.getControl_title());
            if (stringArray.length > 0) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    int n3 = 0;
                    while (n3 < n) {
                        if (stringArray[n2].equalsIgnoreCase(items2.getItem(n3).getItem_name())) {
                            items.addItem(items2.getItem(n3));
                        }
                        ++n3;
                    }
                    ++n2;
                }
                return items;
            }
        }
        return null;
    }

    @Override
    public String[] getItemsAllowed() {
        if (this.table.getItemCount() < 1) {
            return null;
        }
        TableItem[] tableItemArray = this.table.getItems();
        String[] stringArray = new String[tableItemArray.length];
        int n = 0;
        while (n < tableItemArray.length) {
            stringArray[n] = tableItemArray[n].getText();
            ++n;
        }
        return stringArray;
    }

    @Override
    public void setItemsAllowed(String[] stringArray) {
        int n;
        String[] stringArray2 = (String[])this.getSelection();
        if (stringArray == null) {
            this.addItems(this.getItemsAsStrings());
        } else {
            n = stringArray.length;
            String[] stringArray3 = new String[n];
            int n2 = 0;
            while (n2 < n) {
                try {
                    stringArray3[n2] = this.controlView.getItems().getItemById(stringArray[n2]).getItem_name();
                }
                catch (KeyNotFoundException keyNotFoundException) {
                    WizardLogger.writeLogMessage(1, new KeyNotFoundException("for ITK: " + this.controlView.getItem_type_key() + " allowed item does not exist: " + keyNotFoundException.getMessage(), keyNotFoundException));
                }
                this.addItems(stringArray3);
                ++n2;
            }
        }
        n = 0;
        while (n < stringArray2.length) {
            int n3 = 0;
            while (n3 < this.table.getItemCount()) {
                if (this.table.getItem(n3).getText().equalsIgnoreCase(stringArray2[n])) {
                    this.table.getItem(n3).setChecked(true);
                }
                ++n3;
            }
            ++n;
        }
    }

    public void setItemsAllowed(Item_dependency item_dependency, String string) {
        Allowed_item[] allowed_itemArray = item_dependency.getAllowed_item();
        String[] stringArray = new String[allowed_itemArray.length];
        int n = 0;
        while (n < allowed_itemArray.length) {
            String string2 = allowed_itemArray[n].getOsList();
            if (string2.indexOf(this.currentOS) != -1) {
                stringArray[n] = allowed_itemArray[n].getAllowed_item_id();
            }
            ++n;
        }
        String[] stringArray2 = (String[])this.getSelection();
        if (stringArray == null) {
            this.addItems(this.getItemsAsStrings());
        } else {
            int n2 = stringArray.length;
            String[] stringArray3 = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                try {
                    if (stringArray[n3] != null) {
                        stringArray3[n3] = this.controlView.getItems().getItemById(stringArray[n3]).getItem_name();
                    }
                }
                catch (KeyNotFoundException keyNotFoundException) {
                    WizardLogger.writeLogMessage(1, new KeyNotFoundException("for ITK: " + this.controlView.getItem_type_key() + " allowed item does not exist: " + keyNotFoundException.getMessage(), keyNotFoundException));
                }
                this.addItems(stringArray3);
                ++n3;
            }
        }
        int n4 = 0;
        while (n4 < stringArray2.length) {
            int n5 = 0;
            while (n5 < this.table.getItemCount()) {
                if (this.table.getItem(n5).getText().equalsIgnoreCase(stringArray2[n4])) {
                    this.table.getItem(n5).setChecked(true);
                }
                ++n5;
            }
            ++n4;
        }
    }

    @Override
    public void setNonStaticItemsAllowed(String[] stringArray) {
        String[] stringArray2 = (String[])this.getSelection();
        this.table.removeAll();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(stringArray[n]);
                ++n;
            }
        }
        if (stringArray2 != null) {
            this.setSelection(stringArray2);
        }
        this.setNonStaticItem(true);
    }

    @Override
    public void setStaticDefaultItem(String string) {
        TableItem tableItem = new TableItem(this.table, 0);
        tableItem.setText(string);
    }

    @Override
    public boolean isNonStaticItem() {
        return this.nonStaticItem;
    }

    @Override
    public void setNonStaticItem(boolean bl) {
        this.nonStaticItem = bl;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.table.addSelectionListener(selectionListener);
    }

    public void setFixedSize(boolean bl) {
        if (!bl) {
            this.table.setLayoutData((Object)new GridData());
            this.pack();
        }
    }

    @Override
    public Status validateControl() {
        Validation validation = this.controlView.getValidation();
        if (validation == null) {
            return Status.STATUS_OK;
        }
        if (!this.getEnabled()) {
            if (this.isRequiredWhenDisabled()) {
                return new Status(validation.getSeverityStatus(), validation.getValidation_message(), null);
            }
            return Status.STATUS_OK;
        }
        String[] stringArray = (String[])this.getSelection();
        long l = stringArray.length;
        if (validation.hasMinimum_value() && (stringArray == null || l == 0L ? this.getRequired() : validation.getMinimum_value() > (float)l)) {
            return new Status(validation.getSeverityStatus(), validation.getValidation_message(), null);
        }
        if (validation.hasMaximum_value() && (stringArray == null || l == 0L ? this.getRequired() : validation.getMaximum_value() < (float)l)) {
            return new Status(validation.getSeverityStatus(), validation.getValidation_message(), null);
        }
        return Status.STATUS_OK;
    }

    public SelectionStates getSelectedState() {
        return this.selectedState;
    }

    public void setSelectedState(SelectionStates selectionStates) {
        this.selectedState = selectionStates;
    }

    public void setDisabledDevices(ArrayList<String> arrayList) {
        this.disabledDevices = arrayList;
    }

    public void setCurrentOS(String string) {
        this.currentOS = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectionStates {
        NONE,
        STM,
        OTHERS;

    }
}

