/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.controls;

import com.intel.wizards.base.controls.AbstractControl;
import com.intel.wizards.base.controls.ControlDependencyEvent;
import com.intel.wizards.base.controls.ControlValidationEvent;
import com.intel.wizards.base.controls.INonStaticItems;
import com.intel.wizards.dom.KeyNotFoundException;
import com.intel.wizards.dom.SelectionLoadException;
import com.intel.wizards.logger.WizardLogger;
import com.intel.wizards.xml.Control;
import com.intel.wizards.xml.Item;
import com.intel.wizards.xml.Items;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ComboControl
extends AbstractControl
implements INonStaticItems {
    protected Label label;
    protected Combo comboBox;
    private String[] controlItemStrings;
    private boolean nonStaticItem;
    protected String defaultItem;

    public ComboControl(Control control, Composite composite) {
        super(control, composite);
        this.setNonStaticItem(false);
    }

    public void createControls(Composite composite) {
        this.setParent(composite);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.label = new Label((Composite)this, 0);
        this.label.setText(this.controlView.getControl_title());
        GridData gridData = new GridData(256);
        gridData.widthHint = 185;
        this.comboBox = new Combo((Composite)this, 2060);
        this.comboBox.setLayoutData((Object)gridData);
        this.loadControl();
    }

    protected void loadControl() {
        Items items = this.controlView.getItems();
        if (items == null) {
            return;
        }
        int n = items.getItemCount();
        this.controlItemStrings = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.controlItemStrings[n2] = items.getItem(n2).getItem_name();
            ++n2;
        }
        this.comboBox.setItems(this.controlItemStrings);
        this.comboBox.select(0);
    }

    protected void setControlEnabled(boolean bl) {
        this.label.setEnabled(bl);
        this.comboBox.setEnabled(bl);
    }

    public void addControlValidationEventListener() {
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ComboControl.this.addControlValidationEvent(new ControlValidationEvent(selectionEvent));
            }
        });
    }

    public Object getSelection() {
        return this.comboBox.getText();
    }

    public void setSelection(String string) {
        if (this.comboBox.indexOf(string) > -1) {
            this.comboBox.select(this.comboBox.indexOf(string));
        } else if (this.isNonStaticItem()) {
            this.comboBox.add(string);
            this.comboBox.select(this.comboBox.getItemCount() - 1);
        } else {
            try {
                throw new Exception("Item " + string + " not found for itemTypeKey " + this.getItemTypeKey());
            }
            catch (Exception exception) {
                WizardLogger.writeLogMessage(1, exception);
            }
        }
    }

    public void setSelection(String[] stringArray) {
        try {
            if (stringArray.length > 1) {
                throw new SelectionLoadException("Number in array is greater than one for ComboControl with key: " + this.getItemTypeKey());
            }
            this.setSelection(stringArray[0]);
        }
        catch (SelectionLoadException selectionLoadException) {
            WizardLogger.writeLogMessage(1, selectionLoadException);
        }
    }

    public void addControlDependencyEventListener() {
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ComboControl.this.addControlDependencyEvent(new ControlDependencyEvent(ComboControl.this));
            }
        });
    }

    public Items getSelectionItems() {
        if (this.getEnabled()) {
            Items items = new Items();
            String string = (String)this.getSelection();
            if (this.isNonStaticItem()) {
                if (string.length() > 0) {
                    Item item = new Item();
                    item.setItem_name(string);
                    item.setItem_value(string);
                    item.setItem_id(string);
                    items.addItem(item);
                    return items;
                }
                return null;
            }
            Items items2 = this.controlView.getItems();
            int n = items2.getItemCount();
            if (string.length() > 0) {
                int n2 = 0;
                while (n2 < n) {
                    if (string.equalsIgnoreCase(items2.getItem(n2).getItem_name())) {
                        items.addItem(items2.getItem(n2));
                        return items;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    public void setItems(String[] stringArray) {
        this.comboBox.setItems(stringArray);
    }

    public String[] getItemsAllowed() {
        return this.controlItemStrings;
    }

    public void setItemsAllowed(String[] stringArray) {
        if (this.isNonStaticItem()) {
            return;
        }
        String string = this.comboBox.getText();
        this.comboBox.removeAll();
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                stringArray2[n2] = this.controlView.getItems().getItemById(stringArray[n2]).getItem_name();
            }
            catch (KeyNotFoundException keyNotFoundException) {
                WizardLogger.writeLogMessage(1, new KeyNotFoundException("for ITK: " + this.controlView.getItem_type_key() + " allowed item does not exist: " + keyNotFoundException.getMessage(), keyNotFoundException));
            }
            ++n2;
        }
        this.controlItemStrings = stringArray2;
        this.setItems(stringArray2);
        if (this.comboBox.indexOf(string) > -1) {
            this.comboBox.select(this.comboBox.indexOf(string));
        } else {
            this.comboBox.select(0);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.comboBox.addSelectionListener(selectionListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.comboBox.addFocusListener(focusListener);
    }

    public void setNonStaticItemsAllowed(String[] stringArray) {
        this.setNonStaticItem(true);
        if (stringArray == null || stringArray.length == 0) {
            this.comboBox.clearSelection();
            return;
        }
        String string = this.comboBox.getText();
        this.comboBox.removeAll();
        if (this.defaultItem != null) {
            String[] stringArray2 = stringArray;
            stringArray = new String[stringArray2.length + 1];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            stringArray[stringArray2.length] = this.defaultItem;
        }
        this.controlItemStrings = stringArray;
        this.setItems(this.controlItemStrings);
        if (this.comboBox.indexOf(string) > -1) {
            this.comboBox.select(this.comboBox.indexOf(string));
        } else {
            this.comboBox.select(0);
        }
    }

    public boolean isNonStaticItem() {
        return this.nonStaticItem;
    }

    public void setNonStaticItem(boolean bl) {
        this.nonStaticItem = bl;
    }

    public void setStaticDefaultItem(String string) {
        this.comboBox.add(string);
        this.comboBox.select(0);
        this.defaultItem = string;
    }

    public void removeSelection(String string) {
        this.comboBox.remove(string);
        this.comboBox.select(0);
    }
}

