/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.controls;

import com.intel.wizards.base.Status;
import com.intel.wizards.base.controls.AbstractControl;
import com.intel.wizards.base.controls.ControlDependencyEvent;
import com.intel.wizards.base.controls.ControlValidationEvent;
import com.intel.wizards.dom.SelectionLoadException;
import com.intel.wizards.logger.WizardLogger;
import com.intel.wizards.utilities.HexIntegerUtility;
import com.intel.wizards.xml.Control;
import com.intel.wizards.xml.Item;
import com.intel.wizards.xml.Items;
import com.intel.wizards.xml.Validation;
import com.intel.wizards.xml.types.ControlData_typeType;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EditControl
extends AbstractControl {
    private static final char NEGATIVE = '-';
    protected Label label;
    protected Text editBox;

    public EditControl(Control control, Composite composite) {
        super(control, composite);
    }

    public void createControls(Composite composite) {
        this.setParent(composite);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.label = new Label((Composite)this, 0);
        this.label.setText(this.controlView.getControl_title());
        GridData gridData = new GridData(256);
        gridData.widthHint = 200;
        this.editBox = new Text((Composite)this, 2048);
        this.editBox.setLayoutData((Object)gridData);
    }

    protected void setControlEnabled(boolean bl) {
        this.label.setEnabled(bl);
        this.editBox.setEnabled(bl);
    }

    public void addControlValidationEventListener() {
        this.editBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                EditControl.this.addControlValidationEvent(new ControlValidationEvent(keyEvent));
            }
        });
    }

    public Status validateControl() {
        Validation validation = this.controlView.getValidation();
        if (validation == null || !this.getEnabled() && !this.isRequiredWhenDisabled()) {
            return Status.STATUS_OK;
        }
        String string = "";
        String string2 = this.editBox.getText();
        int n = string2.length();
        if (string2.equals(string)) {
            if (this.getRequired()) {
                return new Status(validation.getSeverityStatus(), validation.getValidation_message(), null);
            }
            return Status.STATUS_OK;
        }
        ControlData_typeType controlData_typeType = this.controlView.getData_type();
        if (this.controlView.getData_type().getType() == 0) {
            if (!this.checkRange(validation, n)) {
                return new Status(4, validation.getValidation_message(), null);
            }
        } else if (controlData_typeType.getType() == 3 || controlData_typeType.getType() == 1 || controlData_typeType.getType() == 6) {
            int n2 = 0;
            if (controlData_typeType.getType() == 3 && n > 2 && (string2.startsWith("0x") || string2.startsWith("0X"))) {
                Float f;
                if (!HexIntegerUtility.validateHexString(string2)) {
                    return new Status(4, validation.getValidation_message(), null);
                }
                if (validation.hasMinimum_value() && validation.getMinimum_value() < 0.0f && validation.hasMaximum_value() && n == HexIntegerUtility.convertIntToHexString((f = Float.valueOf(validation.getMaximum_value())).intValue()).length() && string2.charAt(2) > '7') {
                    int n3 = 10 - n;
                    String string3 = "0x";
                    int n4 = 0;
                    while (n3 > n4) {
                        string3 = String.valueOf(string3) + "F";
                        ++n4;
                    }
                    string2 = String.valueOf(string3) + string2.substring(2);
                    n2 = HexIntegerUtility.convertHexStringToInt(string2, true);
                }
                if (n2 == 0) {
                    n2 = HexIntegerUtility.convertHexStringToInt(string2, false);
                }
                if (!this.checkRange(validation, n2)) {
                    return new Status(4, validation.getValidation_message(), null);
                }
                return Status.STATUS_OK;
            }
            try {
                n2 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return new Status(4, validation.getValidation_message(), null);
            }
            if (!this.checkRange(validation, n2)) {
                return new Status(4, validation.getValidation_message(), null);
            }
        } else if (controlData_typeType.getType() == 5) {
            try {
                float f = Float.valueOf(string2).floatValue();
                if (!this.checkRange(validation, f)) {
                    return new Status(4, validation.getValidation_message(), null);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new Status(4, validation.getValidation_message(), null);
            }
        }
        return Status.STATUS_OK;
    }

    public Object getSelection() {
        return this.editBox.getText();
    }

    public void setSelection(String string) {
        this.editBox.setText(string);
    }

    public void setSelection(String[] stringArray) {
        try {
            if (stringArray.length > 1) {
                throw new SelectionLoadException("Number in array is greater than one for EditControl with key: " + this.getItemTypeKey());
            }
            this.setSelection(stringArray[0]);
        }
        catch (SelectionLoadException selectionLoadException) {
            WizardLogger.writeLogMessage(1, selectionLoadException);
        }
    }

    public void addControlDependencyEventListener() {
        this.editBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                EditControl.this.addControlDependencyEvent(new ControlDependencyEvent(EditControl.this));
            }
        });
    }

    public Items getSelectionItems() {
        if (this.editBox.getText().length() > 0 && this.getEnabled()) {
            Items items = new Items();
            String string = this.editBox.getText();
            Item item = new Item();
            item.setItem_name(string);
            if (HexIntegerUtility.validateHexString(string)) {
                string = Integer.toString(HexIntegerUtility.convertHexStringToInt(string, false));
            }
            if (this.controlView.getData_type().getType() == 6 && string.charAt(0) == '-') {
                int n = Integer.parseInt(string);
                String string2 = "";
                int n2 = 65536;
                while ((n2 >>= 1) > 0) {
                    string2 = String.valueOf(string2) + ((n & n2) != 0 ? "1" : "0");
                }
                int n3 = Integer.parseInt(string2, 2);
                string = Integer.toHexString(n3);
                string = "0x" + string;
            }
            item.setItem_value(string);
            items.addItem(item);
            return items;
        }
        return null;
    }

    protected boolean checkRange(Validation validation, float f) {
        return !(validation.hasMaximum_value() && validation.hasMinimum_value() ? f < validation.getMinimum_value() || f > validation.getMaximum_value() : (validation.hasMaximum_value() ? f > validation.getMaximum_value() : validation.hasMinimum_value() && f < validation.getMinimum_value()));
    }

    public void setEditable(boolean bl) {
        this.editBox.setEditable(bl);
    }
}

