/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.controls;

import com.intel.wizards.base.Status;
import com.intel.wizards.base.controls.AbstractControl;
import com.intel.wizards.base.controls.ControlDependencyEvent;
import com.intel.wizards.base.controls.ControlValidationEvent;
import com.intel.wizards.base.controls.IMultiItemControl;
import com.intel.wizards.base.controls.IMultiSelectionControl;
import com.intel.wizards.controls.ItemChangeListener;
import com.intel.wizards.controls.ItemChangedEvent;
import com.intel.wizards.dom.KeyNotFoundException;
import com.intel.wizards.logger.WizardLogger;
import com.intel.wizards.xml.Items;
import com.intel.wizards.xml.Validation;
import java.util.Vector;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class ItemListSelectControl
extends AbstractControl
implements IMultiItemControl,
IMultiSelectionControl {
    private static final int MOVE_UP = -1;
    private static final int MOVE_DOWN = 1;
    private String[] fromItemsAllowed;
    private float maxAllowed;
    private float minRequired;
    private List fromList;
    private List toList;
    private Button addButton;
    private Button downButton;
    private Button removeButton;
    private Button upButton;
    private Button clearButton;
    private Group controlGroup;
    private Label fromListLabel;
    private Label toListLabel;
    protected Vector<ItemChangeListener> itemChangeListeners;

    public ItemListSelectControl(com.intel.wizards.xml.Control control, Composite composite) {
        super(control, composite);
    }

    private void moveItem(int n) {
        if (this.toList.getSelectionCount() > 0 && (this.toList.getSelectionIndex() != 0 || n != -1)) {
            String string = this.toList.getItem(this.toList.getSelectionIndex());
            String string2 = this.toList.getItem(this.toList.getSelectionIndex() + n);
            this.toList.setItem(this.toList.getSelectionIndex(), string2);
            this.toList.setItem(this.toList.getSelectionIndex() + n, string);
            this.toList.setSelection(this.toList.getSelectionIndex() + n);
        }
    }

    public void createControls(Composite composite) {
        int n = 200;
        int n2 = 50;
        this.setParent(composite);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.controlGroup = new Group((Composite)this, 0);
        this.controlGroup.setText(this.controlView.getControl_title());
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 10;
        formLayout.marginWidth = 10;
        this.controlGroup.setLayout((Layout)formLayout);
        this.fromListLabel = new Label((Composite)this.controlGroup, 1);
        this.toListLabel = new Label((Composite)this.controlGroup, 1);
        this.addButton = new Button((Composite)this.controlGroup, 4);
        this.addButton.setAlignment(131072);
        this.downButton = new Button((Composite)this.controlGroup, 4);
        this.downButton.setAlignment(1024);
        this.removeButton = new Button((Composite)this.controlGroup, 4);
        this.removeButton.setAlignment(16384);
        this.upButton = new Button((Composite)this.controlGroup, 4);
        this.upButton.setAlignment(128);
        this.clearButton = new Button((Composite)this.controlGroup, 8);
        this.fromList = new List((Composite)this.controlGroup, 2564);
        this.toList = new List((Composite)this.controlGroup, 2564);
        this.addListeners();
        this.addItems(this.getItemsAsStrings());
        if (this.controlView.getValidation() != null && this.controlView.getValidation().isValid()) {
            this.setMaximumAllowed(this.controlView.getValidation().getMaximum_value());
            this.setMinimumRequired(this.controlView.getValidation().getMinimum_value());
        } else {
            this.setMaximumAllowed(this.getItemsAsStrings().length);
            this.setMinimumRequired(0.0f);
        }
        this.fromListLabel.setText("From List");
        this.toListLabel.setText("To List");
        FormData formData = new FormData();
        formData.width = n;
        formData.height = 100;
        formData.top = new FormAttachment((Control)this.fromListLabel, 0, 1024);
        this.fromList.setLayoutData((Object)formData);
        formData = new FormData();
        formData.width = n;
        formData.left = new FormAttachment((Control)this.addButton, 5, 131072);
        formData.top = new FormAttachment((Control)this.fromList, 0, 128);
        formData.bottom = new FormAttachment((Control)this.fromList, 0, 1024);
        this.toList.setLayoutData((Object)formData);
        formData = new FormData();
        this.fromListLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.toList, 0, 16384);
        this.toListLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.width = n2;
        formData.left = new FormAttachment((Control)this.fromList, 5, 131072);
        formData.top = new FormAttachment((Control)this.fromList, 10, 128);
        this.addButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.width = n2;
        formData.left = new FormAttachment((Control)this.addButton, 0, 16384);
        formData.top = new FormAttachment((Control)this.addButton, 5, 1024);
        this.removeButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.width = n2;
        formData.left = new FormAttachment((Control)this.addButton, 0, 16384);
        formData.top = new FormAttachment((Control)this.removeButton, 5, 1024);
        this.upButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.width = n2;
        formData.left = new FormAttachment((Control)this.addButton, 0, 16384);
        formData.top = new FormAttachment((Control)this.upButton, 5, -1);
        this.downButton.setLayoutData((Object)formData);
        this.clearButton.setText("Clear");
        formData = new FormData();
        formData.width = n2;
        formData.right = new FormAttachment((Control)this.toList, 0, 131072);
        formData.top = new FormAttachment((Control)this.toList, 5, 1024);
        this.clearButton.setLayoutData((Object)formData);
    }

    private void addSelection(TypedEvent typedEvent) {
        if ((float)this.toList.getItemCount() < this.maxAllowed) {
            this.toList.deselectAll();
            if (this.fromList.getSelectionCount() > 0 && this.toList.indexOf(this.fromList.getItem(this.fromList.getSelectionIndex())) == -1) {
                this.toList.add(this.fromList.getItem(this.fromList.getSelectionIndex()));
                this.fromList.remove(this.fromList.getItem(this.fromList.getSelectionIndex()));
                this.itemAdded(typedEvent);
            }
        }
    }

    private void removeSelection(TypedEvent typedEvent) {
        if (this.toList.getSelectionCount() > 0) {
            this.fromList.add(this.toList.getItem(this.toList.getSelectionIndex()));
            this.toList.remove(this.toList.getItem(this.toList.getSelectionIndex()));
            this.itemAdded(typedEvent);
        }
    }

    private void addListeners() {
        this.fromList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                ItemListSelectControl.this.addSelection((TypedEvent)mouseEvent);
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ItemListSelectControl.this.addSelection((TypedEvent)selectionEvent);
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ItemListSelectControl.this.removeSelection((TypedEvent)selectionEvent);
            }
        });
        this.toList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                ItemListSelectControl.this.removeSelection((TypedEvent)mouseEvent);
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ItemListSelectControl.this.fromList.deselectAll();
                ItemListSelectControl.this.moveItem(-1);
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ItemListSelectControl.this.fromList.deselectAll();
                ItemListSelectControl.this.moveItem(1);
            }
        });
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ItemListSelectControl.this.toList.removeAll();
                ItemListSelectControl.this.fromList.setItems(ItemListSelectControl.this.fromItemsAllowed);
                ItemListSelectControl.this.itemAdded((TypedEvent)selectionEvent);
            }
        });
    }

    public void addControlDependencyEventListener() {
        if (this.itemChangeListeners == null) {
            this.itemChangeListeners = new Vector();
        }
        this.addItemChangedListener(new ItemChangeListener(){

            public void itemChangeEvent(ItemChangedEvent itemChangedEvent) {
                ItemListSelectControl.this.addControlDependencyEvent(new ControlDependencyEvent(ItemListSelectControl.this));
            }
        });
    }

    public void addControlValidationEventListener() {
        if (this.itemChangeListeners == null) {
            this.itemChangeListeners = new Vector();
        }
        this.addItemChangedListener(new ItemChangeListener(){

            public void itemChangeEvent(ItemChangedEvent itemChangedEvent) {
                ItemListSelectControl.this.addControlValidationEvent(new ControlValidationEvent((Object)itemChangedEvent));
            }
        });
    }

    private String[] getItemsAsStrings() {
        Items items = this.controlView.getItems();
        String[] stringArray = new String[items.getItemCount()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = items.getItem(n).getItem_name();
            ++n;
        }
        return stringArray;
    }

    public void setControlEnabled(boolean bl) {
        this.controlGroup.setEnabled(bl);
        Control[] controlArray = this.controlGroup.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].setEnabled(bl);
            ++n;
        }
    }

    private void addItems(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.fromItemsAllowed = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (this.validateInItems(stringArray[n])) {
                this.fromItemsAllowed[n] = stringArray[n];
            }
            ++n;
        }
        this.fromList.setItems(this.fromItemsAllowed);
        String[] stringArray2 = this.toList.getItems();
        this.setSelection(stringArray2);
    }

    private boolean validateInItems(String string) {
        Items items = this.controlView.getItems();
        int n = 0;
        while (n < items.getItemCount()) {
            if (items.getItem(n).getItem_name().equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Status validateControl() {
        if ((float)this.toList.getItemCount() > this.maxAllowed || (float)this.toList.getItemCount() < this.minRequired) {
            Validation validation = this.controlView.getValidation();
            if (validation == null) {
                return new Status(validation.getSeverityStatus(), "No Validation Message set - there should be one for control " + this.getItemTypeKey(), null);
            }
            return new Status(validation.getSeverityStatus(), validation.getValidation_message(), null);
        }
        return Status.STATUS_OK;
    }

    public Object getSelection() {
        if (this.toList.getItemCount() == 0) {
            return null;
        }
        return this.toList.getItems();
    }

    public void setSelection(String[] stringArray) {
        this.toList.removeAll();
        int n = 0;
        while (n < stringArray.length) {
            if (this.fromList.indexOf(stringArray[n]) > -1) {
                this.toList.add(stringArray[n]);
                this.fromList.remove(stringArray[n]);
            }
            ++n;
        }
    }

    public Items getSelectionItems() {
        if (this.getEnabled() && this.toList.getItemCount() > 0) {
            Items items = new Items();
            Items items2 = this.controlView.getItems();
            int n = items2.getItemCount();
            String[] stringArray = (String[])this.getSelection();
            if (stringArray.length > 0) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    int n3 = 0;
                    while (n3 < n) {
                        if (stringArray[n2].equalsIgnoreCase(items2.getItem(n3).getItem_name())) {
                            items.addItem(items2.getItem(n3));
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            return items;
        }
        return null;
    }

    public void setItemsAllowed(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.addItems(this.getItemsAsStrings());
        } else {
            int n = stringArray.length;
            String[] stringArray2 = new String[n];
            int n2 = 0;
            while (n2 < n) {
                try {
                    stringArray2[n2] = this.controlView.getItems().getItemById(stringArray[n2]).getItem_name();
                }
                catch (KeyNotFoundException keyNotFoundException) {
                    WizardLogger.writeLogMessage(1, new KeyNotFoundException("for ITK: " + this.controlView.getItem_type_key() + " allowed item does not exist: " + keyNotFoundException.getMessage(), keyNotFoundException));
                }
                ++n2;
            }
            this.addItems(stringArray2);
        }
    }

    public String[] getItemsAllowed() {
        return this.fromItemsAllowed;
    }

    public void setMaximumAllowed(float f) {
        this.maxAllowed = f;
        if (this.maxAllowed <= 0.0f) {
            this.maxAllowed = this.getItemsAllowed().length;
        }
        this.addControlValidationEvent(new ControlValidationEvent(this));
    }

    public float getMaximumAllowed() {
        return this.maxAllowed;
    }

    private void addItemChangedListener(ItemChangeListener itemChangeListener) {
        this.itemChangeListeners.addElement(itemChangeListener);
    }

    private void removeItemAddedListener(ItemChangeListener itemChangeListener) {
        this.itemChangeListeners.removeElement(itemChangeListener);
    }

    public void itemAdded(TypedEvent typedEvent) {
        ItemChangedEvent itemChangedEvent = new ItemChangedEvent(typedEvent);
        int n = this.itemChangeListeners.size();
        int n2 = 0;
        while (n2 < n) {
            ItemChangeListener itemChangeListener = this.itemChangeListeners.elementAt(n2);
            itemChangeListener.itemChangeEvent(itemChangedEvent);
            ++n2;
        }
    }

    public void setFromTitle(String string) {
        this.fromListLabel.setText(string);
    }

    public void setToTitle(String string) {
        this.toListLabel.setText(string);
    }

    public void setMinimumRequired(float f) {
        this.minRequired = f;
        if (this.minRequired < 0.0f) {
            this.minRequired = 0.0f;
        }
        this.addControlValidationEvent(new ControlValidationEvent(this));
    }

    public float getMinimumRequired() {
        return this.minRequired;
    }
}

