/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.controls;

import com.intel.wizards.base.controls.AbstractControl;
import com.intel.wizards.base.controls.ControlDependencyEvent;
import com.intel.wizards.base.controls.ControlValidationEvent;
import com.intel.wizards.base.controls.IMultiItemControl;
import com.intel.wizards.base.controls.IMultiSelectionControl;
import com.intel.wizards.controls.ItemChangeListener;
import com.intel.wizards.controls.ItemChangedEvent;
import com.intel.wizards.xml.Control;
import com.intel.wizards.xml.Items;
import java.util.Vector;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class ListBoxControl
extends AbstractControl
implements IMultiItemControl,
IMultiSelectionControl {
    private String[] controlItemStrings;
    private List list;
    protected Vector<ItemChangeListener> itemChangeListeners;

    public ListBoxControl(Control control, Composite composite) {
        super(control, composite);
    }

    public void createControls(Composite composite) {
        this.setParent(composite);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 16384);
        label.setText(this.controlView.getControl_title());
        GridData gridData = new GridData();
        gridData.heightHint = 100;
        gridData.widthHint = 200;
        this.list = new List((Composite)this, 2820);
        this.list.setLayoutData((Object)gridData);
        this.generateContent();
    }

    private void generateContent() {
        Items items = this.controlView.getItems();
        this.controlItemStrings = new String[items.getItemCount()];
        int n = 0;
        while (n < this.controlItemStrings.length) {
            this.controlItemStrings[n] = items.getItem(n).getItem_name();
            ++n;
        }
        this.list.setItems(this.controlItemStrings);
    }

    public void updateControlView(Control control) {
        this.controlView = control;
        this.generateContent();
    }

    protected void setControlEnabled(boolean bl) {
        this.list.setEnabled(true);
    }

    public void addControlValidationEventListener() {
        if (this.itemChangeListeners == null) {
            this.itemChangeListeners = new Vector();
        }
        this.addItemChangedListener(new ItemChangeListener(){

            public void itemChangeEvent(ItemChangedEvent itemChangedEvent) {
                ListBoxControl.this.addControlValidationEvent(new ControlValidationEvent((Object)itemChangedEvent));
            }
        });
    }

    public void setSelection(String[] stringArray) {
        this.list.setItems(stringArray);
    }

    public void addControlDependencyEventListener() {
        if (this.itemChangeListeners == null) {
            this.itemChangeListeners = new Vector();
        }
        this.addItemChangedListener(new ItemChangeListener(){

            public void itemChangeEvent(ItemChangedEvent itemChangedEvent) {
                ListBoxControl.this.addControlDependencyEvent(new ControlDependencyEvent(ListBoxControl.this));
            }
        });
    }

    public Items getSelectionItems() {
        if (this.getEnabled()) {
            Items items = new Items();
            Items items2 = this.controlView.getItems();
            int n = items2.getItemCount();
            String[] stringArray = (String[])this.getSelection();
            int n2 = 0;
            while (n2 < stringArray.length) {
                int n3 = 0;
                while (n3 < n) {
                    if (stringArray[n2].equalsIgnoreCase(items2.getItem(n3).getItem_name())) {
                        items.addItem(items2.getItem(n3));
                    }
                    ++n3;
                }
                ++n2;
            }
            return items;
        }
        return null;
    }

    private void addItemChangedListener(ItemChangeListener itemChangeListener) {
        this.itemChangeListeners.addElement(itemChangeListener);
    }

    public Object getSelection() {
        return this.list.getSelection();
    }

    public String[] getItemsAllowed() {
        return null;
    }

    public void setItemsAllowed(String[] stringArray) {
    }

    public void setMaximumAllowed(float f) {
    }

    public float getMaximumAllowed() {
        return 0.0f;
    }

    public void setMinimumRequired(float f) {
    }

    public float getMinimumRequired() {
        return 0.0f;
    }
}

