/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.controls;

import com.intel.wizards.base.controls.AbstractControl;
import com.intel.wizards.base.controls.ControlDependencyEvent;
import com.intel.wizards.base.controls.ControlValidationEvent;
import com.intel.wizards.xml.Control;
import com.intel.wizards.xml.Items;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class RadioControl
extends AbstractControl {
    protected Button[] radioButtons;
    protected Group controlGroup;

    public RadioControl(Control control, Composite composite) {
        super(control, composite);
    }

    public void createControls(Composite composite) {
        this.setParent(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.controlGroup = new Group((Composite)this, 0);
        this.controlGroup.setText(this.controlView.getControl_title());
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        this.controlGroup.setLayout((Layout)gridLayout2);
        Items items = this.controlView.getItems();
        if (items == null) {
            return;
        }
        this.radioButtons = new Button[items.getItemCount()];
        int n = 0;
        while (n < items.getItemCount()) {
            this.radioButtons[n] = new Button((Composite)this.controlGroup, 16);
            this.radioButtons[n].setText(items.getItem(n).getItem_name());
            ++n;
        }
        this.radioButtons[0].setSelection(true);
    }

    protected void setControlEnabled(boolean bl) {
        this.controlGroup.setEnabled(bl);
        org.eclipse.swt.widgets.Control[] controlArray = this.controlGroup.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].setEnabled(bl);
            ++n;
        }
    }

    public void addControlValidationEventListener() {
        int n = 0;
        while (n < this.radioButtons.length) {
            this.radioButtons[n].addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent mouseEvent) {
                    RadioControl.this.addControlValidationEvent(new ControlValidationEvent(mouseEvent));
                }
            });
            ++n;
        }
    }

    public Object getSelection() {
        int n = 0;
        while (n < this.radioButtons.length) {
            if (this.radioButtons[n].getSelection()) {
                return this.radioButtons[n].getText();
            }
            ++n;
        }
        return "";
    }

    public void selectAll(boolean bl) {
        int n = 0;
        while (n < this.radioButtons.length) {
            this.radioButtons[n].setSelection(bl);
            ++n;
        }
    }

    public void setSelection(String[] stringArray) {
        this.selectAll(false);
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < this.radioButtons.length) {
                if (stringArray[n].equals(this.radioButtons[n2].getText())) {
                    this.radioButtons[n2].setSelection(true);
                }
                ++n2;
            }
            ++n;
        }
    }

    public Items getSelectionItems() {
        if (this.getEnabled()) {
            Items items = new Items();
            Items items2 = this.controlView.getItems();
            int n = items2.getItemCount();
            String string = (String)this.getSelection();
            if (string.length() > 0) {
                int n2 = 0;
                while (n2 < n) {
                    if (string.equalsIgnoreCase(items2.getItem(n2).getItem_name())) {
                        items.addItem(items2.getItem(n2));
                        return items;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    public void addControlDependencyEventListener() {
        int n = 0;
        while (n < this.radioButtons.length) {
            this.radioButtons[n].addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent mouseEvent) {
                    RadioControl.this.addControlDependencyEvent(new ControlDependencyEvent(RadioControl.this));
                }
            });
            ++n;
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        int n = 0;
        while (n < this.radioButtons.length) {
            this.radioButtons[n].addSelectionListener(selectionListener);
            ++n;
        }
    }
}

