/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.generator;

import com.intel.wizards.generator.GenerationException;
import com.intel.wizards.generator.KeyNPage;
import com.intel.wizards.logger.WizardLogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;

public abstract class LineGenerator {
    protected static final String LIN_LINE_RETURN = new String(new char[]{'\n'});
    private static final String FILEPATH_SLASH = "\\";
    protected BufferedWriter writer;

    protected void writeLine(String string) {
        try {
            this.writer.write(this.removeEscapeChar(string));
            this.writer.newLine();
        }
        catch (IOException iOException) {
            WizardLogger.writeLogMessage(1, iOException);
        }
    }

    protected void linWriteLine(String string) {
        try {
            this.writer.write(String.valueOf(this.removeEscapeChar(string)) + LIN_LINE_RETURN);
        }
        catch (IOException iOException) {
            WizardLogger.writeLogMessage(1, iOException);
        }
    }

    protected String removeEscapeChar(String string) {
        while (string.contains("@$")) {
            int n = string.indexOf("@");
            string = String.valueOf(string.substring(0, n)) + string.substring(n + 1);
        }
        return string;
    }

    protected KeyNPage[] getKeyFromLine(String string) {
        return this.getKeyFromLine(string, "");
    }

    public KeyNPage[] getKeyFromLine(String string, String string2) {
        ArrayList<KeyNPage> arrayList = new ArrayList<KeyNPage>();
        int n = 0;
        while (string.indexOf("$", n) != -1) {
            int n2 = string.indexOf("$", n);
            int n3 = string.indexOf("$", n2 + 1);
            if (n2 > 0 && string.substring(n2 - 1, n2).equals("@")) {
                string = String.valueOf(string.substring(0, n2 - 1)) + string.substring(n2);
                n = n2;
                continue;
            }
            if (n2 != n3 && n3 != -1) {
                String string3 = string2;
                String string4 = string.substring(n2 + 1, n3);
                KeyNPage keyNPage = new KeyNPage(string4, string3);
                if (keyNPage.isUniqueKey(arrayList)) {
                    arrayList.add(keyNPage);
                }
            }
            n = n3 + 1;
        }
        return arrayList.toArray(new KeyNPage[arrayList.size()]);
    }

    protected boolean isKeyInLine(String string) {
        KeyNPage[] keyNPageArray = this.getKeyFromLine(string);
        return keyNPageArray != null && keyNPageArray.length != 0;
    }

    protected boolean isKeyInLine(String string, String string2, String string3) {
        KeyNPage[] keyNPageArray = this.getKeyFromLine(string2, string3);
        int n = 0;
        while (n < keyNPageArray.length) {
            if (string.equals(keyNPageArray[n].getKey())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected String replaceKeyInLine(String string, String string2, String string3) {
        try {
            if (string2 == null) {
                throw new GenerationException("Cannot replace a value with null!  Key is " + string);
            }
            if (string == null) {
                throw new GenerationException("Cannot replace a null key!");
            }
            if (string3 == null) {
                throw new GenerationException("Cannot replace a null line!  Key is " + string);
            }
        }
        catch (GenerationException generationException) {
            WizardLogger.writeLogMessage(1, generationException);
        }
        if (string2.contains(FILEPATH_SLASH)) {
            string2 = string2.replaceAll("\\\\", "\\\\\\\\");
        }
        return string3.replaceAll("\\$" + string + "\\$", string2);
    }
}

