/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.listeners;

import com.intel.wizards.base.AbstractViewWizard;
import com.intel.wizards.base.AbstractWizardPage;
import com.intel.wizards.base.controls.AbstractControl;
import com.intel.wizards.base.controls.ControlDependencyEvent;
import com.intel.wizards.base.controls.ControlDependencyEventListener;
import com.intel.wizards.base.controls.ControlValidationEvent;
import com.intel.wizards.base.controls.IControl;
import com.intel.wizards.base.controls.IMultiItemControl;
import com.intel.wizards.base.controls.IMultiSelectionControl;
import com.intel.wizards.controls.CheckTableControl;
import com.intel.wizards.dom.KeyNotFoundException;
import com.intel.wizards.logger.WizardLogger;
import com.intel.wizards.xml.Item_dependency;
import com.intel.wizards.xml.Items;
import com.intel.wizards.xml.types.Item_dependencyOSRuleType;
import com.intel.wizards.xml.types.Item_dependencyRuleType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlDependencyListener
implements ControlDependencyEventListener {
    private AbstractViewWizard wizard;
    private String condPageName;
    private AbstractControl conditionalControl;

    public ControlDependencyListener(AbstractViewWizard abstractViewWizard, String string) {
        this.wizard = abstractViewWizard;
        this.condPageName = string;
    }

    @Override
    public void controlChangeEvent(ControlDependencyEvent controlDependencyEvent) {
        this.conditionalControl = controlDependencyEvent.getConditionalControl();
        Object object = this.conditionalControl.getSelection();
        this.conditionalControl.removeControlDependencyEventListener(this);
        if (object instanceof String) {
            this.processRules((String)object);
        } else if (object instanceof String[]) {
            this.processRules((String[])object);
        }
        this.conditionalControl.addControlDependencyEventListener(this);
    }

    private void processRules(String[] stringArray) {
        ArrayList<AbstractControl> arrayList = new ArrayList<AbstractControl>();
        ArrayList<Item_dependency> arrayList2 = new ArrayList<Item_dependency>();
        int n = 0;
        while (n < stringArray.length) {
            ArrayList<Item_dependency> object = this.getItemDependencies(this.conditionalControl.getControlItems(), stringArray[n]);
            arrayList2.addAll(object);
            this.getDependentControls(object, arrayList);
            ++n;
        }
        for (AbstractControl abstractControl : arrayList) {
            ArrayList<Item_dependencyRuleType> arrayList3 = this.getRules(abstractControl.getItemTypeKey(), arrayList2);
            if (arrayList3.contains(Item_dependencyRuleType.ITEMS_ALLOWED) && abstractControl instanceof IMultiItemControl) {
                this.setItemsAllowed(arrayList2, (IMultiItemControl)((Object)abstractControl));
            }
            if (arrayList3.contains(Item_dependencyRuleType.MIN_REQUIRED)) {
                this.setMinRequired(arrayList2, (IMultiSelectionControl)((Object)abstractControl));
            }
            if (arrayList3.contains(Item_dependencyRuleType.MAX_ALLOWED)) {
                this.setMaxAllowed(arrayList2, (IMultiSelectionControl)((Object)abstractControl));
            }
            if (arrayList3.contains(Item_dependencyRuleType.RESET)) {
                this.resetControl(arrayList2, abstractControl);
            }
            if (arrayList3.contains(Item_dependencyRuleType.CTRL_DEPENDENCIES_ENABLED_FALSE) || arrayList3.contains(Item_dependencyRuleType.CTRL_DEPENDENCIES_ENABLED_TRUE)) {
                if (arrayList3.contains(Item_dependencyRuleType.CTRL_DEPENDENCIES_ENABLED_TRUE)) {
                    abstractControl.setControlDependenciesRequired(true);
                } else {
                    abstractControl.setControlDependenciesRequired(false);
                }
            }
            if (arrayList3.contains(Item_dependencyRuleType.ENABLE_FALSE) || arrayList3.contains(Item_dependencyRuleType.ENABLE_TRUE)) {
                if (arrayList3.contains(Item_dependencyRuleType.ENABLE_TRUE)) {
                    abstractControl.setEnabled(true);
                } else {
                    abstractControl.setEnabled(false);
                }
            }
            if (arrayList3.contains(Item_dependencyRuleType.REQUIRED_FALSE) || arrayList3.contains(Item_dependencyRuleType.REQUIRED_TRUE)) {
                if (arrayList3.contains(Item_dependencyRuleType.REQUIRED_TRUE)) {
                    abstractControl.setRequired(true);
                } else {
                    abstractControl.setRequired(false);
                }
            }
            if (arrayList3.contains(Item_dependencyRuleType.REQUIRED_TRUE_ALWAYS) || arrayList3.contains(Item_dependencyRuleType.REQUIRED_FALSE_ALWAYS)) {
                if (arrayList3.contains(Item_dependencyRuleType.REQUIRED_TRUE_ALWAYS)) {
                    abstractControl.setRequiredWhenDisabled(true);
                } else {
                    abstractControl.setRequiredWhenDisabled(false);
                }
            }
            abstractControl.addControlValidationEvent(new ControlValidationEvent(abstractControl));
        }
    }

    private void setMinRequired(ArrayList<Item_dependency> arrayList, IMultiSelectionControl iMultiSelectionControl) {
        for (Item_dependency item_dependency : arrayList) {
            if (item_dependency.getRule() != Item_dependencyRuleType.MIN_REQUIRED || !this.getDependentControl(item_dependency).equals(iMultiSelectionControl)) continue;
            iMultiSelectionControl.setMinimumRequired(item_dependency.getNumber_allowed());
        }
    }

    private void setMaxAllowed(ArrayList<Item_dependency> arrayList, IMultiSelectionControl iMultiSelectionControl) {
        for (Item_dependency item_dependency : arrayList) {
            if (item_dependency.getRule() != Item_dependencyRuleType.MAX_ALLOWED || !this.getDependentControl(item_dependency).equals(iMultiSelectionControl)) continue;
            iMultiSelectionControl.setMaximumAllowed(item_dependency.getNumber_allowed());
        }
    }

    private void setItemsAllowed(ArrayList<Item_dependency> arrayList, IMultiItemControl iMultiItemControl) {
        for (Item_dependency item_dependency : arrayList) {
            if (item_dependency.getRule() != Item_dependencyRuleType.ITEMS_ALLOWED || !this.getDependentControl(item_dependency).equals(iMultiItemControl)) continue;
            if (item_dependency.getOs_Rule() != null && item_dependency.getOs_Rule() == Item_dependencyOSRuleType.REQUIRED_TRUE && iMultiItemControl instanceof CheckTableControl) {
                ((CheckTableControl)iMultiItemControl).setItemsAllowed(item_dependency, null);
                continue;
            }
            iMultiItemControl.setItemsAllowed(item_dependency.getAllowedItemIds());
        }
    }

    private void resetControl(ArrayList<Item_dependency> arrayList, IControl iControl) {
        for (Item_dependency item_dependency : arrayList) {
            if (item_dependency.getRule() != Item_dependencyRuleType.RESET || !this.getDependentControl(item_dependency).equals(iControl)) continue;
            iControl.setSelection((String[])this.wizard.getControlManager().getItemNames(item_dependency.getItk_ref()).toArray());
        }
    }

    private void processRules(String string) {
        ArrayList<Item_dependency> arrayList = this.getItemDependencies(this.conditionalControl.getControlItems(), string);
        if (arrayList == null) {
            return;
        }
        for (Item_dependency item_dependency : arrayList) {
            AbstractControl abstractControl = this.getDependentControl(item_dependency);
            if (abstractControl == null) continue;
            int n = item_dependency.getRule().getType();
            switch (n) {
                case 4: {
                    if (!(abstractControl instanceof IMultiItemControl)) break;
                    ((IMultiItemControl)((Object)abstractControl)).setItemsAllowed(item_dependency.getAllowedItemIds());
                    break;
                }
                case 5: {
                    if (!(abstractControl instanceof IMultiSelectionControl)) break;
                    ((IMultiSelectionControl)((Object)abstractControl)).setMaximumAllowed(item_dependency.getNumber_allowed());
                    break;
                }
                case 6: {
                    if (!(abstractControl instanceof IMultiSelectionControl)) break;
                    ((IMultiSelectionControl)((Object)abstractControl)).setMinimumRequired(item_dependency.getNumber_allowed());
                    break;
                }
                case 3: {
                    abstractControl.setRequired(false);
                    break;
                }
                case 2: {
                    abstractControl.setRequired(true);
                    break;
                }
                case 10: {
                    abstractControl.setRequiredWhenDisabled(true);
                    abstractControl.setRequired(true);
                    break;
                }
                case 9: {
                    abstractControl.setControlDependenciesRequired(false);
                    break;
                }
                case 8: {
                    abstractControl.setControlDependenciesRequired(true);
                    break;
                }
                case 1: {
                    abstractControl.setEnabled(false);
                    break;
                }
                case 0: {
                    abstractControl.setEnabled(true);
                    break;
                }
                case 7: {
                    abstractControl.setSelection((String[])this.wizard.getControlManager().getItemNames(item_dependency.getItk_ref()).toArray());
                    break;
                }
                default: {
                    return;
                }
            }
            abstractControl.addControlValidationEvent(new ControlValidationEvent(abstractControl));
        }
    }

    public ArrayList<Item_dependency> getItemDependencies(Items items, String string) {
        if (items == null) {
            return null;
        }
        int n = items.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(items.getItem(n2).getItem_name())) {
                return new ArrayList<Item_dependency>((Collection)Arrays.asList(items.getItem(n2).getItem_dependency()));
            }
            ++n2;
        }
        return null;
    }

    public void getDependentControls(ArrayList<Item_dependency> arrayList, ArrayList<AbstractControl> arrayList2) {
        Iterator<Item_dependency> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            AbstractControl abstractControl = this.getDependentControl(iterator.next());
            if (abstractControl == null || arrayList2.contains(abstractControl)) continue;
            arrayList2.add(abstractControl);
        }
    }

    private ArrayList<Item_dependencyRuleType> getRules(String string, ArrayList<Item_dependency> arrayList) {
        ArrayList<Item_dependencyRuleType> arrayList2 = new ArrayList<Item_dependencyRuleType>();
        for (Item_dependency item_dependency : arrayList) {
            if (!item_dependency.getItk_ref().equalsIgnoreCase(string)) continue;
            arrayList2.add(item_dependency.getRule());
        }
        return arrayList2;
    }

    private AbstractControl getDependentControl(Item_dependency item_dependency) {
        IControl iControl;
        block6: {
            String string;
            block5: {
                string = item_dependency.getPage_ref();
                if (string == null) {
                    string = this.condPageName;
                }
                try {
                    if (this.wizard.getPage(string) != null) break block5;
                    return null;
                }
                catch (KeyNotFoundException keyNotFoundException) {
                    WizardLogger.writeLogMessage(1, keyNotFoundException);
                    return null;
                }
            }
            iControl = ((AbstractWizardPage)this.wizard.getPage(string)).getControlByItemType(item_dependency.getItk_ref());
            if (iControl != null) break block6;
            return null;
        }
        return (AbstractControl)iControl;
    }
}

