/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.Platform;

public class WizardLogger {
    private static Logger logger = Logger.getLogger((String)WizardLogger.class.getName());
    private static WizardLogger wizlogger = null;

    private WizardLogger() {
        FileAppender fileAppender = new FileAppender();
        fileAppender.setImmediateFlush(true);
        SimpleLayout simpleLayout = new SimpleLayout();
        fileAppender.setLayout((Layout)simpleLayout);
        fileAppender.setEncoding("ASCII");
        fileAppender.setThreshold(Priority.toPriority((int)1000));
        String string = String.valueOf(Platform.getInstallLocation().getURL().getPath()) + "logs";
        File file = new File(string);
        file.mkdirs();
        try {
            fileAppender.setWriter((Writer)new FileWriter(new File(file, "log.txt")));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        logger.addAppender((Appender)fileAppender);
        logger.info((Object)Calendar.getInstance().getTime().toString());
    }

    public static void writeLogMessage(int n, Throwable throwable) {
        throwable.printStackTrace();
        if (wizlogger != null) {
            switch (n) {
                case 1: {
                    logger.error((Object)("Error:" + throwable.getMessage()));
                    break;
                }
                case 2: {
                    logger.info((Object)("Info:" + throwable.getMessage()));
                    break;
                }
                case 3: {
                    logger.debug((Object)("Debug:" + throwable.getMessage()));
                    break;
                }
                case 4: {
                    logger.warn((Object)("Warning:" + throwable.getMessage()));
                    break;
                }
                case 5: {
                    logger.fatal((Object)("Fatal:" + throwable.getMessage()));
                }
            }
        } else {
            wizlogger = new WizardLogger();
            WizardLogger.writeLogMessage(n, throwable);
        }
    }
}

