/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.managers;

import com.intel.wizards.dom.KeyParsingException;
import com.intel.wizards.logger.WizardLogger;
import com.intel.wizards.managers.IControlManager;
import com.intel.wizards.xml.Control;
import com.intel.wizards.xml.Controls;
import com.intel.wizards.xml.Item_dependency;
import com.intel.wizards.xml.Items;
import com.intel.wizards.xml.Page;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Vector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlManager
implements IControlManager {
    protected HashMap<String, Control> controlMap;
    protected Controls controls;
    private File workingFile;

    public ControlManager(File file) {
        this.workingFile = file;
        this.controlMap = new HashMap();
        this.readControlsXmlFile();
        this.createDataStructure();
    }

    private void readControlsXmlFile() {
        try {
            FileReader fileReader = new FileReader(this.workingFile);
            this.controls = (Controls)Unmarshaller.unmarshal(Controls.class, (Reader)fileReader);
            ((Reader)fileReader).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            WizardLogger.writeLogMessage(1, fileNotFoundException);
        }
        catch (ValidationException validationException) {
            WizardLogger.writeLogMessage(1, validationException);
        }
        catch (MarshalException marshalException) {
            WizardLogger.writeLogMessage(1, marshalException);
        }
        catch (IOException iOException) {
            WizardLogger.writeLogMessage(1, iOException);
        }
    }

    @Override
    public Control getControlObject(String string) throws KeyParsingException {
        if (this.controlMap.containsKey(string)) {
            return this.controlMap.get(string);
        }
        throw new KeyParsingException(String.valueOf(string) + "  Key not found in ControlManager!!");
    }

    @Override
    public String[] getControlPages(String string) {
        Vector<String> vector = new Vector<String>();
        int n = this.controls.getControlsItemCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.controls.getControlsItem(n2).getPageCount();
            int n4 = 0;
            while (n4 < n3) {
                Control control = this.controls.getControlsItem(n2).getControl(n4);
                String string2 = control.getItem_type_key();
                if (string.equals(string2)) {
                    int n5 = this.controls.getControlsItem(n2).getPageCount();
                    int n6 = 0;
                    while (n6 < n5) {
                        Page page = this.controls.getControlsItem(n2).getPage(n6);
                        String string3 = page.getPage_key();
                        vector.add(string3);
                        ++n6;
                    }
                    return (String[])vector.toArray();
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private void createDataStructure() {
        if (this.controls == null) {
            return;
        }
        int n = this.controls.getControlsItemCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.controls.getControlsItem(n2).getControlCount();
            int n4 = 0;
            while (n4 < n3) {
                Control control = this.controls.getControlsItem(n2).getControl(n4);
                String string = control.getItem_type_key();
                this.controlMap.put(string, control);
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public boolean isDependencyExists(String string) {
        Control control = this.controlMap.get(string);
        int n = 0;
        Items items = control.getItems();
        if (items == null) {
            return false;
        }
        int n2 = items.getItemCount();
        if (n2 == 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            n = items.getItem(n3).getItem_dependencyCount();
            if (n > 0) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public Item_dependency[] getDependentControls(String string, String string2) {
        Vector<Item_dependency> vector = new Vector<Item_dependency>();
        Control control = this.controlMap.get(string);
        Items items = control.getItems();
        int n = items.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            String string3 = items.getItem(n2).getItem_name();
            if (string2.equals(string3)) {
                int n3 = items.getItem(n2).getItem_dependencyCount();
                int n4 = 0;
                while (n4 < n3) {
                    Item_dependency item_dependency = items.getItem(n2).getItem_dependency(n4);
                    vector.addElement(item_dependency);
                    ++n4;
                }
            }
            ++n2;
        }
        Item_dependency[] item_dependencyArray = new Item_dependency[vector.size()];
        int n5 = 0;
        while (n5 < vector.size()) {
            item_dependencyArray[n5] = (Item_dependency)vector.get(n5);
            ++n5;
        }
        return item_dependencyArray;
    }

    @Override
    public Vector<String> getItemNames(String string) {
        Control control = this.controlMap.get(string);
        Vector<String> vector = new Vector<String>();
        Items items = control.getItems();
        if (items == null) {
            return vector;
        }
        int n = items.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            vector.add(items.getItem(n2).getItem_name());
            ++n2;
        }
        return vector;
    }

    @Override
    public Items getItemsObject(String string) {
        Control control = this.controlMap.get(string);
        return control.getItems();
    }
}

